/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import javax.realtime.MemoryArea;
import javolution.lang.Text;
import javolution.realtime.ObjectFactory;
import javolution.realtime.ObjectPool;
import javolution.realtime.Realtime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RealtimeObject
implements Realtime {
    private transient Pool _pool;
    private transient RealtimeObject _next;
    private transient RealtimeObject _previous;
    private transient int _preserved;

    protected RealtimeObject() {
    }

    public final String toString() {
        return this.toText().stringValue();
    }

    @Override
    public Text toText() {
        return Text.valueOf(this.getClass().getName()).concat(Text.valueOf('@')).concat(Text.valueOf(System.identityHashCode(this), 16));
    }

    public final <T> T export() {
        this.move(Realtime.ObjectSpace.OUTER);
        return (T)this;
    }

    public final <T> T moveHeap() {
        this.move(Realtime.ObjectSpace.HEAP);
        return (T)this;
    }

    public final <T> T preserve() {
        this.move(Realtime.ObjectSpace.HOLD);
        return (T)this;
    }

    public final <T> T unpreserve() {
        this.move(Realtime.ObjectSpace.STACK);
        return (T)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean move(Realtime.ObjectSpace objectSpace) {
        if (objectSpace == Realtime.ObjectSpace.OUTER) {
            if (this._pool == null || !this._pool.isLocal()) {
                return false;
            }
            Pool pool = (Pool)this._pool.outer;
            if (pool == null) {
                return this.move(Realtime.ObjectSpace.HEAP);
            }
            this.detach();
            Pool pool2 = pool;
            synchronized (pool2) {
                RealtimeObject realtimeObject = (RealtimeObject)pool.next();
                realtimeObject.detach();
                realtimeObject.insertBefore(this._pool._activeTail);
                realtimeObject._pool = this._pool;
                this.insertBefore(pool._next);
                this._pool = pool;
            }
            return true;
        }
        if (objectSpace == Realtime.ObjectSpace.HEAP) {
            RealtimeObject realtimeObject = this;
            synchronized (realtimeObject) {
                if (this._pool == null) {
                    return false;
                }
                Pool pool = this._pool;
                synchronized (pool) {
                    this.detach();
                    this._pool._size--;
                    this._next = null;
                    this._previous = null;
                    this._pool = null;
                    return true;
                }
            }
        }
        if (objectSpace == Realtime.ObjectSpace.HOLD) {
            RealtimeObject realtimeObject = this;
            synchronized (realtimeObject) {
                if (this._pool == null) {
                    return false;
                }
                if (this._preserved++ == 0) {
                    Pool pool = this._pool;
                    synchronized (pool) {
                        this.detach();
                        this.insertBefore(this._pool._holdTail);
                    }
                    return true;
                }
                return false;
            }
        }
        if (objectSpace == Realtime.ObjectSpace.STACK) {
            RealtimeObject realtimeObject = this;
            synchronized (realtimeObject) {
                if (this._preserved != 0 && --this._preserved == 0) {
                    if (this._pool != null) {
                        Pool pool = this._pool;
                        synchronized (pool) {
                            this.detach();
                            this.insertBefore(this._pool._next);
                        }
                    }
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    protected void recycle() {
        if (this._pool != null && this._pool.isLocal()) {
            this._pool.recycle(this);
        }
    }

    final void insertBefore(RealtimeObject realtimeObject) {
        this._previous = realtimeObject._previous;
        this._next = realtimeObject;
        this._next._previous = this;
        this._previous._next = this;
    }

    final void detach() {
        this._next._previous = this._previous;
        this._previous._next = this._next;
    }

    private static final class Bound
    extends RealtimeObject {
        private Bound() {
        }
    }

    private static final class Pool
    extends ObjectPool {
        private final Factory _factory;
        private final MemoryArea _memoryArea;
        private int _size;
        private boolean _doCleanup = true;
        private final RealtimeObject _activeHead;
        private final RealtimeObject _activeTail;
        private final RealtimeObject _holdHead;
        private final RealtimeObject _holdTail;
        private RealtimeObject _next;

        private Pool(Factory factory) {
            this._factory = factory;
            this._memoryArea = MemoryArea.getMemoryArea(this);
            this._activeHead = new Bound();
            this._activeTail = new Bound();
            this._activeHead._next = this._activeTail;
            this._activeTail._previous = this._activeHead;
            this._holdHead = new Bound();
            this._holdTail = new Bound();
            this._holdHead._next = this._holdTail;
            this._holdTail._previous = this._holdHead;
            this._next = this._activeTail;
        }

        public int size() {
            return this._size;
        }

        public Object next() {
            RealtimeObject realtimeObject = this._next;
            this._next = realtimeObject._next;
            return this._next != null ? realtimeObject : this.allocate();
        }

        private RealtimeObject allocate() {
            this._next = this._activeTail;
            this._memoryArea.executeInArea(new Runnable(){

                public void run() {
                    RealtimeObject realtimeObject = (RealtimeObject)Pool.this._factory.create();
                    Pool.this._size++;
                    realtimeObject.insertBefore(Pool.this._activeTail);
                    realtimeObject._pool = Pool.this;
                }
            });
            return this._activeTail._previous;
        }

        public void recycle(Object object) {
            RealtimeObject realtimeObject;
            if (this._doCleanup) {
                try {
                    this._factory.cleanup(object);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this._doCleanup = false;
                }
            }
            if ((realtimeObject = (RealtimeObject)object)._pool != this) {
                throw new IllegalArgumentException("Object not in the pool");
            }
            realtimeObject.detach();
            realtimeObject.insertBefore(this._next);
            this._next = this._next._previous;
        }

        protected void recycleAll() {
            if (this._doCleanup) {
                try {
                    RealtimeObject realtimeObject = this._activeHead._next;
                    while (realtimeObject != this._next) {
                        this._factory.cleanup(realtimeObject);
                        realtimeObject = realtimeObject._next;
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this._doCleanup = false;
                }
            }
            this._next = this._activeHead._next;
        }

        protected void clearAll() {
            this._activeHead._next = this._activeTail;
            this._activeTail._previous = this._activeHead;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Factory<T extends RealtimeObject>
    extends ObjectFactory<T> {
        private Pool _cachedPool = new Pool(null);

        protected Factory() {
        }

        @Override
        public final T object() {
            Pool pool = this._cachedPool;
            if (pool.user == Thread.currentThread()) {
                RealtimeObject realtimeObject = pool._next;
                return (T)((pool._next = realtimeObject._next) != null ? realtimeObject : pool.allocate());
            }
            ObjectPool objectPool = this.currentPool();
            if (objectPool == this.heapPool()) {
                return (T)((RealtimeObject)this.create());
            }
            this._cachedPool = pool = (Pool)objectPool;
            return (T)((RealtimeObject)pool.next());
        }

        @Override
        protected ObjectPool<T> newPool() {
            Pool pool = new Pool(this);
            return pool;
        }
    }
}

