/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.GeneticFuzzyAprioriDC;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.GeneticFuzzyAprioriDC.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.GeneticFuzzyAprioriDC.Chromosome;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.GeneticFuzzyAprioriDC.FuzzyAttribute;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.GeneticFuzzyAprioriDC.FuzzyDataset;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.GeneticFuzzyAprioriDC.FuzzyRegion;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.GeneticFuzzyAprioriDC.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.GeneticFuzzyAprioriDC.Item;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.GeneticFuzzyAprioriDC.Itemset;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.GeneticFuzzyAprioriDC.MembershipFunction;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.GeneticFuzzyAprioriDC.myDataset;
import org.core.Randomize;

public class GeneticFuzzyAprioriDCProcess {
    private int nEvaluations;
    private int popSize;
    private double pm;
    private double pc;
    private double d;
    private int nFuzzyRegionsForNumericAttributes;
    private boolean useMaxForOneFrequentItemsets;
    private double minSupport;
    private double minConfidence;
    private myDataset dataset;
    private int nEval;
    private int nGenerations;
    private int evaluationStep;
    private String geneticLearningLog;
    private ArrayList<Integer> idOfAttributes;
    private ArrayList<FuzzyAttribute> fuzzyAttributes;
    private int countOneFrequentItemsets;
    private int countFrequentItemsets;
    private ArrayList<AssociationRule> associationRulesSet;
    private boolean[] coveredRecords;

    public GeneticFuzzyAprioriDCProcess(myDataset dataset, int nEvaluations, int popSize, double pm, double pc, double d, int nFuzzyRegionsForNumericAttributes, boolean useMaxForOneFrequentItemsets, double minSupport, double minConfidence) {
        this.nEvaluations = nEvaluations;
        this.popSize = popSize;
        this.pm = pm;
        this.pc = pc;
        this.d = d;
        this.nFuzzyRegionsForNumericAttributes = nFuzzyRegionsForNumericAttributes;
        this.useMaxForOneFrequentItemsets = useMaxForOneFrequentItemsets;
        this.minSupport = minSupport;
        this.minConfidence = minConfidence;
        this.dataset = dataset;
        this.nEval = 0;
        this.nGenerations = 0;
        this.evaluationStep = (int)Math.ceil((double)nEvaluations * 0.05);
        this.idOfAttributes = dataset.getIDsOfNumericAttributes();
        this.countOneFrequentItemsets = 0;
        this.countFrequentItemsets = 0;
        this.associationRulesSet = new ArrayList();
        this.coveredRecords = new boolean[dataset.getnTrans()];
        for (int i = 0; i < this.coveredRecords.length; ++i) {
            this.coveredRecords[i] = false;
        }
    }

    public void run() {
        this.fuzzyAttributes = this.runGeneticAlgorithm();
        if (this.fuzzyAttributes == null) {
            this.fuzzyAttributes = new ArrayList();
        }
        this.addNominalFuzzyAttributes(this.fuzzyAttributes);
        this.runFuzzyApriori(new FuzzyDataset(this.dataset, this.fuzzyAttributes));
    }

    public ArrayList<AssociationRule> getRulesSet() {
        return this.associationRulesSet;
    }

    public void printReport(ArrayList<AssociationRule> rules) {
        double avg_sup = 0.0;
        double avg_conf = 0.0;
        double avg_ant_length = 0.0;
        double avg_interest = 0.0;
        for (int r = 0; r < rules.size(); ++r) {
            AssociationRule ar = rules.get(r);
            avg_sup += ar.getRuleSupport();
            avg_conf += ar.getConfidence();
            avg_ant_length += (double)ar.getAntecedent().size();
            avg_interest += ar.getInterestingness();
        }
        System.out.println("\nNumber of Frequent Itemsets found: " + this.countFrequentItemsets);
        System.out.println("Number of Association Rules generated: " + rules.size());
        if (!rules.isEmpty()) {
            System.out.println("Average Support: " + avg_sup / (double)rules.size());
            System.out.println("Average Confidence: " + avg_conf / (double)rules.size());
            System.out.println("Average Antecedents Length: " + avg_ant_length / (double)rules.size());
            System.out.println("Number of Covered Records (%): " + 100.0 * (double)this.countCoveredRecords() / (double)this.dataset.getnTrans());
            System.out.println("Average Interestingness: " + avg_interest / (double)rules.size());
        }
    }

    public int getNumberOfOneFrequentItemsets() {
        return this.countOneFrequentItemsets;
    }

    public String getGeneticLearningLog() {
        return this.geneticLearningLog;
    }

    public ArrayList<FuzzyAttribute> getFuzzyAttributes() {
        return this.fuzzyAttributes;
    }

    private void addNominalFuzzyAttributes(ArrayList<FuzzyAttribute> fuzzy_attributes) {
        ArrayList<Integer> id_of_nominal_attributes = this.dataset.getIDsOfNominalAttributes();
        for (int attr = 0; attr < id_of_nominal_attributes.size(); ++attr) {
            int id_attr = id_of_nominal_attributes.get(attr);
            FuzzyRegion[] fuzzy_regions = new FuzzyRegion[(int)this.dataset.getMax(id_attr) + 1];
            for (int id_region = 0; id_region < fuzzy_regions.length; ++id_region) {
                fuzzy_regions[id_region] = new FuzzyRegion();
                fuzzy_regions[id_region].setX0(this.dataset.getMin(id_attr) + (double)id_region - 1.0);
                fuzzy_regions[id_region].setX1(this.dataset.getMin(id_attr) + (double)id_region);
                fuzzy_regions[id_region].setX3(this.dataset.getMin(id_attr) + (double)id_region + 1.0);
                fuzzy_regions[id_region].setY(1.0);
                fuzzy_regions[id_region].setLabel(this.dataset.getNominalValue(id_attr, id_region));
            }
            fuzzy_attributes.add(new FuzzyAttribute(id_attr, fuzzy_regions));
        }
    }

    private ArrayList<FuzzyAttribute> runGeneticAlgorithm() {
        ArrayList<FuzzyAttribute> best_fuzzy_attrs = null;
        this.geneticLearningLog = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        this.geneticLearningLog = this.geneticLearningLog + "<genetic_learning>\n";
        if (!this.idOfAttributes.isEmpty()) {
            System.out.print("Initialing population... ");
            ArrayList<ArrayList<Chromosome>> setPop = this.initializePopulation();
            System.out.println("done [Evaluations: " + this.nEval + "].");
            while (this.nEval < this.nEvaluations) {
                best_fuzzy_attrs = new ArrayList<FuzzyAttribute>();
                ++this.nGenerations;
                System.out.print("Computing Generation #" + this.nGenerations + "... ");
                for (int ipop = 0; ipop < this.idOfAttributes.size(); ++ipop) {
                    ArrayList<Chromosome> pop = setPop.get(ipop);
                    this.crossover(pop, ipop);
                    this.mutate(pop, ipop);
                    best_fuzzy_attrs.addAll(this.select(pop, ipop));
                    System.out.println("done [Evaluations: " + this.nEval + "].");
                }
            }
        }
        this.geneticLearningLog = this.geneticLearningLog + "</genetic_learning>";
        return best_fuzzy_attrs;
    }

    private ArrayList<ArrayList<Chromosome>> initializePopulation() {
        ArrayList<ArrayList<Chromosome>> setPopInit = new ArrayList<ArrayList<Chromosome>>();
        MembershipFunction[] membership_functions = new MembershipFunction[this.nFuzzyRegionsForNumericAttributes];
        Gene[] genes = new Gene[1];
        for (int ipop = 0; ipop < this.idOfAttributes.size(); ++ipop) {
            ArrayList<Chromosome> popInit = new ArrayList<Chromosome>();
            int id_attr = this.idOfAttributes.get(ipop);
            for (int p = 0; p < this.popSize; ++p) {
                for (int m = 0; m < membership_functions.length; ++m) {
                    membership_functions[m] = new MembershipFunction();
                    membership_functions[m].setC(Randomize.RanddoubleClosed(this.dataset.getMin(id_attr), this.dataset.getMax(id_attr)));
                    membership_functions[m].setW(Randomize.RanddoubleClosed(0.0, (this.dataset.getMax(id_attr) - this.dataset.getMin(id_attr)) / 2.0));
                }
                genes[0] = new Gene(membership_functions);
                genes[0].sortMembershipFunctions();
                Chromosome chr = new Chromosome(genes);
                this.evaluateFitness(chr, ipop);
                popInit.add(chr);
            }
            setPopInit.add(popInit);
        }
        return setPopInit;
    }

    private ArrayList<FuzzyAttribute> select(ArrayList<Chromosome> pop, int attr) {
        Collections.sort(pop);
        while (pop.size() > this.popSize) {
            pop.remove(this.popSize);
        }
        return this.transformIntoFuzzyAttributes(pop.get(0), attr);
    }

    private void crossover(ArrayList<Chromosome> pop, int attr) {
        int j;
        int i;
        double rank_min = 0.75;
        double rank_max = 2.0 - rank_min;
        double factor = (rank_max - rank_min) / (double)(pop.size() - 1);
        double[] expected_values = new double[pop.size()];
        for (i = 0; i < expected_values.length; ++i) {
            expected_values[i] = 0.0;
        }
        double sum_expected_values = 0.0;
        for (i = 0; i < pop.size(); ++i) {
            int index_best_chr = -1;
            double best_fitness = 0.0;
            for (j = 0; j < pop.size(); ++j) {
                if (expected_values[j] != 0.0 || index_best_chr != -1 && !(pop.get(j).getFitness() > best_fitness)) continue;
                best_fitness = pop.get(j).getFitness();
                index_best_chr = j;
            }
            expected_values[index_best_chr] = rank_min + (double)(pop.size() - 1 - i) * factor;
            sum_expected_values += expected_values[index_best_chr];
        }
        int[] index_mating_pool = new int[expected_values.length];
        for (i = 0; i < index_mating_pool.length; ++i) {
            double sum = 0.0;
            double rnd = Randomize.RanddoubleClosed(0.0, sum_expected_values);
            for (j = 0; j < expected_values.length && !((sum += expected_values[j]) > rnd); ++j) {
            }
            index_mating_pool[i] = j;
        }
        for (i = 0; i < index_mating_pool.length; ++i) {
            j = Randomize.Randint(i, index_mating_pool.length);
            int aux = index_mating_pool[j];
            index_mating_pool[j] = index_mating_pool[i];
            index_mating_pool[i] = aux;
        }
        Object[] offsprings = new Chromosome[4];
        for (i = 0; i < index_mating_pool.length / 2; ++i) {
            Chromosome mom = pop.get(index_mating_pool[2 * i]);
            Chromosome dad = pop.get(index_mating_pool[2 * i + 1]);
            if (!(Randomize.Rand() < this.pc)) continue;
            for (j = 0; j < offsprings.length; ++j) {
                offsprings[j] = this.mma(j, mom.getGenes(), dad.getGenes());
                this.evaluateFitness((Chromosome)offsprings[j], attr);
            }
            Arrays.sort(offsprings);
            pop.add((Chromosome)offsprings[0]);
            pop.add((Chromosome)offsprings[1]);
        }
    }

    private Chromosome mma(int index, Gene[] mom_genes, Gene[] dad_genes) {
        MembershipFunction[] offspring_mfs = new MembershipFunction[this.nFuzzyRegionsForNumericAttributes];
        Gene[] offspring_genes = new Gene[this.idOfAttributes.size()];
        switch (index) {
            case 0: {
                MembershipFunction[] mom_mfs = mom_genes[0].getMembershipFunctions();
                MembershipFunction[] dad_mfs = dad_genes[0].getMembershipFunctions();
                for (int m = 0; m < offspring_mfs.length; ++m) {
                    offspring_mfs[m] = new MembershipFunction();
                    offspring_mfs[m].setC(this.d * mom_mfs[m].getC() + (1.0 - this.d) * dad_mfs[m].getC());
                    offspring_mfs[m].setW(this.d * mom_mfs[m].getW() + (1.0 - this.d) * dad_mfs[m].getW());
                }
                offspring_genes[0] = new Gene(offspring_mfs);
                offspring_genes[0].sortMembershipFunctions();
                break;
            }
            case 1: {
                MembershipFunction[] mom_mfs = mom_genes[0].getMembershipFunctions();
                MembershipFunction[] dad_mfs = dad_genes[0].getMembershipFunctions();
                for (int m = 0; m < offspring_mfs.length; ++m) {
                    offspring_mfs[m] = new MembershipFunction();
                    offspring_mfs[m].setC((1.0 - this.d) * mom_mfs[m].getC() + this.d * dad_mfs[m].getC());
                    offspring_mfs[m].setW((1.0 - this.d) * mom_mfs[m].getW() + this.d * dad_mfs[m].getW());
                }
                offspring_genes[0] = new Gene(offspring_mfs);
                offspring_genes[0].sortMembershipFunctions();
                break;
            }
            case 2: {
                MembershipFunction[] mom_mfs = mom_genes[0].getMembershipFunctions();
                MembershipFunction[] dad_mfs = dad_genes[0].getMembershipFunctions();
                for (int m = 0; m < offspring_mfs.length; ++m) {
                    offspring_mfs[m] = new MembershipFunction();
                    offspring_mfs[m].setC(Math.min(mom_mfs[m].getC(), dad_mfs[m].getC()));
                    offspring_mfs[m].setW(Math.min(mom_mfs[m].getW(), dad_mfs[m].getW()));
                }
                offspring_genes[0] = new Gene(offspring_mfs);
                offspring_genes[0].sortMembershipFunctions();
                break;
            }
            case 3: {
                MembershipFunction[] mom_mfs = mom_genes[0].getMembershipFunctions();
                MembershipFunction[] dad_mfs = dad_genes[0].getMembershipFunctions();
                for (int m = 0; m < offspring_mfs.length; ++m) {
                    offspring_mfs[m] = new MembershipFunction();
                    offspring_mfs[m].setC(Math.max(mom_mfs[m].getC(), dad_mfs[m].getC()));
                    offspring_mfs[m].setW(Math.max(mom_mfs[m].getW(), dad_mfs[m].getW()));
                }
                offspring_genes[0] = new Gene(offspring_mfs);
                offspring_genes[0].sortMembershipFunctions();
            }
        }
        return new Chromosome(offspring_genes);
    }

    private void mutate(ArrayList<Chromosome> pop, int attr) {
        for (int p = 0; p < pop.size(); ++p) {
            if (!(Randomize.Rand() < this.pm)) continue;
            Chromosome chr = new Chromosome(pop.get(p).getGenes());
            Gene[] genes = chr.getGenes();
            int id_attr = 0;
            MembershipFunction[] membership_functions = genes[id_attr].getMembershipFunctions();
            int id_region = Randomize.Randint(0, membership_functions.length);
            double w = membership_functions[id_region].getW();
            double eps = Randomize.RanddoubleClosed(-w, w);
            if (Randomize.Rand() < 0.5) {
                membership_functions[id_region].setC(membership_functions[id_region].getC() + eps);
                genes[id_attr].sortMembershipFunctions();
            } else {
                membership_functions[id_region].setW(w + eps);
            }
            this.evaluateFitness(chr, attr);
            pop.add(chr);
        }
    }

    private void evaluateFitness(Chromosome c, int attr) {
        Gene[] genes = c.getGenes();
        double suitability = 0.0;
        int id_attr = this.idOfAttributes.get(attr);
        suitability += genes[0].calculateOverlapFactor() + genes[0].calculateCoverageFactor(this.dataset.getMin(id_attr), this.dataset.getMax(id_attr));
        ArrayList<Itemset> OneFrequentItemset = this.generateOneFrequentItemsets(new FuzzyDataset(this.dataset, this.transformIntoFuzzyAttributes(c, attr)), false);
        int num_one_frequent_itemsets = OneFrequentItemset.size();
        double sumFuzzySupport = 0.0;
        for (int i = 0; i < num_one_frequent_itemsets; ++i) {
            sumFuzzySupport += OneFrequentItemset.get(i).getSupport();
        }
        double fitness = sumFuzzySupport / suitability;
        c.setNumOneFrequentItemsets(num_one_frequent_itemsets);
        c.setSuitability(suitability);
        c.setFitness(fitness);
        ++this.nEval;
        if (this.nEval % this.evaluationStep == 0) {
            this.buildXMLRecord(fitness, num_one_frequent_itemsets, suitability);
        }
    }

    private void buildXMLRecord(double fitness, int num_one_frequent_itemsets, double suitability) {
        this.geneticLearningLog = this.geneticLearningLog + "<log n_evaluations=\"" + this.nEval + "\" ";
        this.geneticLearningLog = this.geneticLearningLog + "n_generation=\"" + this.nGenerations + "\" ";
        this.geneticLearningLog = this.geneticLearningLog + "fitness=\"" + fitness + "\" ";
        this.geneticLearningLog = this.geneticLearningLog + "n_one_frequent_itemsets=\"" + num_one_frequent_itemsets + "\" ";
        this.geneticLearningLog = this.geneticLearningLog + "suitability=\"" + suitability + "\"/>\n";
    }

    private ArrayList<FuzzyAttribute> transformIntoFuzzyAttributes(Chromosome c, int attr) {
        ArrayList<FuzzyAttribute> fuzzy_attributes = new ArrayList<FuzzyAttribute>();
        Gene[] genes = c.getGenes();
        MembershipFunction[] membership_functions = genes[0].getMembershipFunctions();
        FuzzyRegion[] fuzzy_regions = new FuzzyRegion[membership_functions.length];
        for (int m = 0; m < membership_functions.length; ++m) {
            fuzzy_regions[m] = new FuzzyRegion();
            fuzzy_regions[m].setX0(membership_functions[m].getC() - membership_functions[m].getW());
            fuzzy_regions[m].setX1(membership_functions[m].getC());
            fuzzy_regions[m].setX3(membership_functions[m].getC() + membership_functions[m].getW());
            fuzzy_regions[m].setY(1.0);
            fuzzy_regions[m].setLabel("LABEL_" + m);
        }
        fuzzy_attributes.add(new FuzzyAttribute(this.idOfAttributes.get(attr), fuzzy_regions));
        return fuzzy_attributes;
    }

    private void runFuzzyApriori(FuzzyDataset fuzzyDataset) {
        int pass = 0;
        ArrayList<Itemset> current_frequent_itemsets = this.generateOneFrequentItemsets(fuzzyDataset, this.useMaxForOneFrequentItemsets);
        this.countFrequentItemsets = this.countOneFrequentItemsets = current_frequent_itemsets.size();
        System.out.println("\nPass: " + (pass + 1) + "; Total Frequent Itemsets: " + this.countFrequentItemsets);
        for (pass = 1; pass < this.dataset.getnVars() && current_frequent_itemsets.size() > 1; ++pass) {
            current_frequent_itemsets = this.generateCandidateItemsetsAndRules(fuzzyDataset, current_frequent_itemsets);
            this.countFrequentItemsets += current_frequent_itemsets.size();
            System.out.println("Pass: " + (pass + 1) + "; Total Frequent Itemsets: " + this.countFrequentItemsets + "; Total Association Rules: " + this.associationRulesSet.size());
        }
    }

    private ArrayList<Itemset> generateOneFrequentItemsets(FuzzyDataset fuzzyDataset, boolean use_max_for_one_frequent_itemsets) {
        int[] num_fuzzy_regions = fuzzyDataset.getNumberOfFuzzyRegions();
        ArrayList<Itemset> one_frequent_itemsets = new ArrayList<Itemset>();
        if (use_max_for_one_frequent_itemsets) {
            for (int id_attr = 0; id_attr < fuzzyDataset.getNumberOfFuzzyAttributes(); ++id_attr) {
                Itemset best_itemset = new Itemset();
                best_itemset.add(new Item(id_attr, 0));
                best_itemset.calculateSupport(fuzzyDataset);
                double max_support = best_itemset.getSupport();
                for (int id_region = 1; id_region < num_fuzzy_regions[id_attr]; ++id_region) {
                    Itemset itemset = new Itemset();
                    itemset.add(new Item(id_attr, id_region));
                    itemset.calculateSupport(fuzzyDataset);
                    if (!(itemset.getSupport() > max_support)) continue;
                    max_support = itemset.getSupport();
                    best_itemset = itemset;
                }
                if (!(max_support >= this.minSupport)) continue;
                one_frequent_itemsets.add(best_itemset);
            }
        } else {
            for (int id_attr = 0; id_attr < fuzzyDataset.getNumberOfFuzzyAttributes(); ++id_attr) {
                for (int id_region = 0; id_region < num_fuzzy_regions[id_attr]; ++id_region) {
                    Itemset itemset = new Itemset();
                    itemset.add(new Item(id_attr, id_region));
                    itemset.calculateSupport(fuzzyDataset);
                    if (!(itemset.getSupport() >= this.minSupport)) continue;
                    one_frequent_itemsets.add(itemset);
                }
            }
        }
        return one_frequent_itemsets;
    }

    private ArrayList<Itemset> generateCandidateItemsetsAndRules(FuzzyDataset fuzzyDataset, ArrayList<Itemset> curr_freq_itemsets) {
        int size = curr_freq_itemsets.size();
        ArrayList<Itemset> next_freq_itemsets = new ArrayList<Itemset>();
        for (int i = 0; i < size - 1; ++i) {
            Itemset i_itemset = curr_freq_itemsets.get(i);
            for (int j = i + 1; j < size; ++j) {
                Itemset j_itemset = curr_freq_itemsets.get(j);
                if (!this.isCombinable(i_itemset, j_itemset, curr_freq_itemsets)) continue;
                Itemset new_itemset = i_itemset.clone();
                new_itemset.add(j_itemset.get(j_itemset.size() - 1).clone());
                ArrayList<Integer> covered_tids = new_itemset.calculateSupport(fuzzyDataset);
                if (!(new_itemset.getSupport() >= this.minSupport)) continue;
                boolean generated_rules = this.generateRulesFromItemset(fuzzyDataset, new_itemset);
                if (generated_rules) {
                    this.markCoveredRecords(covered_tids);
                }
                next_freq_itemsets.add(new_itemset);
            }
        }
        return next_freq_itemsets;
    }

    private boolean generateRulesFromItemset(FuzzyDataset fuzzyDataset, Itemset curr_itemset) {
        boolean generated_rules = false;
        for (int i = 0; i < curr_itemset.size(); ++i) {
            Itemset antecedent = curr_itemset.clone();
            Item i_item = antecedent.remove(i);
            antecedent.calculateSupport(fuzzyDataset);
            double rule_sup = curr_itemset.getSupport();
            double ant_sup = antecedent.getSupport();
            double rule_conf = rule_sup / ant_sup;
            if (!(rule_conf >= this.minConfidence)) continue;
            Itemset consequent = new Itemset();
            consequent.add(i_item);
            consequent.calculateSupport(fuzzyDataset);
            double cons_sup = consequent.getSupport();
            double interest = rule_conf * (rule_sup / cons_sup) * (1.0 - rule_sup / (double)this.dataset.getnTrans());
            this.associationRulesSet.add(new AssociationRule(antecedent, consequent, rule_sup, ant_sup, rule_conf, cons_sup, interest));
            if (generated_rules) continue;
            generated_rules = true;
        }
        return generated_rules;
    }

    private boolean isCombinable(Itemset i_itemset, Itemset j_itemset, ArrayList<Itemset> curr_freq_itemsets) {
        if (i_itemset.size() != j_itemset.size()) {
            return false;
        }
        Item i_item = i_itemset.get(i_itemset.size() - 1);
        Item j_item = j_itemset.get(i_itemset.size() - 1);
        if (i_item.getIDAttribute() >= j_item.getIDAttribute()) {
            return false;
        }
        for (int i = 0; i < i_itemset.size() - 1; ++i) {
            i_item = i_itemset.get(i);
            if (i_item.equals(j_item = j_itemset.get(i))) continue;
            return false;
        }
        Itemset itemset = i_itemset.clone();
        itemset.add(j_itemset.get(i_itemset.size() - 1).clone());
        return !this.pruning(itemset, curr_freq_itemsets);
    }

    private boolean pruning(Itemset itemset, ArrayList<Itemset> curr_freq_itemsets) {
        for (int i = 0; i < itemset.size() - 2; ++i) {
            Itemset sub = itemset.clone();
            sub.remove(i);
            if (this.existingIntoFrequentItemsets(sub, curr_freq_itemsets)) continue;
            return true;
        }
        return false;
    }

    private boolean existingIntoFrequentItemsets(Itemset itemset, ArrayList<Itemset> curr_freq_itemsets) {
        for (int i = 0; i < curr_freq_itemsets.size(); ++i) {
            Itemset its = curr_freq_itemsets.get(i);
            if (!its.equals(itemset)) continue;
            return true;
        }
        return false;
    }

    private void markCoveredRecords(ArrayList<Integer> covered_tids) {
        for (int i = 0; i < covered_tids.size(); ++i) {
            int t = covered_tids.get(i);
            if (this.coveredRecords[t]) continue;
            this.coveredRecords[t] = true;
        }
    }

    private int countCoveredRecords() {
        int cnt_covered_records = 0;
        for (int i = 0; i < this.coveredRecords.length; ++i) {
            if (!this.coveredRecords[i]) continue;
            ++cnt_covered_records;
        }
        return cnt_covered_records;
    }
}

