/*
 * Decompiled with CFR 0.152.
 */
package jd2.xml.regression;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.regression.InterventionVariable;
import ec.tstoolkit.utilities.StringFormatter;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import jd2.xml.IXmlConverter;
import jd2.xml.regression.XmlSeq;

@XmlType(name="interventionType")
public class XmlInterventionVariable
implements IXmlConverter<InterventionVariable> {
    static final String NAME = "interventionType";
    @XmlElement(name="sequence")
    public XmlSeq[] sequence;
    @XmlElement
    public Double deltaFilter;
    @XmlElement
    public Double deltaSFilter;

    public boolean isDeltaFilterSpecified() {
        return this.deltaFilter != null;
    }

    public boolean isDeltaSFilterSpecified() {
        return this.deltaSFilter != null;
    }

    @Override
    public void copy(InterventionVariable t) {
        this.deltaFilter = t.getDelta();
        this.deltaSFilter = t.getDeltaS();
        int n = t.getCount();
        this.sequence = new XmlSeq[n];
        for (int i = 0; i < n; ++i) {
            this.sequence[i].start = StringFormatter.yearMonth((Day)t.getSequence((int)i).start);
            this.sequence[i].end = StringFormatter.yearMonth((Day)t.getSequence((int)i).end);
        }
    }

    @Override
    public InterventionVariable create() {
        if (this.sequence == null) {
            return null;
        }
        InterventionVariable ivar = new InterventionVariable();
        if (this.isDeltaFilterSpecified()) {
            ivar.setDelta(this.deltaFilter.doubleValue());
        }
        if (this.isDeltaSFilterSpecified()) {
            ivar.setDeltaS(this.deltaSFilter.doubleValue());
        }
        for (int i = 0; i < this.sequence.length; ++i) {
            ivar.add(StringFormatter.yearMonth((String)this.sequence[i].start), StringFormatter.yearMonth((String)this.sequence[i].end));
        }
        return ivar;
    }
}

