/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataBlock;
import ec.tstoolkit.timeseries.simplets.TsObservation;
import java.util.Enumeration;

public class TsDataIterator
implements Enumeration<TsObservation> {
    private TsDataBlock m_block;
    private int m_cur = 0;
    private boolean m_skip;

    public TsDataIterator(TsData TSData) {
        this.m_block = TsDataBlock.all(TSData);
        this.m_skip = true;
    }

    public TsDataIterator(TsDataBlock block) {
        this.m_block = block;
        this.m_skip = false;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.m_skip) {
            while (this.m_cur < this.m_block.data.getLength()) {
                if (Double.isFinite(this.m_block.data.get(this.m_cur))) {
                    return true;
                }
                ++this.m_cur;
            }
            return false;
        }
        return this.m_cur < this.m_block.data.getLength();
    }

    public boolean isSkippingMissings() {
        return this.m_skip;
    }

    @Override
    public TsObservation nextElement() {
        double v = this.m_block.data.get(this.m_cur);
        TsObservation obs = new TsObservation(this.m_block.start.plus(this.m_cur * this.m_block.data.getIncrement()), v);
        ++this.m_cur;
        return obs;
    }

    public void reset() {
        this.m_cur = 0;
    }

    public void setSkippingMissings(boolean val) {
        this.m_skip = val;
    }
}

