/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.special;

import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.arima.special.EasterSpec;
import ec.tstoolkit.arima.special.TradingDaysSpec;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.modelling.TsVariableDescriptor;
import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.calendars.IGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.AbstractTsVariableBox;
import ec.tstoolkit.timeseries.regression.EasterVariable;
import ec.tstoolkit.timeseries.regression.GregorianCalendarVariables;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.ITradingDaysVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.InterventionVariable;
import ec.tstoolkit.timeseries.regression.LeapYearVariable;
import ec.tstoolkit.timeseries.regression.OutlierDefinition;
import ec.tstoolkit.timeseries.regression.OutliersFactory;
import ec.tstoolkit.timeseries.regression.Ramp;
import ec.tstoolkit.timeseries.regression.StockTradingDaysVariables;
import ec.tstoolkit.timeseries.regression.TsVariableGroup;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.utilities.Comparator;
import ec.tstoolkit.utilities.Jdk6;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RegressionSpec
implements Cloneable,
InformationSetSerializable {
    static final OutliersFactory fac = new OutliersFactory(true);
    private TradingDaysSpec td_ = new TradingDaysSpec();
    private EasterSpec easter_ = new EasterSpec();
    private ArrayList<OutlierDefinition> outliers_ = new ArrayList();
    private ArrayList<Ramp> ramps_ = new ArrayList();
    private ArrayList<InterventionVariable> interventions_ = new ArrayList();
    private ArrayList<TsVariableDescriptor> users_ = new ArrayList();
    public static final String TD = "td";
    public static final String EASTER = "easter";
    public static final String OUTLIERS = "outliers";
    public static final String USER = "user";
    public static final String USERS = "user*";
    public static final String RAMPS = "ramps";
    public static final String INTERVENTION = "intervention";
    public static final String INTERVENTIONS = "intervention*";
    private static final String[] DICTIONARY = new String[]{"td", "easter", "outliers", "user*", "ramps", "intervention*"};

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, OUTLIERS), String[].class);
        dic.put(InformationSet.item(prefix, RAMPS), String[].class);
        TradingDaysSpec.fillDictionary(InformationSet.item(prefix, TD), dic);
        EasterSpec.fillDictionary(InformationSet.item(prefix, EASTER), dic);
        InterventionVariable.fillDictionary(InformationSet.item(prefix, INTERVENTIONS), dic);
        TsVariableDescriptor.fillDictionary(InformationSet.item(prefix, USERS), dic);
    }

    public void reset() {
        this.outliers_.clear();
        this.ramps_.clear();
        this.interventions_.clear();
        this.users_.clear();
    }

    public boolean isUsed() {
        return this.td_.isUsed() || this.easter_.isUsed() || !this.outliers_.isEmpty() || !this.ramps_.isEmpty() || !this.interventions_.isEmpty() || !this.users_.isEmpty();
    }

    public TradingDaysSpec getTradingDays() {
        return this.td_;
    }

    public void setTradingDays(TradingDaysSpec value) {
        if (value == null) {
            throw new IllegalArgumentException(TD);
        }
        this.td_ = value;
    }

    public EasterSpec getEaster() {
        return this.easter_;
    }

    public void setEaster(EasterSpec value) {
        if (value == null) {
            throw new IllegalArgumentException(EASTER);
        }
        this.easter_ = value;
    }

    public OutlierDefinition[] getOutliers() {
        return Jdk6.Collections.toArray(this.outliers_, OutlierDefinition.class);
    }

    public void setOutliers(OutlierDefinition[] value) {
        this.outliers_.clear();
        if (value != null) {
            Collections.addAll(this.outliers_, value);
        }
    }

    public TsVariableDescriptor[] getUserDefinedVariables() {
        return Jdk6.Collections.toArray(this.users_, TsVariableDescriptor.class);
    }

    public void setUserDefinedVariables(TsVariableDescriptor[] value) {
        this.users_.clear();
        if (value != null) {
            Collections.addAll(this.users_, value);
        }
    }

    public InterventionVariable[] getInterventionVariables() {
        return Jdk6.Collections.toArray(this.interventions_, InterventionVariable.class);
    }

    public void setInterventionVariables(InterventionVariable[] value) {
        this.interventions_.clear();
        if (value != null) {
            Collections.addAll(this.interventions_, value);
        }
    }

    public boolean isDefault() {
        return !this.td_.isUsed() && !this.easter_.isUsed() && this.users_.isEmpty() && this.outliers_.isEmpty() && this.interventions_.isEmpty() && this.ramps_.isEmpty();
    }

    public void add(TsVariableDescriptor svar) {
        this.users_.add(svar);
    }

    public void add(OutlierDefinition outlier) {
        this.outliers_.add(outlier);
    }

    public boolean contains(OutlierDefinition outlier) {
        for (OutlierDefinition def : this.outliers_) {
            if (!def.equals((Object)outlier)) continue;
            return true;
        }
        return false;
    }

    public void add(IOutlierVariable outlier) {
        this.outliers_.add(new OutlierDefinition(outlier.getPosition(), outlier.getCode()));
    }

    public void add(InterventionVariable ivar) {
        this.interventions_.add(ivar);
    }

    public void clearUserDefinedVariables() {
        this.users_.clear();
    }

    public int getUserDefinedVariablesCount() {
        return this.users_.size();
    }

    public TsVariableDescriptor getUserDefinedVariable(int idx) {
        return this.users_.get(idx);
    }

    public void clearOutliers() {
        this.outliers_.clear();
    }

    public int getOutliersCount() {
        return this.outliers_.size();
    }

    public OutlierDefinition getOutlier(int idx) {
        return this.outliers_.get(idx);
    }

    public void clearInterventionVariables() {
        this.interventions_.clear();
    }

    public int getInterventionVariablesCount() {
        return this.interventions_.size();
    }

    public InterventionVariable getInterventionVariable(int idx) {
        return this.interventions_.get(idx);
    }

    public void clearRamps() {
        this.ramps_.clear();
    }

    public int getRampsCount() {
        return this.ramps_.size();
    }

    public Ramp getRamp(int idx) {
        return this.ramps_.get(idx);
    }

    public void add(Ramp rp) {
        this.ramps_.add(rp);
    }

    public Ramp[] getRamps() {
        return Jdk6.Collections.toArray(this.ramps_, Ramp.class);
    }

    public void setRamps(Ramp[] value) {
        this.ramps_.clear();
        if (value != null) {
            Collections.addAll(this.ramps_, value);
        }
    }

    public RegressionSpec clone() {
        try {
            RegressionSpec spec = (RegressionSpec)super.clone();
            spec.interventions_ = new ArrayList();
            for (InterventionVariable ii : this.interventions_) {
                spec.interventions_.add(ii.clone());
            }
            spec.outliers_ = Jdk6.newArrayList(this.outliers_);
            spec.ramps_ = new ArrayList();
            for (Ramp r : this.ramps_) {
                spec.ramps_.add(r.clone());
            }
            spec.td_ = this.td_.clone();
            spec.easter_ = this.easter_.clone();
            spec.users_ = new ArrayList();
            for (TsVariableDescriptor var : this.users_) {
                spec.users_.add(var.clone());
            }
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof RegressionSpec && this.equals((RegressionSpec)obj);
    }

    private boolean equals(RegressionSpec other) {
        return Comparator.equals(this.interventions_, other.interventions_) && Comparator.equals(this.users_, other.users_) && Comparator.equals(this.ramps_, other.ramps_) && Comparator.equals(this.outliers_, other.outliers_) && Objects.equals(this.td_, other.td_) && Objects.equals(this.easter_, other.easter_);
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + this.td_.hashCode();
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet cur;
        int i;
        InformationSet cinfo;
        if (!this.isUsed()) {
            return null;
        }
        InformationSet specInfo = new InformationSet();
        if ((verbose || this.td_.isUsed()) && (cinfo = this.td_.write(verbose)) != null) {
            specInfo.add(TD, cinfo);
        }
        if ((verbose || this.easter_.isUsed()) && (cinfo = this.easter_.write(verbose)) != null) {
            specInfo.add(EASTER, cinfo);
        }
        if (!this.outliers_.isEmpty()) {
            String[] outliers = new String[this.outliers_.size()];
            for (i = 0; i < outliers.length; ++i) {
                outliers[i] = this.outliers_.get(i).toString();
            }
            specInfo.add(OUTLIERS, outliers);
        }
        if (!this.ramps_.isEmpty()) {
            String[] ramps = new String[this.ramps_.size()];
            for (i = 0; i < ramps.length; ++i) {
                ramps[i] = this.ramps_.get(i).toString();
            }
            specInfo.add(RAMPS, ramps);
        }
        int idx = 1;
        for (TsVariableDescriptor desc : this.users_) {
            cur = desc.write(verbose);
            if (cur == null) continue;
            specInfo.add(USER + Integer.toString(idx++), cur);
        }
        idx = 1;
        for (InterventionVariable ivar : this.interventions_) {
            cur = ivar.write(verbose);
            if (cur == null) continue;
            specInfo.add(INTERVENTION + Integer.toString(idx++), cur);
        }
        return specInfo;
    }

    @Override
    public boolean read(InformationSet info) {
        String[] ramps;
        boolean tok;
        this.reset();
        InformationSet cinfo = info.getSubSet(TD);
        if (cinfo != null && !(tok = this.td_.read(cinfo))) {
            return false;
        }
        cinfo = info.getSubSet(EASTER);
        if (cinfo != null && !(tok = this.easter_.read(cinfo))) {
            return false;
        }
        String[] outliers = info.get(OUTLIERS, String[].class);
        if (outliers != null) {
            for (int i = 0; i < outliers.length; ++i) {
                OutlierDefinition o = OutlierDefinition.fromString(outliers[i]);
                if (o == null) {
                    return false;
                }
                this.outliers_.add(o);
            }
        }
        if ((ramps = info.get(RAMPS, String[].class)) != null) {
            for (int i = 0; i < ramps.length; ++i) {
                Ramp r = Ramp.fromString(ramps[i]);
                if (r == null) {
                    return false;
                }
                this.ramps_.add(r);
            }
        }
        List<Information<InformationSet>> usel = info.select(USERS, InformationSet.class);
        for (Information information : usel) {
            TsVariableDescriptor cur = new TsVariableDescriptor();
            if (!cur.read((InformationSet)information.value)) continue;
            this.users_.add(cur);
        }
        List<Information<InformationSet>> isel = info.select(INTERVENTIONS, InformationSet.class);
        for (Information<InformationSet> item : isel) {
            InterventionVariable cur = new InterventionVariable();
            if (!cur.read((InformationSet)item.value)) continue;
            this.interventions_.add(cur);
        }
        return true;
    }

    public void fill(TsVariableList regs, TsFrequency freq, ProcessingContext context) {
        this.initializeTradingDays(regs, context);
        this.initializeEaster(regs);
        this.initializeOutliers(regs, freq);
        this.initializeRamps(regs);
        this.initializeInterventions(regs);
        this.initializeUsers(regs, context);
    }

    private void initializeTradingDays(TsVariableList regs, ProcessingContext context) {
        if (!this.td_.isUsed()) {
            return;
        }
        if (this.td_.isStockTradingDays()) {
            this.initializeStockTradingDays(regs);
        }
        if (this.td_.getHolidays() != null) {
            this.initializeHolidays(regs, context);
        } else if (this.td_.getUserVariables() != null) {
            this.initializeUserHolidays(regs, context);
        } else if (this.td_.getTradingDaysType() != TradingDaysType.None) {
            this.initializeDefaultTradingDays(regs);
        }
    }

    private void initializeEaster(TsVariableList regs) {
        if (!this.easter_.isUsed()) {
            return;
        }
        EasterVariable var = new EasterVariable();
        var.setDuration(this.easter_.getDuration());
        var.setType(EasterVariable.Correction.Simple);
        var.includeEaster(this.easter_.getOption().containsEaster());
        var.includeEasterMonday(this.easter_.getOption().containsEasterMonday());
        regs.add(var);
    }

    private void initializeOutliers(TsVariableList regs, TsFrequency freq) {
        ArrayList var = new ArrayList();
        ArrayList pvar = new ArrayList();
        for (OutlierDefinition outlier : this.outliers_) {
            IOutlierVariable v = fac.make(outlier);
            regs.add(v);
        }
    }

    private void initializeUsers(TsVariableList regs, ProcessingContext context) {
        for (TsVariableDescriptor desc : this.users_) {
            ITsVariable var = desc.toTsVariable(context);
            if (var == null) continue;
            regs.add(var);
        }
    }

    private void initializeInterventions(TsVariableList regs) {
        for (InterventionVariable var : this.interventions_) {
            regs.add(var);
        }
    }

    private void initializeRamps(TsVariableList regs) {
        if (this.ramps_ == null) {
            return;
        }
        for (Ramp ramp : this.ramps_) {
            regs.add(ramp);
        }
    }

    private void initializeHolidays(TsVariableList regs, ProcessingContext context) {
        IGregorianCalendarProvider cal = (IGregorianCalendarProvider)context.getGregorianCalendars().get(this.td_.getHolidays());
        if (cal == null) {
            return;
        }
        TradingDaysType tdType = this.td_.getTradingDaysType();
        GregorianCalendarVariables var = new GregorianCalendarVariables(cal, tdType);
        regs.add(var);
        if (this.td_.isLeapYear()) {
            LeapYearVariable lp = new LeapYearVariable(LengthOfPeriodType.LeapYear);
            regs.add(lp);
        }
    }

    private void initializeUserHolidays(TsVariableList regs, ProcessingContext context) {
        String[] userVariables = this.td_.getUserVariables();
        if (userVariables == null || userVariables.length == 0) {
            return;
        }
        ITsVariable[] vars = new ITsVariable[userVariables.length];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = context.getTsVariable(userVariables[i]);
            if (vars[i] != null) continue;
            throw new TsException(userVariables[i] + " not found");
        }
        TsVariableGroup var = new TsVariableGroup("User-defined calendar variables", vars);
        ITradingDaysVariable td = AbstractTsVariableBox.tradingDays(var);
        regs.add(td);
    }

    private void initializeDefaultTradingDays(TsVariableList regs) {
        TradingDaysType tdType = this.td_.getTradingDaysType();
        GregorianCalendarVariables var = GregorianCalendarVariables.getDefault(tdType);
        regs.add(var);
        if (this.td_.isLeapYear()) {
            LeapYearVariable lp = new LeapYearVariable(LengthOfPeriodType.LeapYear);
            regs.add(lp);
        }
    }

    private void initializeStockTradingDays(TsVariableList regs) {
        StockTradingDaysVariables var = new StockTradingDaysVariables(this.td_.getStockTradingDays());
        regs.add(var);
    }
}

