/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.configure;

import choco.kernel.solver.Configuration;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.search.restart.GeometricalRestartStrategy;
import choco.kernel.solver.search.restart.LubyRestartStrategy;
import choco.kernel.solver.search.restart.UniversalRestartStrategy;

public final class RestartFactory {
    private RestartFactory() {
    }

    public static void setLubyRestartPolicy(Solver solver, int base, int grow) {
        Configuration conf = solver.getConfiguration();
        conf.putTrue("cp.restart.luby");
        conf.putFalse("cp.restart.geometrical");
        conf.putInt("cp.restart.base", base);
        conf.putInt("cp.restart.luby.grow", grow);
    }

    public static void setGeometricalRestartPolicy(Solver solver, int base, double grow) {
        Configuration conf = solver.getConfiguration();
        conf.putFalse("cp.restart.luby");
        conf.putTrue("cp.restart.geometrical");
        conf.putInt("cp.restart.base", base);
        conf.putDouble("cp.restart.geometrical.grow", grow);
    }

    public static void setRecordNogoodFromRestart(Solver solver) {
        solver.getConfiguration().putTrue("cp.restart.nogood_recording");
    }

    public static void unsetRecordNogoodFromRestart(Solver solver) {
        solver.getConfiguration().putFalse("cp.restart.nogood_recording");
    }

    public static void cancelRestarts(Solver solver) {
        Configuration conf = solver.getConfiguration();
        conf.putFalse("cp.restart.after_solution");
        conf.putFalse("cp.restart.luby");
        conf.putFalse("cp.restart.geometrical");
        conf.remove("cp.restart.nogood_recording");
        conf.remove("cp.restart.base");
        conf.remove("cp.restart.luby.grow");
        conf.remove("cp.restart.geometrical.grow");
        conf.remove("cp.restart.policy.limit.type");
    }

    public static UniversalRestartStrategy createRestartStrategy(Solver solver) {
        Configuration conf = solver.getConfiguration();
        boolean bL = conf.readBoolean("cp.restart.luby");
        boolean bG = conf.readBoolean("cp.restart.geometrical");
        if (bL) {
            if (bG) {
                throw new SolverException("Invalid Restart Settings: Two policies");
            }
            return new LubyRestartStrategy(conf.readInt("cp.restart.base"), conf.readInt("cp.restart.luby.grow"));
        }
        if (bG) {
            return new GeometricalRestartStrategy(conf.readInt("cp.restart.base"), conf.readDouble("cp.restart.geometrical.grow"));
        }
        return null;
    }
}

