/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Map;
import java.util.Vector;

public class MathematicalExpression {
    public static TreeNode parse(String string) throws Exception {
        Tokenizer tokenizer = new Tokenizer(new StringReader(string));
        tokenizer.nextToken();
        TreeNode treeNode = MathematicalExpression.parseExp(tokenizer);
        if (tokenizer.ttype != -1) {
            throw new Exception("Syntax Error: end of file expected.");
        }
        return treeNode;
    }

    protected static TreeNode parseExp(Tokenizer tokenizer) throws Exception {
        Vector<TreeNode> vector = new Vector<TreeNode>();
        vector.add(MathematicalExpression.parseTerm(tokenizer));
        switch (tokenizer.ttype) {
            case 43: {
                tokenizer.nextToken();
                vector.add(MathematicalExpression.parseExp(tokenizer));
                return new TreeNode(43, vector);
            }
            case 45: {
                tokenizer.nextToken();
                vector.add(MathematicalExpression.parseExp(tokenizer));
                return new TreeNode(45, vector);
            }
        }
        return (TreeNode)vector.get(0);
    }

    protected static TreeNode parseTerm(Tokenizer tokenizer) throws Exception {
        Vector<TreeNode> vector = new Vector<TreeNode>();
        vector.add(MathematicalExpression.parseAtom(tokenizer));
        switch (tokenizer.ttype) {
            case 42: {
                tokenizer.nextToken();
                vector.add(MathematicalExpression.parseTerm(tokenizer));
                return new TreeNode(42, vector);
            }
            case 47: {
                tokenizer.nextToken();
                vector.add(MathematicalExpression.parseTerm(tokenizer));
                return new TreeNode(47, vector);
            }
        }
        return (TreeNode)vector.get(0);
    }

    protected static TreeNode parseAtom(Tokenizer tokenizer) throws Exception {
        switch (tokenizer.ttype) {
            case -2: {
                TreeNode treeNode = new TreeNode(tokenizer.nval);
                tokenizer.nextToken();
                return treeNode;
            }
            case 40: {
                tokenizer.nextToken();
                TreeNode treeNode = MathematicalExpression.parseExp(tokenizer);
                if (tokenizer.ttype != 41) {
                    throw new Exception("Syntax Error: ')' expected.");
                }
                tokenizer.nextToken();
                return treeNode;
            }
            case 45: {
                tokenizer.nextToken();
                Vector<TreeNode> vector = new Vector<TreeNode>(1);
                vector.add(MathematicalExpression.parseAtom(tokenizer));
                return new TreeNode(45, vector);
            }
            case -5: {
                TreeNode treeNode = new TreeNode(tokenizer.sval);
                tokenizer.nextToken();
                return treeNode;
            }
            case -7: {
                tokenizer.nextToken();
                if (tokenizer.ttype != 40) {
                    throw new Exception("Syntax Error: '(' expected.");
                }
                tokenizer.nextToken();
                Vector<TreeNode> vector = new Vector<TreeNode>(3);
                vector.add(MathematicalExpression.parseDisjunction(tokenizer));
                if (tokenizer.ttype != 44) {
                    throw new Exception("Syntax Error: ',' expected.");
                }
                tokenizer.nextToken();
                vector.add(MathematicalExpression.parseExp(tokenizer));
                if (tokenizer.ttype != 44) {
                    throw new Exception("Syntax Error: ',' expected.");
                }
                tokenizer.nextToken();
                vector.add(MathematicalExpression.parseExp(tokenizer));
                if (tokenizer.ttype != 41) {
                    throw new Exception("Syntax Error: ',' expected.");
                }
                tokenizer.nextToken();
                return new TreeNode(vector);
            }
            case -6: {
                String string = tokenizer.sval;
                tokenizer.nextToken();
                if (tokenizer.ttype != 40) {
                    throw new Exception("Syntax Error: '(' expected.");
                }
                tokenizer.nextToken();
                Vector<TreeNode> vector = new Vector<TreeNode>(1);
                vector.add(MathematicalExpression.parseExp(tokenizer));
                while (tokenizer.ttype == 44) {
                    tokenizer.nextToken();
                    vector.add(MathematicalExpression.parseExp(tokenizer));
                }
                if (tokenizer.ttype != 41) {
                    throw new Exception("Syntax Error: ')' expected.");
                }
                tokenizer.nextToken();
                return new TreeNode(string, vector);
            }
        }
        throw new Exception("Syntax Error: Unexpected token");
    }

    protected static TreeNode parseDisjunction(Tokenizer tokenizer) throws Exception {
        Vector<TreeNode> vector = new Vector<TreeNode>(2);
        vector.add(MathematicalExpression.parseConjunction(tokenizer));
        if (tokenizer.ttype != 124) {
            return (TreeNode)vector.get(0);
        }
        tokenizer.nextToken();
        vector.add(MathematicalExpression.parseDisjunction(tokenizer));
        return new TreeNode(124, vector);
    }

    protected static TreeNode parseConjunction(Tokenizer tokenizer) throws Exception {
        Vector<TreeNode> vector = new Vector<TreeNode>(2);
        vector.add(MathematicalExpression.parseNumTest(tokenizer));
        if (tokenizer.ttype != 38) {
            return (TreeNode)vector.get(0);
        }
        tokenizer.nextToken();
        vector.add(MathematicalExpression.parseConjunction(tokenizer));
        return new TreeNode(38, vector);
    }

    protected static TreeNode parseNumTest(Tokenizer tokenizer) throws Exception {
        switch (tokenizer.ttype) {
            case 91: {
                tokenizer.nextToken();
                TreeNode treeNode = MathematicalExpression.parseDisjunction(tokenizer);
                if (tokenizer.ttype != 93) {
                    throw new Exception("']' expected");
                }
                tokenizer.nextToken();
                return treeNode;
            }
            case 33: {
                tokenizer.nextToken();
                if (tokenizer.ttype != 91) {
                    throw new Exception("'[' expected after '!'");
                }
                tokenizer.nextToken();
                TreeNode treeNode = MathematicalExpression.parseDisjunction(tokenizer);
                if (tokenizer.ttype != 93) {
                    throw new Exception("']' expected");
                }
                tokenizer.nextToken();
                return new TreeNode(treeNode);
            }
        }
        Vector<TreeNode> vector = new Vector<TreeNode>(2);
        vector.add(MathematicalExpression.parseExp(tokenizer));
        int n = tokenizer.ttype;
        if (n != 60 && n != 62 && n != 61) {
            throw new Exception("Unknow test " + (char)tokenizer.ttype);
        }
        tokenizer.nextToken();
        vector.add(MathematicalExpression.parseExp(tokenizer));
        return new TreeNode(n, vector);
    }

    public static double evaluate(String string, Map map) throws Exception {
        return MathematicalExpression.evaluate(MathematicalExpression.parse(string), map);
    }

    public static double evaluate(TreeNode treeNode, Map map) throws Exception {
        return treeNode.eval(map);
    }

    public static class TreeNode
    implements Serializable {
        static final long serialVersionUID = -654720966350007711L;
        public static String[] funs = new String[]{"abs", "sqrt", "log", "exp", "sin", "cos", "tan", "rint", "floor", "pow", "ceil"};
        public static int[] arity = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1};
        int type;
        double nval;
        String sval = null;
        TreeNode[] operands = null;

        public TreeNode(double d) {
            this.type = -2;
            this.nval = d;
        }

        public TreeNode(TreeNode treeNode) {
            this.type = 33;
            this.operands = new TreeNode[1];
            this.operands[0] = treeNode;
        }

        public TreeNode(String string) {
            this.type = -5;
            this.sval = string;
        }

        public TreeNode(Vector vector) {
            this.type = -7;
            this.operands = new TreeNode[vector.size()];
            for (int i = 0; i < this.operands.length; ++i) {
                this.operands[i] = (TreeNode)vector.elementAt(i);
            }
        }

        public TreeNode(String string, Vector vector) throws Exception {
            int n;
            for (n = 0; n < funs.length && !funs[n].equals(string); ++n) {
            }
            if (n >= funs.length) {
                throw new Exception("Unknow function " + string);
            }
            if (arity[n] != vector.size()) {
                throw new Exception("Wrong Number of argument in " + string);
            }
            this.type = -6;
            this.nval = n;
            this.operands = new TreeNode[vector.size()];
            for (n = 0; n < this.operands.length; ++n) {
                this.operands[n] = (TreeNode)vector.elementAt(n);
            }
        }

        public TreeNode(int n, Vector vector) throws Exception {
            this.type = n;
            this.operands = new TreeNode[vector.size()];
            for (int i = 0; i < this.operands.length; ++i) {
                this.operands[i] = (TreeNode)vector.elementAt(i);
            }
        }

        public double eval(Map map) throws Exception {
            switch (this.type) {
                case -2: {
                    return this.nval;
                }
                case -5: {
                    if (!map.containsKey(this.sval)) {
                        throw new Exception("Unknow symbol " + this.sval);
                    }
                    return (Double)map.get(this.sval);
                }
                case 43: {
                    return this.operands[0].eval(map) + this.operands[1].eval(map);
                }
                case 45: {
                    if (this.operands.length > 1) {
                        return this.operands[0].eval(map) - this.operands[1].eval(map);
                    }
                    return -this.operands[0].eval(map);
                }
                case 42: {
                    return this.operands[0].eval(map) * this.operands[1].eval(map);
                }
                case 47: {
                    return this.operands[0].eval(map) / this.operands[1].eval(map);
                }
                case 62: {
                    return this.operands[0].eval(map) > this.operands[1].eval(map) ? 1.0 : 0.0;
                }
                case 60: {
                    return this.operands[0].eval(map) < this.operands[1].eval(map) ? 1.0 : 0.0;
                }
                case 61: {
                    return this.operands[0].eval(map) == this.operands[1].eval(map) ? 1.0 : 0.0;
                }
                case 38: {
                    return this.operands[0].eval(map) == 1.0 && this.operands[1].eval(map) == 1.0 ? 1.0 : 0.0;
                }
                case 124: {
                    return this.operands[0].eval(map) == 1.0 || this.operands[1].eval(map) == 1.0 ? 1.0 : 0.0;
                }
                case 33: {
                    return this.operands[0].eval(map) == 1.0 ? 0.0 : 1.0;
                }
                case -6: {
                    switch ((int)this.nval) {
                        case 0: {
                            return Math.abs(this.operands[0].eval(map));
                        }
                        case 1: {
                            return Math.sqrt(this.operands[0].eval(map));
                        }
                        case 2: {
                            return Math.log(this.operands[0].eval(map));
                        }
                        case 3: {
                            return Math.exp(this.operands[0].eval(map));
                        }
                        case 4: {
                            return Math.sin(this.operands[0].eval(map));
                        }
                        case 5: {
                            return Math.cos(this.operands[0].eval(map));
                        }
                        case 6: {
                            return Math.tan(this.operands[0].eval(map));
                        }
                        case 7: {
                            return Math.rint(this.operands[0].eval(map));
                        }
                        case 8: {
                            return Math.floor(this.operands[0].eval(map));
                        }
                        case 9: {
                            return Math.pow(this.operands[0].eval(map), this.operands[1].eval(map));
                        }
                        case 10: {
                            return Math.ceil(this.operands[0].eval(map));
                        }
                    }
                    throw new Exception("Unknow Function");
                }
                case -7: {
                    return this.operands[0].eval(map) == 1.0 ? this.operands[1].eval(map) : this.operands[2].eval(map);
                }
            }
            throw new Exception("Unknow Tree Node Type.");
        }
    }

    public static class Tokenizer
    extends StreamTokenizer {
        static final int TT_VAR = -5;
        static final int TT_FUN = -6;
        static final int TT_IFELSE = -7;

        public Tokenizer(Reader reader) {
            super(reader);
            this.resetSyntax();
            this.parseNumbers();
            this.whitespaceChars(32, 32);
            this.wordChars(97, 122);
            this.wordChars(65, 90);
            this.ordinaryChar(45);
        }

        public int nextToken() throws IOException {
            super.nextToken();
            if (this.ttype == -3) {
                this.ttype = this.sval.equals("ifelse") ? -7 : (Character.isUpperCase(this.sval.charAt(0)) ? -5 : -6);
            }
            return this.ttype;
        }
    }
}

