/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.ssf.ISsfData;

public class SsfRefData
implements ISsfData,
Cloneable {
    private final IReadDataBlock m_data;
    private final IReadDataBlock m_a0;

    public SsfRefData(IReadDataBlock data, IReadDataBlock a0) {
        this.m_data = data;
        this.m_a0 = a0;
    }

    public Object clone() {
        return new SsfRefData(this.m_data, this.m_a0);
    }

    @Override
    public double get(int n) {
        return n >= this.m_data.getLength() ? Double.NaN : this.m_data.get(n);
    }

    @Override
    public int getCount() {
        return this.m_data.getLength();
    }

    @Override
    public double[] getInitialState() {
        if (this.m_a0 == null) {
            return null;
        }
        double[] a0 = new double[this.m_a0.getLength()];
        this.m_a0.copyTo(a0, 0);
        return a0;
    }

    @Override
    public int getObsCount() {
        int n = 0;
        for (int i = 0; i < this.m_data.getLength(); ++i) {
            if (Double.isNaN(this.m_data.get(i))) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean hasData() {
        return true;
    }

    @Override
    public boolean hasMissingValues() {
        for (int i = 0; i < this.m_data.getLength(); ++i) {
            if (!Double.isNaN(this.m_data.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMissing(int pos) {
        return pos >= this.m_data.getLength() || Double.isNaN(this.m_data.get(pos));
    }
}

