/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.tramo.SeasonalityTests;
import ec.tstoolkit.stats.NiidTests;
import ec.tstoolkit.timeseries.simplets.TsFrequency;

public class ModelVerifier {
    private static final double OUT = 0.03;
    private static final double NORMAL = 6.0;
    private static final double SKEWNESS = 2.576;
    private static final double RUNS = 2.576;
    private static final double QSTAT = 0.05;
    private static final double QS = 6.0;
    private static final double MEAN = 0.01;
    NiidTests niid;

    public boolean accept(ModellingContext context) {
        int nz = context.estimation.getRegArima().getObsCount();
        if ((double)context.description.getOutliers().size() > 0.03 * (double)nz) {
            return false;
        }
        this.niid = context.estimation.getNiidTests();
        if (this.niid.getNormalityTest().getValue() > 6.0) {
            return false;
        }
        if (this.niid.getLjungBox().getPValue() < 0.05) {
            return false;
        }
        if (this.niid.getSkewness().getValue() > 2.576) {
            return false;
        }
        if (this.niid.getRuns().getValue() > 2.576) {
            return false;
        }
        if (this.niid.getMeanTest().getPValue() < 0.01) {
            return false;
        }
        int ifreq = context.description.getFrequency();
        if (ifreq > 1) {
            if (this.niid.getSeasonalLjungBox().getValue() > 6.0) {
                return false;
            }
            SeasonalityTests stests = SeasonalityTests.residualSeasonalityTest(context.estimation.getLikelihood().getResiduals(), TsFrequency.valueOf(ifreq));
            if (stests.getScore() > 1) {
                return false;
            }
        }
        return true;
    }
}

