/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.demetra;

import ec.tstoolkit.maths.realfunctions.IFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ProxyMinimizer;
import ec.tstoolkit.maths.realfunctions.levmar.LevenbergMarquardtMethod;
import ec.tstoolkit.modelling.arima.RegArimaEstimator;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.estimation.GlsSarimaMonitor;
import ec.tstoolkit.sarima.estimation.SarimaInitializer;

public abstract class DemetraModule {
    protected IFunctionMinimizer minimizer = new ProxyMinimizer(new LevenbergMarquardtMethod());

    protected DemetraModule() {
        this.minimizer.setConvergenceCriterion(1.0E-5);
    }

    public IFunctionMinimizer getMinimizer() {
        return this.minimizer;
    }

    public GlsSarimaMonitor monitor() {
        GlsSarimaMonitor monitor = new GlsSarimaMonitor();
        monitor.setMinimizer(this.minimizer.exemplar());
        return monitor;
    }

    public GlsSarimaMonitor monitor(SarimaInitializer initializer) {
        GlsSarimaMonitor monitor = new GlsSarimaMonitor(initializer);
        monitor.setMinimizer(this.minimizer.exemplar());
        return monitor;
    }

    public RegArimaEstimator estimator(IParametricMapping<SarimaModel> mapping) {
        RegArimaEstimator monitor = new RegArimaEstimator(mapping);
        monitor.setMinimizer(this.minimizer.exemplar());
        return monitor;
    }

    public void setMinimizer(IFunctionMinimizer minimizer) {
        this.minimizer = minimizer;
    }

    public void setPrecision(double eps) {
        this.minimizer.setConvergenceCriterion(eps);
    }
}

