/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.maths.matrices.Matrix;
import java.util.Arrays;

public final class SparseSystemSolver {
    private SparseSystemSolver() {
    }

    public static boolean solve(Matrix A) {
        int n = A.getRowsCount();
        int nl = A.getColumnsCount();
        int l = nl - n;
        int[] m = new int[nl];
        Arrays.fill(m, -1);
        for (int i = 0; i < n; ++i) {
            double u = Double.MIN_VALUE;
            int icur = -1;
            for (int k = 0; k < n; ++k) {
                double a;
                double absa;
                if (m[k] != -1 || !((absa = Math.abs(a = A.get(i, k))) > u)) continue;
                icur = k;
                u = absa;
            }
            if (icur < 0) {
                return false;
            }
            m[icur] = i;
            double pivot = 1.0 / A.get(i, icur);
            if (Math.abs(pivot) <= 1.0E-15) {
                pivot = 0.0;
            }
            for (int j = 0; j < n; ++j) {
                double a;
                if (j == i || !(Math.abs(a = A.get(j, icur)) >= 1.0E-13)) continue;
                double fac = pivot * a;
                for (int k = 0; k < nl; ++k) {
                    double aik = A.get(i, k);
                    if (Math.abs(aik) <= 1.0E-15) {
                        A.set(i, k, 0.0);
                        aik = 0.0;
                    }
                    if (m[k] != -1) continue;
                    A.add(j, k, -fac * aik);
                }
            }
            for (int k = 0; k < nl; ++k) {
                if (m[k] != -1) continue;
                A.mul(i, k, pivot);
            }
        }
        double[] b = new double[n];
        for (int k = n; k < nl; ++k) {
            int i;
            for (i = 0; i < n; ++i) {
                if (m[i] == -1) continue;
                b[i] = A.get(m[i], k);
            }
            for (i = 0; i < n; ++i) {
                A.set(i, k, b[i]);
            }
        }
        return true;
    }
}

