% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rebuild.R
\name{rebuild}
\alias{rebuild}
\title{Rebuild the Packages in your Project Library}
\usage{
rebuild(
  packages = NULL,
  recursive = TRUE,
  ...,
  type = NULL,
  prompt = interactive(),
  library = NULL,
  project = NULL
)
}
\arguments{
\item{packages}{The package(s) to be rebuilt. When \code{NULL}, all packages
in the library will be reinstalled.}

\item{recursive}{Boolean; should dependencies of packages be rebuilt
recursively? Defaults to \code{TRUE}.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, \code{renv} will signal an error.}

\item{type}{The type of package to install ("source" or "binary"). Defaults
to the value of \code{getOption("pkgType")}.}

\item{prompt}{Boolean; prompt the user before taking any action? For backwards
compatibility, \code{confirm} is accepted as an alias for \code{prompt}.}

\item{library}{The \R library to be used. When \code{NULL}, the active project
library will be used instead.}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
A named list of package records which were installed by \code{renv}.
}
\description{
Rebuild and reinstall packages in your library. This can be useful as a
diagnostic tool -- for example, if you find that one or more of your
packages fail to load, and you want to ensure that you are starting from a
clean slate.
}
\examples{
\dontrun{

# rebuild the 'dplyr' package + all of its dependencies
renv::rebuild("dplyr", recursive = TRUE)

# rebuild only 'dplyr'
renv::rebuild("dplyr", recursive = FALSE)

}
}
