/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.visu;

import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.visu.DotManager;
import choco.kernel.visu.GnuplotManager;
import choco.kernel.visu.IVisuManager;
import choco.kernel.visu.TextManager;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class VisuFactory {
    protected static final Logger LOGGER = ChocoLogging.getMainLogger();

    private VisuFactory() {
    }

    public static IVisuManager getGnuplotManager() {
        return GnuplotManager.getInstance();
    }

    public static IVisuManager getDotManager() {
        return DotManager.getInstance();
    }

    public static IVisuManager getTextManager() {
        return TextManager.getInstance();
    }

    public static IVisuManager getSolManager() {
        return new TextManager("sol");
    }

    public static void launchCommand(boolean waitFor, String ... cmd) {
        try {
            Runtime r = Runtime.getRuntime();
            Process p = r.exec(cmd);
            if (waitFor) {
                p.waitFor();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "exec...[" + Arrays.toString(cmd) + "][FAIL]", e);
        }
    }
}

