/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search.limit;

import choco.kernel.solver.search.measure.ISearchMeasures;

public enum Limit {
    TIME("Time (ms)"),
    NODE("Nodes"),
    BACKTRACK("Backtracks"),
    FAIL("Fails"),
    SOLUTION("Solutions"),
    RESTART("Restarts"),
    CUSTOM(""),
    UNDEF("");

    private final String unit;

    private Limit(String unit) {
        this.unit = unit;
    }

    public final String getUnit() {
        return this.unit;
    }

    public final int getValue(ISearchMeasures measures) {
        switch (this) {
            case TIME: {
                return measures.getTimeCount();
            }
            case NODE: {
                return measures.getNodeCount();
            }
            case BACKTRACK: {
                return measures.getBackTrackCount();
            }
            case RESTART: {
                return measures.getRestartCount();
            }
            case FAIL: {
                return measures.getFailCount();
            }
        }
        return Integer.MIN_VALUE;
    }
}

