/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.global.automata.fast_regular.structure;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.global.automata.common.StoredIndexedBipartiteSetWithOffset;
import choco.kernel.solver.constraints.global.automata.fast_regular.structure.Arc;
import choco.kernel.solver.constraints.global.automata.fast_regular.structure.Node;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntStack;
import java.util.Set;
import org.jgrapht.graph.DirectedMultigraph;

public class StoredDirectedMultiGraph {
    AbstractIntSConstraint constraint;
    int[] starts;
    int[] offsets;
    StoredIndexedBipartiteSetWithOffset[] supports;
    public Nodes GNodes;
    public Arcs GArcs;
    TIntStack stack = new TIntStack();

    public StoredDirectedMultiGraph(IEnvironment environment, AbstractIntSConstraint constraint, DirectedMultigraph<Node, Arc> graph, int[] starts, int[] offsets, int supportLength) {
        this.constraint = constraint;
        this.starts = starts;
        this.offsets = offsets;
        this.GNodes = new Nodes();
        this.GArcs = new Arcs();
        TIntHashSet[] sups = new TIntHashSet[supportLength];
        this.supports = new StoredIndexedBipartiteSetWithOffset[supportLength];
        Set arcs = graph.edgeSet();
        this.GArcs.values = new int[arcs.size()];
        this.GArcs.dests = new int[arcs.size()];
        this.GArcs.origs = new int[arcs.size()];
        for (Arc a : arcs) {
            this.GArcs.values[a.id] = a.value;
            this.GArcs.dests[a.id] = a.dest.id;
            this.GArcs.origs[a.id] = a.orig.id;
            int idx = starts[a.orig.layer] + a.value - offsets[a.orig.layer];
            if (sups[idx] == null) {
                sups[idx] = new TIntHashSet();
            }
            sups[idx].add(a.id);
        }
        for (int i = 0; i < sups.length; ++i) {
            if (sups[i] == null) continue;
            this.supports[i] = new StoredIndexedBipartiteSetWithOffset(environment, sups[i].toArray());
        }
        Set nodes = graph.vertexSet();
        this.GNodes.outArcs = new StoredIndexedBipartiteSetWithOffset[nodes.size()];
        this.GNodes.inArcs = new StoredIndexedBipartiteSetWithOffset[nodes.size()];
        this.GNodes.layers = new int[nodes.size()];
        this.GNodes.states = new int[nodes.size()];
        for (Node n : nodes) {
            Set inarc;
            int i;
            this.GNodes.layers[n.id] = n.layer;
            this.GNodes.states[n.id] = n.state;
            Set outarc = graph.outgoingEdgesOf(n);
            if (!outarc.isEmpty()) {
                int[] out = new int[outarc.size()];
                i = 0;
                for (Arc a : outarc) {
                    out[i++] = a.id;
                }
                this.GNodes.outArcs[n.id] = new StoredIndexedBipartiteSetWithOffset(environment, out);
            }
            if ((inarc = graph.incomingEdgesOf(n)).isEmpty()) continue;
            int[] in = new int[inarc.size()];
            i = 0;
            for (Arc a : inarc) {
                in[i++] = a.id;
            }
            this.GNodes.inArcs[n.id] = new StoredIndexedBipartiteSetWithOffset(environment, in);
        }
    }

    public final StoredIndexedBipartiteSetWithOffset getSupport(int i, int j) {
        int idx = this.starts[i] + j - this.offsets[i];
        return this.supports[idx];
    }

    public void removeArc(int arcId) throws ContradictionException {
        int id;
        DisposableIntIterator it;
        StoredIndexedBipartiteSetWithOffset in;
        int orig = this.GArcs.origs[arcId];
        int dest = this.GArcs.dests[arcId];
        int layer = this.GNodes.layers[orig];
        int value = this.GArcs.values[arcId];
        StoredIndexedBipartiteSetWithOffset support = this.getSupport(layer, value);
        support.remove(arcId);
        if (support.isEmpty()) {
            IntDomainVar var = (IntDomainVar)this.constraint.getVar(layer);
            try {
                var.removeVal(value, this.constraint, false);
            }
            catch (ContradictionException ce) {
                this.stack.clear();
                throw ce;
            }
        }
        StoredIndexedBipartiteSetWithOffset out = this.GNodes.outArcs[orig];
        out.remove(arcId);
        if (this.GNodes.layers[orig] > 0 && out.isEmpty()) {
            in = this.GNodes.inArcs[orig];
            it = in.getIterator();
            while (it.hasNext()) {
                id = it.next();
                this.stack.push(id);
            }
            it.dispose();
        }
        in = this.GNodes.inArcs[dest];
        in.remove(arcId);
        if (this.GNodes.layers[dest] < this.constraint.getNbVars() && in.isEmpty()) {
            out = this.GNodes.outArcs[dest];
            it = out.getIterator();
            while (it.hasNext()) {
                id = it.next();
                this.stack.push(id);
            }
            it.dispose();
        }
        while (this.stack.size() != 0) {
            this.removeArc(this.stack.pop());
        }
    }

    public class Arcs {
        int[] values;
        int[] dests;
        int[] origs;
    }

    class Nodes {
        int[] states;
        int[] layers;
        StoredIndexedBipartiteSetWithOffset[] outArcs;
        StoredIndexedBipartiteSetWithOffset[] inArcs;

        Nodes() {
        }
    }
}

