/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling.precedence;

import choco.cp.solver.constraints.global.scheduling.precedence.ITemporalSRelation;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.tools.TaskUtils;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.TaskVar;

public abstract class AbstractPrecedenceSConstraint
extends AbstractLargeIntSConstraint
implements ITemporalSRelation {
    protected static final int BIDX = 0;
    protected TaskVar task1;
    protected TaskVar task2;
    protected int k1;
    protected int k2;
    protected Boolean reuseBool;

    public AbstractPrecedenceSConstraint(IntDomainVar[] vars) {
        super(ConstraintEvent.LINEAR, vars);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return idx == 0 ? 8 : 11;
    }

    public final void setTasks(TaskVar t1, TaskVar t2) {
        this.task1 = t1;
        this.task2 = t2;
    }

    @Override
    public final TaskVar getOrigin() {
        return this.task1;
    }

    @Override
    public final TaskVar getDestination() {
        return this.task2;
    }

    @Override
    public IntDomainVar getDirection() {
        return ((IntDomainVar[])this.vars)[0];
    }

    @Override
    public final boolean isFixed() {
        return ((IntDomainVar[])this.vars)[0].isInstantiated();
    }

    @Override
    public int getDirVal() {
        return ((IntDomainVar[])this.vars)[0].getVal();
    }

    @Override
    public final int backwardSetup() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public final int forwardSetup() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    protected final void propagate(int idx1, int idx2) throws ContradictionException {
        ((IntDomainVar[])this.vars)[idx2].updateInf(((IntDomainVar[])this.vars)[idx1].getInf(), this, false);
        ((IntDomainVar[])this.vars)[idx1].updateSup(((IntDomainVar[])this.vars)[idx2].getSup(), this, false);
    }

    protected final void propagate(int idx1, int k1, int idx2) throws ContradictionException {
        ((IntDomainVar[])this.vars)[idx2].updateInf(((IntDomainVar[])this.vars)[idx1].getInf() + k1, this, false);
        ((IntDomainVar[])this.vars)[idx1].updateSup(((IntDomainVar[])this.vars)[idx2].getSup() - k1, this, false);
    }

    public abstract void propagateP1() throws ContradictionException;

    public abstract void propagateP2() throws ContradictionException;

    protected final Boolean isEntailed(int idx1, int idx2) {
        if (((IntDomainVar[])this.vars)[idx1].getSup() <= ((IntDomainVar[])this.vars)[idx2].getInf()) {
            return Boolean.TRUE;
        }
        if (((IntDomainVar[])this.vars)[idx1].getInf() > ((IntDomainVar[])this.vars)[idx2].getSup()) {
            return Boolean.FALSE;
        }
        return null;
    }

    protected final Boolean isEntailed(int idx1, int k1, int idx2) {
        if (((IntDomainVar[])this.vars)[idx1].getSup() + k1 <= ((IntDomainVar[])this.vars)[idx2].getInf()) {
            return Boolean.TRUE;
        }
        if (((IntDomainVar[])this.vars)[idx1].getInf() + k1 > ((IntDomainVar[])this.vars)[idx2].getSup()) {
            return Boolean.FALSE;
        }
        return null;
    }

    public abstract Boolean isP1Entailed();

    public abstract Boolean isP2Entailed();

    protected final boolean isSatisfied(int idx1, int idx2) {
        return ((IntDomainVar[])this.vars)[idx1].getVal() <= ((IntDomainVar[])this.vars)[idx2].getVal();
    }

    protected final boolean isSatisfied(int idx1, int k1, int idx2) {
        return ((IntDomainVar[])this.vars)[idx1].getVal() + k1 <= ((IntDomainVar[])this.vars)[idx2].getVal();
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx == 0) {
            if (((IntDomainVar[])this.vars)[0].getVal() == 1) {
                this.propagateP1();
            } else {
                this.propagateP2();
            }
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    public void filterOnP1P2TowardsB() throws ContradictionException {
        this.reuseBool = this.isP1Entailed();
        if (this.reuseBool == Boolean.TRUE) {
            ((IntDomainVar[])this.vars)[0].instantiate(1, this, false);
        } else if (this.reuseBool == Boolean.FALSE) {
            ((IntDomainVar[])this.vars)[0].instantiate(0, this, false);
            this.propagateP2();
        } else {
            this.reuseBool = this.isP2Entailed();
            if (this.reuseBool == Boolean.TRUE) {
                ((IntDomainVar[])this.vars)[0].instantiate(0, this, false);
            } else if (this.reuseBool == Boolean.FALSE) {
                ((IntDomainVar[])this.vars)[0].instantiate(1, this, false);
                this.propagateP1();
            }
        }
    }

    @Override
    public final void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        LOGGER.warning("awakeOnRemovals sould be inactive");
    }

    @Override
    public final void awakeOnSup(int idx) throws ContradictionException {
        this.awakeOnBounds(idx);
    }

    @Override
    public final void awakeOnInf(int idx) throws ContradictionException {
        this.awakeOnBounds(idx);
    }

    @Override
    public void awakeOnBounds(int idx) throws ContradictionException {
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        if (((IntDomainVar[])this.vars)[0].isInstantiatedTo(0)) {
            this.propagateP2();
        } else if (((IntDomainVar[])this.vars)[0].isInstantiatedTo(1)) {
            this.propagateP1();
        } else {
            this.filterOnP1P2TowardsB();
        }
    }

    protected final String pretty(int idx1, int k1, int idx2) {
        return ((IntDomainVar[])this.vars)[idx1] + " + " + k1 + " <= " + ((IntDomainVar[])this.vars)[idx2];
    }

    protected final String pretty(int idx1, int idx2) {
        return ((IntDomainVar[])this.vars)[idx1] + " <= " + ((IntDomainVar[])this.vars)[idx2];
    }

    protected final String pretty(String name, String trueStr, String falseStr) {
        return name + " " + ((IntDomainVar[])this.vars)[0] + " ( " + (((IntDomainVar[])this.vars)[0].isInstantiatedTo(1) ? trueStr : (((IntDomainVar[])this.vars)[0].isInstantiatedTo(0) ? falseStr : trueStr + " || " + falseStr)) + " )";
    }

    @Override
    public int getTotalSlack() {
        return TaskUtils.getTotalSlack(this.task1, this.task2);
    }

    @Override
    public double getForwardPreserved() {
        return TaskUtils.getPreserved(this.task1, this.task2);
    }

    @Override
    public double getBackwardPreserved() {
        return TaskUtils.getPreserved(this.task2, this.task1);
    }

    @Override
    public String toString() {
        return this.pretty();
    }
}

