/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.JGR.util.TableSorter;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.ibase.toolkit.TJFrame;

public class JGRPackageManager
extends TJFrame
implements ActionListener {
    private static final long serialVersionUID = -7143083791080919475L;
    public static Object[] defaultPackages;
    public static HashMap neededPackages;
    public static String remindPackages;
    private static JGRPackageManager instance;
    private final String[] columnNames = new String[]{"loaded", "default", "Package", "Description"};
    private final JScrollPane scrollArea = new JScrollPane();
    private final JButton close = new JButton("Close");
    private final JButton refresh = new JButton("Refresh");
    private final JButton dontremind = new JButton("Don't remind me again");
    private final JButton instlater = new JButton("Install later");
    private final JButton instnow = new JButton("Install now");
    private final JTable pkgTable = new JTable();
    private Object[][] Packages = null;
    private Object[][] MPackages = null;
    private TableSorter sorter;
    private PTableModel pkgModel;

    public JGRPackageManager(Vector missingpkgs) {
        super("Deleted Packages after last session:", false, 154);
        String pkgs = "";
        for (int i = 0; i < missingpkgs.size() - 1; ++i) {
            pkgs = pkgs + missingpkgs.elementAt(i) + ",";
        }
        remindPackages = pkgs = missingpkgs.elementAt(missingpkgs.size() - 1) + "";
        StringTokenizer st = new StringTokenizer(remindPackages, ",");
        this.MPackages = new Object[st.countTokens()][2];
        int i = 0;
        while (st.hasMoreTokens()) {
            this.MPackages[i][1] = st.nextToken();
            this.MPackages[i][0] = new Boolean(true);
            ++i;
        }
        this.dontremind.setActionCommand("dontremind");
        this.dontremind.addActionListener(this);
        this.instlater.setActionCommand("instlater");
        this.instlater.addActionListener(this);
        this.instnow.setActionCommand("instnow");
        this.instnow.addActionListener(this);
        this.sorter = new TableSorter(new PMTableModel(this));
        this.scrollArea.setBackground(this.getBackground());
        this.pkgTable.setBackground(this.getBackground());
        this.pkgTable.setColumnModel(new PMTableColumnModel());
        this.pkgTable.setModel(this.sorter);
        this.pkgTable.setShowGrid(false);
        this.pkgTable.setCellSelectionEnabled(false);
        this.pkgTable.setColumnSelectionAllowed(false);
        this.pkgTable.setRowSelectionAllowed(false);
        this.pkgTable.setFocusable(false);
        this.pkgTable.getTableHeader().setReorderingAllowed(false);
        this.sorter.setTableHeader(this.pkgTable.getTableHeader());
        this.scrollArea.getViewport().setBackground(this.getBackground());
        this.scrollArea.getViewport().add(this.pkgTable);
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.dontremind);
        JLabel l = new JLabel();
        l.setMinimumSize(new Dimension(10, 25));
        l.setPreferredSize(new Dimension(10, 25));
        l.setMaximumSize(new Dimension(10, 25));
        buttons.add(l);
        buttons.add(this.instlater);
        buttons.add(this.instnow);
        JPanel msg = new JPanel(new FlowLayout(1));
        msg.add(new JLabel("Last time you had the following packages installed!"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        this.getContentPane().add((Component)msg, gbc);
        gbc.anchor = 17;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.fill = 1;
        this.getContentPane().add((Component)this.scrollArea, gbc);
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.getContentPane().add((Component)buttons, gbc);
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.instnow);
        this.setLocation((JGR.MAINRCONSOLE.getSize().width - (JGRPrefs.isMac ? 450 : 350)) / 2, (JGR.MAINRCONSOLE.getSize().height - 250) / 2);
        this.setSize(550, 250);
        this.setVisible(true);
    }

    private JGRPackageManager() {
        super("Package Manager", false, 154);
        try {
            String[] Menu = new String[]{"~Window", "0"};
            EzMenuSwing.getEzMenu(this, this, Menu);
            this.close.setActionCommand("exit");
            this.close.addActionListener(this);
            this.refresh.setActionCommand("refresh");
            this.refresh.addActionListener(this);
            while (!JGR.STARTED) {
            }
            this.Packages = RController.refreshPackages();
            this.pkgModel = new PTableModel(this);
            this.sorter = new TableSorter(this.pkgModel);
            this.scrollArea.setBackground(this.getBackground());
            this.pkgTable.setBackground(this.getBackground());
            this.pkgTable.setColumnModel(new PTableColumnModel());
            this.pkgTable.setModel(this.sorter);
            this.pkgTable.setShowGrid(false);
            this.pkgTable.setCellSelectionEnabled(false);
            this.pkgTable.setColumnSelectionAllowed(false);
            this.pkgTable.setRowSelectionAllowed(false);
            this.pkgTable.setFocusable(false);
            this.pkgTable.getTableHeader().setReorderingAllowed(false);
            this.sorter.setTableHeader(this.pkgTable.getTableHeader());
            this.scrollArea.getViewport().setBackground(this.getBackground());
            this.scrollArea.getViewport().add(this.pkgTable);
            JPanel buttons = new JPanel(new FlowLayout(2));
            buttons.add(this.refresh);
            buttons.add(this.close);
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.getContentPane().add((Component)this.scrollArea, gbc);
            gbc.gridy = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            this.getContentPane().add((Component)buttons, gbc);
            this.setDefaultCloseOperation(2);
            this.getRootPane().setDefaultButton(this.close);
            this.setMinimumSize(new Dimension(300, 350));
            this.setLocation(200, 10);
            this.setSize(420, 450);
        }
        catch (Exception e) {
            new ErrorMsg(e);
        }
    }

    public static void showInstance() {
        if (instance == null) {
            instance = new JGRPackageManager();
        }
        instance.refresh();
        instance.setVisible(true);
    }

    @Override
    public void dispose() {
        instance = null;
        super.dispose();
    }

    public void exit() {
        this.setDefaultPackages();
        JGRPrefs.writePrefs();
        this.dispose();
    }

    public void refresh() {
        this.setWorking(true);
        this.setDefaultPackages();
        this.Packages = RController.refreshPackages();
        this.pkgModel = new PTableModel(this);
        this.sorter = new TableSorter(this.pkgModel);
        this.pkgTable.setModel(this.sorter);
        this.sorter.setTableHeader(this.pkgTable.getTableHeader());
        this.setWorking(false);
    }

    private void setPKGStatus(String pkg, String load) {
        this.setWorking(true);
        if (load.equals("true")) {
            JGR.MAINRCONSOLE.execute("library(" + pkg + ")", true);
        } else {
            JGR.MAINRCONSOLE.execute("detach(\"package:" + pkg + "\")", true);
        }
        this.setWorking(false);
    }

    private void setDefaultPackages() {
        ArrayList<Object> packages = new ArrayList<Object>();
        for (int i = 0; i < this.pkgModel.getRowCount(); ++i) {
            if (!this.pkgModel.getValueAt(i, 1).toString().equals("true")) continue;
            packages.add(this.pkgModel.getValueAt(i, 2));
        }
        defaultPackages = packages.toArray();
    }

    private String getSelectedPackages() {
        String pkg = "";
        for (int i = 0; i < this.MPackages.length; ++i) {
            if (!new Boolean(this.MPackages[i][0].toString()).booleanValue()) continue;
            pkg = pkg + "\"" + this.MPackages[i][1] + "\",";
        }
        return pkg.trim().length() > 0 ? pkg.substring(0, pkg.length() - 1) : null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == "dontremind") {
            remindPackages = null;
            this.dispose();
        } else if (cmd == "exit") {
            this.exit();
        } else if (cmd == "instlater") {
            remindPackages = this.getSelectedPackages();
            if (remindPackages != null) {
                remindPackages = remindPackages.replaceAll("\"", "");
            }
            this.dispose();
        } else if (cmd == "instnow") {
            this.dispose();
            remindPackages = null;
            JGR.MAINRCONSOLE.execute("install.packages(c(" + this.getSelectedPackages() + "))", true);
        } else if (cmd == "refresh") {
            this.refresh();
        }
    }

    static {
        neededPackages = new HashMap();
        remindPackages = null;
    }

    class PMTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 7291256867075798679L;
        public int cols;
        public int rows;

        public PMTableModel(JGRPackageManager pm) {
            this.rows = pm.MPackages.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return JGRPackageManager.this.MPackages[row][col];
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.rows;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            ((JGRPackageManager)JGRPackageManager.this).MPackages[row][col] = value;
        }

        @Override
        public String getColumnName(int col) {
            return col == 0 ? " " : "Package";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col <= 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class PMTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = -3303539682530550720L;

        PMTableColumnModel() {
        }

        @Override
        public void addColumn(TableColumn col) {
            if (col.getModelIndex() == 0) {
                col.setMinWidth(50);
                col.setPreferredWidth(50);
                col.setMaxWidth(50);
            }
            super.addColumn(col);
        }
    }

    class PTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 4696543490603572692L;
        public int cols;
        public int rows;

        public PTableModel(JGRPackageManager pm) {
            this.cols = pm.columnNames.length;
            this.rows = pm.Packages.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return JGRPackageManager.this.Packages[row][col];
        }

        @Override
        public int getColumnCount() {
            return this.cols;
        }

        @Override
        public int getRowCount() {
            return this.rows;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            String val;
            if (col == 0) {
                JGRPackageManager.this.setPKGStatus(this.getValueAt(row, 2).toString(), value.toString());
            }
            if (col == 1 && neededPackages.containsKey(val = this.getValueAt(row, 2).toString())) {
                value = new Boolean(true);
            }
            ((JGRPackageManager)JGRPackageManager.this).Packages[row][col] = value;
        }

        @Override
        public String getColumnName(int col) {
            return JGRPackageManager.this.columnNames[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col <= 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class PTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = 3352499532040543693L;

        @Override
        public void addColumn(TableColumn col) {
            if (col.getModelIndex() == 0 || col.getModelIndex() == 1) {
                col.setMinWidth(50);
                col.setPreferredWidth(50);
                col.setMaxWidth(50);
            } else if (col.getModelIndex() == 2) {
                col.setMinWidth(100);
                col.setMaxWidth(100);
            }
            super.addColumn(col);
        }
    }
}

