/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2DTest;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseCCMFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCMFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;

public class SparseFloatMatrix2DTest
extends FloatMatrix2DTest {
    public SparseFloatMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new SparseFloatMatrix2D(this.NROWS, this.NCOLUMNS);
        this.B = new SparseFloatMatrix2D(this.NROWS, this.NCOLUMNS);
        this.Bt = new SparseFloatMatrix2D(this.NCOLUMNS, this.NROWS);
    }

    public void testGetRowCompressed() {
        int n;
        int n2;
        int n3 = this.A.rows() * this.A.columns();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        float[] fArray = new float[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = Math.abs(random.nextInt() % this.NROWS);
            nArray2[i] = Math.abs(random.nextInt() % this.NCOLUMNS);
            fArray[i] = (float)Math.random();
        }
        SparseFloatMatrix2D sparseFloatMatrix2D = new SparseFloatMatrix2D(this.A.rows(), this.A.columns(), nArray, nArray2, fArray);
        SparseRCFloatMatrix2D sparseRCFloatMatrix2D = sparseFloatMatrix2D.getRowCompressed(false);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                SparseFloatMatrix2DTest.assertEquals((Object)Float.valueOf(sparseFloatMatrix2D.getQuick(n2, n)), (Object)Float.valueOf(sparseRCFloatMatrix2D.getQuick(n2, n)));
            }
        }
        sparseRCFloatMatrix2D = sparseFloatMatrix2D.getRowCompressed(true);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                SparseFloatMatrix2DTest.assertEquals((Object)Float.valueOf(sparseFloatMatrix2D.getQuick(n2, n)), (Object)Float.valueOf(sparseRCFloatMatrix2D.getQuick(n2, n)));
            }
        }
    }

    public void testGetRowCompressedModified() {
        int n = this.A.rows() * this.A.columns();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = Math.abs(random.nextInt() % this.NROWS);
            nArray2[i] = Math.abs(random.nextInt() % this.NCOLUMNS);
            fArray[i] = (float)Math.random();
        }
        SparseFloatMatrix2D sparseFloatMatrix2D = new SparseFloatMatrix2D(this.A.rows(), this.A.columns(), nArray, nArray2, fArray);
        SparseRCMFloatMatrix2D sparseRCMFloatMatrix2D = sparseFloatMatrix2D.getRowCompressedModified();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                SparseFloatMatrix2DTest.assertEquals((Object)Float.valueOf(sparseFloatMatrix2D.getQuick(i, j)), (Object)Float.valueOf(sparseRCMFloatMatrix2D.getQuick(i, j)));
            }
        }
    }

    public void testGetColumnCompressed() {
        int n;
        int n2;
        int n3 = this.A.rows() * this.A.columns();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        float[] fArray = new float[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = Math.abs(random.nextInt() % this.NROWS);
            nArray2[i] = Math.abs(random.nextInt() % this.NCOLUMNS);
            fArray[i] = (float)Math.random();
        }
        SparseFloatMatrix2D sparseFloatMatrix2D = new SparseFloatMatrix2D(this.A.rows(), this.A.columns(), nArray, nArray2, fArray);
        SparseCCFloatMatrix2D sparseCCFloatMatrix2D = sparseFloatMatrix2D.getColumnCompressed(false);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                SparseFloatMatrix2DTest.assertEquals((Object)Float.valueOf(sparseFloatMatrix2D.getQuick(n2, n)), (Object)Float.valueOf(sparseCCFloatMatrix2D.getQuick(n2, n)));
            }
        }
        sparseCCFloatMatrix2D = sparseFloatMatrix2D.getColumnCompressed(true);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                SparseFloatMatrix2DTest.assertEquals((Object)Float.valueOf(sparseFloatMatrix2D.getQuick(n2, n)), (Object)Float.valueOf(sparseCCFloatMatrix2D.getQuick(n2, n)));
            }
        }
    }

    public void testGetColumnCompressedModified() {
        int n = this.A.rows() * this.A.columns();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = Math.abs(random.nextInt() % this.NROWS);
            nArray2[i] = Math.abs(random.nextInt() % this.NCOLUMNS);
            fArray[i] = (float)Math.random();
        }
        SparseFloatMatrix2D sparseFloatMatrix2D = new SparseFloatMatrix2D(this.A.rows(), this.A.columns(), nArray, nArray2, fArray);
        SparseCCMFloatMatrix2D sparseCCMFloatMatrix2D = sparseFloatMatrix2D.getColumnCompressedModified();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                SparseFloatMatrix2DTest.assertEquals((Object)Float.valueOf(sparseFloatMatrix2D.getQuick(i, j)), (Object)Float.valueOf(sparseCCMFloatMatrix2D.getQuick(i, j)));
            }
        }
    }

    public void testAssignIntArrayIntArrayFloatArrayFloatFloatFunction() {
        int n = this.A.rows() * this.A.columns();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        float[] fArray = new float[n];
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(this.A.rows(), this.A.columns());
        for (int i = 0; i < n; ++i) {
            nArray[i] = i % this.A.rows();
            nArray2[i] = i % this.A.columns();
            fArray[i] = (float)Math.random();
            ((FloatMatrix2D)denseFloatMatrix2D).setQuick(nArray[i], nArray2[i], fArray[i]);
        }
        SparseFloatMatrix2D sparseFloatMatrix2D = new SparseFloatMatrix2D(this.A.rows(), this.A.columns());
        sparseFloatMatrix2D.assign(nArray, nArray2, fArray, FloatFunctions.plusMultSecond(2.0f));
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                SparseFloatMatrix2DTest.assertEquals((Object)Float.valueOf(2.0f * ((FloatMatrix2D)denseFloatMatrix2D).getQuick(i, j)), (Object)Float.valueOf(sparseFloatMatrix2D.getQuick(i, j)));
            }
        }
    }
}

