/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;

public class WrapperDComplexMatrix1D
extends DComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected DComplexMatrix1D content;

    public WrapperDComplexMatrix1D(DComplexMatrix1D dComplexMatrix1D) {
        if (dComplexMatrix1D != null) {
            this.setUp((int)dComplexMatrix1D.size());
        }
        this.content = dComplexMatrix1D;
    }

    protected DComplexMatrix1D getContent() {
        return this.content;
    }

    public synchronized double[] getQuick(int n) {
        return this.content.getQuick(n);
    }

    public Object elements() {
        return this.content.elements();
    }

    public DComplexMatrix1D like(int n) {
        return this.content.like(n);
    }

    public DComplexMatrix2D like2D(int n, int n2) {
        return this.content.like2D(n, n2);
    }

    public DComplexMatrix2D reshape(int n, int n2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public DComplexMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public synchronized void setQuick(int n, double[] dArray) {
        this.content.setQuick(n, dArray);
    }

    public synchronized void setQuick(int n, double d, double d2) {
        this.content.setQuick(n, d, d2);
    }

    public DComplexMatrix1D viewFlip() {
        WrapperDComplexMatrix1D wrapperDComplexMatrix1D = new WrapperDComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int n) {
                return this.content.getQuick(this.size - 1 - n);
            }

            public synchronized void setQuick(int n, double[] dArray) {
                this.content.setQuick(this.size - 1 - n, dArray);
            }

            public synchronized void setQuick(int n, double d, double d2) {
                this.content.setQuick(this.size - 1 - n, d, d2);
            }

            public synchronized double[] get(int n) {
                return this.content.get(this.size - 1 - n);
            }

            public synchronized void set(int n, double[] dArray) {
                this.content.set(this.size - 1 - n, dArray);
            }

            public synchronized void set(int n, double d, double d2) {
                this.content.set(this.size - 1 - n, d, d2);
            }
        };
        return wrapperDComplexMatrix1D;
    }

    public DComplexMatrix1D viewPart(final int n, int n2) {
        this.checkRange(n, n2);
        WrapperDComplexMatrix1D wrapperDComplexMatrix1D = new WrapperDComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int n2) {
                return this.content.getQuick(n + n2);
            }

            public synchronized void setQuick(int n2, double[] dArray) {
                this.content.setQuick(n + n2, dArray);
            }

            public synchronized void setQuick(int n2, double d, double d2) {
                this.content.setQuick(n + n2, d, d2);
            }

            public synchronized double[] get(int n2) {
                return this.content.get(n + n2);
            }

            public synchronized void set(int n2, double[] dArray) {
                this.content.set(n + n2, dArray);
            }

            public synchronized void set(int n2, double d, double d2) {
                this.content.set(n + n2, d, d2);
            }
        };
        wrapperDComplexMatrix1D.size = n2;
        return wrapperDComplexMatrix1D;
    }

    public DComplexMatrix1D viewSelection(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.size];
            int n = this.size;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        this.checkIndexes(nArray);
        final int[] nArray2 = nArray;
        WrapperDComplexMatrix1D wrapperDComplexMatrix1D = new WrapperDComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int n) {
                return this.content.getQuick(nArray2[n]);
            }

            public synchronized void setQuick(int n, double[] dArray) {
                this.content.setQuick(nArray2[n], dArray);
            }

            public synchronized void setQuick(int n, double d, double d2) {
                this.content.setQuick(nArray2[n], d, d2);
            }

            public synchronized double[] get(int n) {
                return this.content.get(nArray2[n]);
            }

            public synchronized void set(int n, double[] dArray) {
                this.content.set(nArray2[n], dArray);
            }

            public synchronized void set(int n, double d, double d2) {
                this.content.set(nArray2[n], d, d2);
            }
        };
        wrapperDComplexMatrix1D.size = nArray.length;
        return wrapperDComplexMatrix1D;
    }

    protected DComplexMatrix1D viewSelectionLike(int[] nArray) {
        throw new InternalError();
    }

    public DComplexMatrix1D viewStrides(final int n) {
        if (this.stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + this.stride);
        }
        WrapperDComplexMatrix1D wrapperDComplexMatrix1D = new WrapperDComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int n2) {
                return this.content.getQuick(n2 * n);
            }

            public synchronized void setQuick(int n2, double[] dArray) {
                this.content.setQuick(n2 * n, dArray);
            }

            public synchronized void setQuick(int n2, double d, double d2) {
                this.content.setQuick(n2 * n, d, d2);
            }

            public synchronized double[] get(int n2) {
                return this.content.get(n2 * n);
            }

            public synchronized void set(int n2, double[] dArray) {
                this.content.set(n2 * n, dArray);
            }

            public synchronized void set(int n2, double d, double d2) {
                this.content.set(n2 * n, d, d2);
            }
        };
        if (this.size != 0) {
            wrapperDComplexMatrix1D.size = (this.size - 1) / n + 1;
        }
        return wrapperDComplexMatrix1D;
    }

    public DoubleMatrix1D getImaginaryPart() {
        return this.content.getImaginaryPart();
    }

    public DoubleMatrix1D getRealPart() {
        return this.content.getRealPart();
    }
}

