/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.LAPACKkernel;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;

public class EVD {
    private final double[] work;
    private final int n;
    private final LAPACKkernel.JobEig jobLeft;
    private final LAPACKkernel.JobEig jobRight;
    private final double[] Wr;
    private final double[] Wi;
    private final DenseMatrix Vl;
    private final DenseMatrix Vr;

    public EVD(int n) {
        this(n, true, true);
    }

    public EVD(int n, boolean left, boolean right) {
        this.n = n;
        this.jobLeft = left ? LAPACKkernel.JobEig.All : LAPACKkernel.JobEig.Eigenvalues;
        this.jobRight = right ? LAPACKkernel.JobEig.All : LAPACKkernel.JobEig.Eigenvalues;
        this.Wr = new double[n];
        this.Wi = new double[n];
        this.Vl = left ? new DenseMatrix(n, n) : null;
        this.Vr = right ? new DenseMatrix(n, n) : null;
        double[] worksize = new double[1];
        int info = Interface.lapack().geev(this.jobLeft, this.jobRight, n, new double[0], new double[0], new double[0], new double[0], new double[0], worksize, -1);
        int lwork = 0;
        lwork = info != 0 ? (this.jobLeft == LAPACKkernel.JobEig.All || this.jobRight == LAPACKkernel.JobEig.All ? 4 * n : 3 * n) : (int)worksize[0];
        lwork = Math.max(1, lwork);
        this.work = new double[lwork];
    }

    public static EVD factorize(Matrix A) throws NotConvergedException {
        return new EVD(A.numRows()).factor(new DenseMatrix(A));
    }

    public EVD factor(DenseMatrix A) throws NotConvergedException {
        if (!A.isSquare()) {
            throw new IllegalArgumentException("!A.isSquare()");
        }
        if (A.numRows() != this.n) {
            throw new IllegalArgumentException("A.numRows() != n");
        }
        int info = Interface.lapack().geev(this.jobLeft, this.jobRight, this.n, A.getData(), this.Wr, this.Wi, this.jobLeft == LAPACKkernel.JobEig.All ? this.Vl.getData() : new double[]{}, this.jobRight == LAPACKkernel.JobEig.All ? this.Vr.getData() : new double[]{}, this.work, this.work.length);
        if (info > 0) {
            throw new NotConvergedException(NotConvergedException.Reason.Iterations);
        }
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return this;
    }

    public DenseMatrix getLeftEigenvectors() {
        return this.Vl;
    }

    public DenseMatrix getRightEigenvectors() {
        return this.Vr;
    }

    public double[] getRealEigenvalues() {
        return this.Wr;
    }

    public double[] getImaginaryEigenvalues() {
        return this.Wi;
    }

    public boolean hasLeftEigenvectors() {
        return this.Vl != null;
    }

    public boolean hasRightEigenvectors() {
        return this.Vr != null;
    }
}

