/*
 * Decompiled with CFR 0.152.
 */
package dr.geo.operators;

import dr.geo.AbstractPolygon2D;
import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import java.awt.geom.Point2D;
import java.util.List;

public class UniformGeoSpatialOperator
extends SimpleMCMCOperator {
    private final Parameter parameter;
    private final List<AbstractPolygon2D> polygonList;
    private long totalOps = 0L;
    private long currentSum = 0L;
    private static final boolean DEBUG = false;

    public UniformGeoSpatialOperator(Parameter parameter, double d, List<AbstractPolygon2D> list) {
        this.parameter = parameter;
        this.polygonList = list;
        this.setWeight(d);
    }

    @Override
    public final double doOperation() {
        Point2D.Double double_;
        double[] dArray = null;
        int n = 0;
        if (this.polygonList.size() > 1) {
            dArray = new double[this.polygonList.size()];
            for (int i = 0; i < this.polygonList.size(); ++i) {
                dArray[i] = this.polygonList.get(i).calculateArea();
            }
            n = MathUtils.randomChoicePDF(dArray);
        }
        ++this.totalOps;
        if (n == 0) {
            ++this.currentSum;
        }
        AbstractPolygon2D abstractPolygon2D = this.polygonList.get(n);
        double[][] dArray2 = abstractPolygon2D.getXYMinMax();
        int n2 = 0;
        do {
            double_ = new Point2D.Double(MathUtils.nextDouble() * (dArray2[0][1] - dArray2[0][0]) + dArray2[0][0], MathUtils.nextDouble() * (dArray2[1][1] - dArray2[1][0]) + dArray2[1][0]);
            ++n2;
        } while (!abstractPolygon2D.containsPoint2D(double_));
        this.parameter.setParameterValue(0, ((Point2D)double_).getX());
        this.parameter.setParameterValue(1, ((Point2D)double_).getY());
        return 0.0;
    }

    @Override
    public final String getOperatorName() {
        return "uniformGeoSpatial(" + this.parameter.getParameterName() + ")";
    }

    public String getPerformanceSuggestion() {
        return "";
    }

    public String toString() {
        return "uniformGeoSpatialOperator(" + this.parameter.getParameterName() + ")";
    }
}

