/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.negra;

import edu.stanford.nlp.trees.AbstractCollinsHeadFinder;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.negra.NegraLabel;
import edu.stanford.nlp.trees.international.negra.NegraPennLanguagePack;
import java.util.HashMap;

public class TigerHeadFinder
extends AbstractCollinsHeadFinder {
    private static final long serialVersionUID = 4307594629124896496L;
    private static final boolean DEBUG = false;
    private boolean coordSwitch = false;
    String left;
    String right;

    public static HeadFinder tigerSemanticHeadFinder() {
        TigerHeadFinder result = new TigerHeadFinder();
        result.nonTerminalInfo.put("S", new String[][]{{result.right, "VVFIN", "VVIMP"}, {"right", "VP", "CVP"}, {"right", "VMFIN", "VAFIN", "VAIMP"}, {"right", "S", "CS"}});
        result.nonTerminalInfo.put("VP", new String[][]{{"right", "VVINF", "VVIZU", "VVPP"}, {result.right, "VZ", "VAINF", "VMINF", "VMPP", "VAPP", "PP"}});
        result.nonTerminalInfo.put("VZ", new String[][]{{result.right, "VVINF", "VAINF", "VMINF", "VVFIN", "VVIZU"}});
        return result;
    }

    public TigerHeadFinder() {
        this(new NegraPennLanguagePack());
    }

    public TigerHeadFinder(TreebankLanguagePack tlp) {
        super(tlp);
        this.nonTerminalInfo = new HashMap();
        this.left = this.coordSwitch ? "right" : "left";
        this.right = this.coordSwitch ? "left" : "right";
        this.nonTerminalInfo.put("S", new String[][]{{this.left, "PRELS"}});
        this.nonTerminalInfo.put("NUR", new String[][]{{this.left, "S"}});
        this.nonTerminalInfo.put("ROOT", new String[][]{{this.left, "VROOT", "$.", "$["}});
        this.nonTerminalInfo.put("NP", new String[][]{{this.right, "NN", "NE", "MPN", "NP", "CNP", "PN", "CAR"}});
        this.nonTerminalInfo.put("AP", new String[][]{{this.right, "ADJD", "ADJA", "CAP", "AA", "ADV"}});
        this.nonTerminalInfo.put("PP", new String[][]{{this.left, "KOKOM", "APPR", "PROAV"}});
        this.nonTerminalInfo.put("S", new String[][]{{this.right, "VMFIN", "VVFIN", "VAFIN", "VVIMP", "VAIMP"}, {"right", "VP", "CVP"}, {"right", "S", "CS"}});
        this.nonTerminalInfo.put("VP", new String[][]{{this.right, "VZ", "VAINF", "VMINF", "VVINF", "VVIZU", "VVPP", "VMPP", "VAPP", "PP"}});
        this.nonTerminalInfo.put("VZ", new String[][]{{this.left, "PRTZU", "APPR", "PTKZU"}});
        this.nonTerminalInfo.put("CO", new String[][]{{this.left}});
        this.nonTerminalInfo.put("AVP", new String[][]{{this.right, "ADV", "AVP", "ADJD", "PROAV", "PP"}});
        this.nonTerminalInfo.put("AA", new String[][]{{this.right, "ADJD", "ADJA"}});
        this.nonTerminalInfo.put("CNP", new String[][]{{this.right, "NN", "NE", "MPN", "NP", "CNP", "PN", "CAR"}});
        this.nonTerminalInfo.put("CAP", new String[][]{{this.right, "ADJD", "ADJA", "CAP", "AA", "ADV"}});
        this.nonTerminalInfo.put("CPP", new String[][]{{this.right, "APPR", "PROAV", "PP", "CPP"}});
        this.nonTerminalInfo.put("CS", new String[][]{{this.right, "S", "CS"}});
        this.nonTerminalInfo.put("CVP", new String[][]{{this.right, "VP", "CVP"}});
        this.nonTerminalInfo.put("CVZ", new String[][]{{this.right, "VZ"}});
        this.nonTerminalInfo.put("CAVP", new String[][]{{this.right, "ADV", "AVP", "ADJD", "PWAV", "APPR", "PTKVZ"}});
        this.nonTerminalInfo.put("MPN", new String[][]{{this.right, "NE", "FM", "CARD"}});
        this.nonTerminalInfo.put("NM", new String[][]{{this.right, "CARD", "NN"}});
        this.nonTerminalInfo.put("CAC", new String[][]{{this.right, "APPR", "AVP"}});
        this.nonTerminalInfo.put("CH", new String[][]{{this.right}});
        this.nonTerminalInfo.put("MTA", new String[][]{{this.right, "ADJA", "ADJD", "NN"}});
        this.nonTerminalInfo.put("CCP", new String[][]{{this.right, "AVP"}});
        this.nonTerminalInfo.put("DL", new String[][]{{this.left}});
        this.nonTerminalInfo.put("ISU", new String[][]{{this.right}});
        this.nonTerminalInfo.put("QL", new String[][]{{this.right}});
        this.nonTerminalInfo.put("--", new String[][]{{this.right, "PP"}});
        this.nonTerminalInfo.put("PN", new String[][]{{this.right}});
        this.nonTerminalInfo.put("VROOT", new String[][]{{this.left, "S", "CS", "VP", "CVP", "NP", "XY", "CNP", "DL", "AVP", "CAVP", "PN", "AP", "PP", "CO", "NN", "NE", "CPP", "CARD", "CH"}});
        this.nonTerminalInfo.put("CD", new String[][]{{this.right, "CD"}});
        this.nonTerminalInfo.put("NN", new String[][]{{this.right, "NN"}});
        this.nonTerminalInfo.put("NR", new String[][]{{this.right, "NR"}});
    }

    protected Tree findMarkedHead(Tree[] kids) {
        int n = kids.length;
        for (int i = 0; i < n; ++i) {
            if (!(kids[i].label() instanceof NegraLabel) || ((NegraLabel)kids[i].label()).getEdge() == null || !((NegraLabel)kids[i].label()).getEdge().equals("HD")) continue;
            return kids[i];
        }
        return null;
    }

    public String basicCategory(String category) {
        if (category == null) {
            return null;
        }
        return category.substring(0, this.postBasicCategoryIndex(category));
    }

    private int postBasicCategoryIndex(String category) {
        int i;
        boolean sawAtZero = false;
        char seenAtZero = '\u0000';
        int leng = category.length();
        for (i = 0; i < leng; ++i) {
            char ch = category.charAt(i);
            if (!this.isLabelAnnotationIntroducingCharacter(ch)) continue;
            if (i == 0) {
                sawAtZero = true;
                seenAtZero = ch;
                continue;
            }
            if (!sawAtZero || ch != seenAtZero) break;
            sawAtZero = false;
        }
        return i;
    }

    public boolean isLabelAnnotationIntroducingCharacter(char ch) {
        char[] cutChars;
        for (char cutChar : cutChars = this.tlp.labelAnnotationIntroducingCharacters()) {
            if (ch != cutChar) continue;
            return true;
        }
        return ch == '-';
    }

    protected Tree determineNonTrivialHead(Tree t, Tree parent) {
        Tree theHead = null;
        String motherCat = this.basicCategory(t.label().value());
        String[][] how = (String[][])this.nonTerminalInfo.get(motherCat);
        if (how == null) {
            if (this.defaultRule != null) {
                return this.traverseLocate(t.children(), this.defaultRule, true);
            }
            return null;
        }
        for (int i = 0; i < how.length; ++i) {
            boolean deflt = i == how.length - 1;
            theHead = this.traverseLocate(t.children(), how[i], deflt);
            if (theHead != null) break;
        }
        return theHead;
    }
}

