/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree;

import com.intellij.lang.LighterASTNode;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtIoFileSourceFile;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtSourceFileLinesMapping;
import org.jetbrains.kotlin.KtSourceFileLinesMappingKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.lightTree.LightTreeParsingErrorListenerKt;
import org.jetbrains.kotlin.fir.lightTree.converter.LightTreeRawFirDeclarationBuilder;
import org.jetbrains.kotlin.fir.scopes.FirScopeProvider;
import org.jetbrains.kotlin.parsing.KotlinLightParser;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J$\u0010\f\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/LightTree2Fir;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirScopeProvider;", "diagnosticsReporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/scopes/FirScopeProvider;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "buildFirFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "path", "Ljava/nio/file/Path;", "file", "Ljava/io/File;", "lightTree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "sourceFile", "Lorg/jetbrains/kotlin/KtSourceFile;", "linesMapping", "Lorg/jetbrains/kotlin/KtSourceFileLinesMapping;", "code", "", "makeErrorListener", "Lorg/jetbrains/kotlin/parsing/KotlinLightParser$LightTreeParsingErrorListener;", "light-tree2fir"})
public final class LightTree2Fir {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirScopeProvider scopeProvider;
    @Nullable
    private final DiagnosticReporter diagnosticsReporter;

    public LightTree2Fir(@NotNull FirSession session, @NotNull FirScopeProvider scopeProvider, @Nullable DiagnosticReporter diagnosticsReporter) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(scopeProvider, "scopeProvider");
        this.session = session;
        this.scopeProvider = scopeProvider;
        this.diagnosticsReporter = diagnosticsReporter;
    }

    public /* synthetic */ LightTree2Fir(FirSession firSession, FirScopeProvider firScopeProvider, DiagnosticReporter diagnosticReporter, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            diagnosticReporter = null;
        }
        this(firSession, firScopeProvider, diagnosticReporter);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
        return this.buildFirFile(file);
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        KtIoFileSourceFile sourceFile = new KtIoFileSourceFile(file);
        InputStreamReader $this$buildFirFile_u24lambda_u240 = new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8);
        boolean bl = false;
        Pair<CharSequence, KtSourceFileLinesMapping> pair = KtSourceFileLinesMappingKt.readSourceFileWithMapping($this$buildFirFile_u24lambda_u240);
        CharSequence code = pair.component1();
        KtSourceFileLinesMapping linesMapping = pair.component2();
        return this.buildFirFile(code, (KtSourceFile)sourceFile, linesMapping);
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull FlyweightCapableTreeStructure<LighterASTNode> lightTree, @NotNull KtSourceFile sourceFile, @NotNull KtSourceFileLinesMapping linesMapping) {
        Intrinsics.checkNotNullParameter(lightTree, "lightTree");
        Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
        Intrinsics.checkNotNullParameter(linesMapping, "linesMapping");
        LightTreeRawFirDeclarationBuilder lightTreeRawFirDeclarationBuilder = new LightTreeRawFirDeclarationBuilder(this.session, this.scopeProvider, lightTree, null, 8, null);
        LighterASTNode lighterASTNode = lightTree.getRoot();
        Intrinsics.checkNotNullExpressionValue(lighterASTNode, "getRoot(...)");
        return lightTreeRawFirDeclarationBuilder.convertFile(lighterASTNode, sourceFile, linesMapping);
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull CharSequence code, @NotNull KtSourceFile sourceFile, @NotNull KtSourceFileLinesMapping linesMapping) {
        Intrinsics.checkNotNullParameter(code, "code");
        Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
        Intrinsics.checkNotNullParameter(linesMapping, "linesMapping");
        KotlinLightParser.LightTreeParsingErrorListener errorListener = this.makeErrorListener(sourceFile);
        FlyweightCapableTreeStructure<LighterASTNode> lightTree = KotlinLightParser.INSTANCE.buildLightTree(code, sourceFile, errorListener);
        return this.buildFirFile(lightTree, sourceFile, linesMapping);
    }

    private final KotlinLightParser.LightTreeParsingErrorListener makeErrorListener(KtSourceFile sourceFile) {
        DiagnosticReporter diagnosticReporter = this.diagnosticsReporter;
        if (diagnosticReporter == null) {
            return null;
        }
        DiagnosticReporter diagnosticsReporter = diagnosticReporter;
        return LightTreeParsingErrorListenerKt.toKotlinParsingErrorListener(diagnosticsReporter, sourceFile, FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session));
    }
}

