/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.impl;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import org.gradle.api.internal.file.archive.ZipEntry;

abstract class AbstractZipEntry
implements ZipEntry {
    private final java.util.zip.ZipEntry entry;

    public AbstractZipEntry(java.util.zip.ZipEntry entry) {
        this.entry = entry;
    }

    protected java.util.zip.ZipEntry getEntry() {
        return this.entry;
    }

    @Override
    public boolean isDirectory() {
        return this.entry.isDirectory();
    }

    @Override
    public String getName() {
        return this.entry.getName();
    }

    @Override
    public int size() {
        return (int)this.entry.getSize();
    }

    @Override
    public byte[] getContent() throws IOException {
        return this.withInputStream(new ZipEntry.IoFunction<InputStream, byte[]>(){

            @Override
            public byte[] apply(InputStream inputStream) throws IOException {
                int size = AbstractZipEntry.this.size();
                if (size >= 0) {
                    byte[] content = new byte[size];
                    ByteStreams.readFully((InputStream)inputStream, (byte[])content);
                    return content;
                }
                return ByteStreams.toByteArray((InputStream)inputStream);
            }
        });
    }

    @Override
    public ZipEntry.ZipCompressionMethod getCompressionMethod() {
        switch (this.entry.getMethod()) {
            case 0: {
                return ZipEntry.ZipCompressionMethod.STORED;
            }
            case 8: {
                return ZipEntry.ZipCompressionMethod.DEFLATED;
            }
        }
        return ZipEntry.ZipCompressionMethod.OTHER;
    }
}

