/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.util.concurrent.Runnables;
import java.io.File;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.AbstractCrossProcessCacheAccess;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.internal.UncheckedException;

public class FixedExclusiveModeCrossProcessCacheAccess
extends AbstractCrossProcessCacheAccess {
    private final String cacheDisplayName;
    private final File lockTarget;
    private final LockOptions lockOptions;
    private final FileLockManager lockManager;
    private final CacheInitializationAction initializationAction;
    private final Consumer<FileLock> onOpenAction;
    private final Consumer<FileLock> onCloseAction;
    private FileLock fileLock;

    public FixedExclusiveModeCrossProcessCacheAccess(String cacheDisplayName, File lockTarget, LockOptions lockOptions, FileLockManager lockManager, CacheInitializationAction initializationAction, Consumer<FileLock> onOpenAction, Consumer<FileLock> onCloseAction) {
        assert (lockOptions.getMode() == FileLockManager.LockMode.Exclusive);
        this.initializationAction = initializationAction;
        this.onOpenAction = onOpenAction;
        this.onCloseAction = onCloseAction;
        assert (lockOptions.getMode() == FileLockManager.LockMode.Exclusive);
        this.cacheDisplayName = cacheDisplayName;
        this.lockTarget = lockTarget;
        this.lockOptions = lockOptions;
        this.lockManager = lockManager;
    }

    @Override
    public void open() {
        if (this.fileLock != null) {
            throw new IllegalStateException("File lock " + this.lockTarget + " is already open.");
        }
        FileLock fileLock = this.lockManager.lock(this.lockTarget, this.lockOptions, this.cacheDisplayName, "", unused -> {});
        try {
            boolean rebuild = this.initializationAction.requiresInitialization(fileLock);
            if (rebuild) {
                fileLock.writeFile(() -> this.initializationAction.initialize(fileLock));
            }
            this.onOpenAction.accept(fileLock);
        }
        catch (Exception e) {
            fileLock.close();
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        this.fileLock = fileLock;
    }

    @Override
    public void close() {
        if (this.fileLock != null) {
            try {
                this.onCloseAction.accept(this.fileLock);
                this.fileLock.close();
            }
            finally {
                this.fileLock = null;
            }
        }
    }

    @Override
    public Runnable acquireFileLock() {
        return Runnables.doNothing();
    }

    @Override
    public <T> T withFileLock(Supplier<T> factory) {
        return factory.get();
    }
}

