/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.tasks;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.XmlProvider;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.ide.visualstudio.VisualStudioProject;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.internal.VisualStudioTargetBinary;
import org.gradle.ide.visualstudio.tasks.internal.RelativeFileNameTransformer;
import org.gradle.ide.visualstudio.tasks.internal.VisualStudioProjectFile;
import org.gradle.internal.serialization.Cached;
import org.gradle.plugins.ide.api.XmlGeneratorTask;
import org.gradle.plugins.ide.internal.IdePlugin;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.VersionNumber;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;

@Incubating
@DisableCachingByDefault(because="Not made cacheable, yet")
public abstract class GenerateProjectFileTask
extends XmlGeneratorTask<VisualStudioProjectFile> {
    private transient DefaultVisualStudioProject visualStudioProject;
    private final Cached<ProjectSpec> spec = Cached.of(this::calculateSpec);
    private final Provider<File> outputFile = this.getProject().provider(SerializableLambdas.callable((SerializableLambdas.SerializableCallable & Serializable)() -> this.visualStudioProject.getProjectFile().getLocation()));
    private final Cached<Transformer<@NotNull String, File>> transformer = Cached.of(this::getTransformer);
    private String gradleExe;
    private String gradleArgs;

    @Inject
    public GenerateProjectFileTask(DefaultVisualStudioProject visualStudioProject) {
        this.setVisualStudioProject(visualStudioProject);
    }

    protected boolean getIncremental() {
        return true;
    }

    public void initGradleCommand() {
        final File gradlew = new File(IdePlugin.toGradleCommand((Project)this.getProject()));
        this.getConventionMapping().map("gradleExe", (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                String rootDir = (String)((Transformer)GenerateProjectFileTask.this.transformer.get()).transform((Object)GenerateProjectFileTask.this.getProject().getRootDir());
                String args = "";
                if (!rootDir.equals(".")) {
                    args = " -p \"" + rootDir + "\"";
                }
                if (gradlew.isFile()) {
                    return "\"" + (String)((Transformer)GenerateProjectFileTask.this.transformer.get()).transform((Object)gradlew) + "\"" + args;
                }
                return "\"gradle\"" + args;
            }
        });
    }

    @Internal
    public Transformer<@NotNull String, File> getTransformer() {
        return RelativeFileNameTransformer.forFile(this.getProject().getRootDir(), this.visualStudioProject.getProjectFile().getLocation());
    }

    public void setVisualStudioProject(VisualStudioProject vsProject) {
        this.visualStudioProject = (DefaultVisualStudioProject)vsProject;
    }

    @Internal
    public VisualStudioProject getVisualStudioProject() {
        return this.visualStudioProject;
    }

    @Nested
    @Incubating
    protected ProjectSpec getSpec() {
        return (ProjectSpec)this.spec.get();
    }

    @Internal
    public File getInputFile() {
        return null;
    }

    @OutputFile
    public File getOutputFile() {
        return (File)this.outputFile.get();
    }

    protected VisualStudioProjectFile create() {
        return new VisualStudioProjectFile(this.getXmlTransformer(), (Transformer<String, File>)((Transformer)this.transformer.get()));
    }

    protected void configure(VisualStudioProjectFile projectFile) {
        ProjectSpec spec = (ProjectSpec)this.spec.get();
        projectFile.setGradleCommand(spec.gradleCommand);
        projectFile.setProjectUuid(DefaultVisualStudioProject.getUUID((File)this.outputFile.get()));
        projectFile.setVisualStudioVersion((VersionNumber)spec.visualStudioVersion.get());
        projectFile.setSdkVersion((VersionNumber)spec.sdkVersion.get());
        for (File file : spec.sourceFiles) {
            projectFile.addSourceFile(file);
        }
        for (File file : spec.resourceFiles) {
            projectFile.addResource(file);
        }
        for (File file : spec.headerFiles) {
            projectFile.addHeaderFile(file);
        }
        if (spec.warning != null) {
            this.getLogger().warn(spec.warning);
        }
        for (VisualStudioProjectFile.ConfigurationSpec configurationSpec : spec.configurations) {
            projectFile.addConfiguration(configurationSpec);
        }
        for (Action action : spec.xmlActions) {
            this.getXmlTransformer().addAction(action);
        }
    }

    private String buildGradleCommand() {
        String exe = this.getGradleExe();
        String args = this.getGradleArgs();
        if (args == null || args.trim().length() == 0) {
            return exe;
        }
        return exe + " " + args.trim();
    }

    @Internal
    public String getGradleExe() {
        return this.gradleExe;
    }

    public void setGradleExe(String gradleExe) {
        this.gradleExe = gradleExe;
    }

    @Internal
    public @Nullable String getGradleArgs() {
        return this.gradleArgs;
    }

    public void setGradleArgs(@Nullable String gradleArgs) {
        this.gradleArgs = gradleArgs;
    }

    private ProjectSpec calculateSpec() {
        String warning = this.visualStudioProject.getConfigurations().stream().noneMatch(it -> it.isBuildable()) ? "'" + this.visualStudioProject.getComponentName() + "' component in project '" + this.getProject().getPath() + "' is not buildable." : null;
        ArrayList<VisualStudioProjectFile.ConfigurationSpec> configurations = new ArrayList<VisualStudioProjectFile.ConfigurationSpec>();
        for (VisualStudioProjectConfiguration configuration : this.visualStudioProject.getConfigurations()) {
            VisualStudioTargetBinary targetBinary = configuration.getTargetBinary();
            if (targetBinary != null) {
                configurations.add(new VisualStudioProjectFile.ConfigurationSpec(configuration.getName(), configuration.getConfigurationName(), configuration.getProject().getName(), configuration.getPlatformName(), configuration.getType(), configuration.isBuildable(), targetBinary.isDebuggable(), targetBinary.getIncludePaths(), targetBinary.getBuildTaskPath(), targetBinary.getCleanTaskPath(), targetBinary.getCompilerDefines(), targetBinary.getOutputFile(), targetBinary.getLanguageStandard()));
                continue;
            }
            configurations.add(new VisualStudioProjectFile.ConfigurationSpec(configuration.getName(), configuration.getConfigurationName(), configuration.getProject().getName(), configuration.getPlatformName(), configuration.getType(), configuration.isBuildable(), false, Collections.emptySet(), null, null, Collections.emptyList(), null, null));
        }
        return new ProjectSpec((Provider)this.visualStudioProject.getVisualStudioVersion(), (Provider)this.visualStudioProject.getSdkVersion(), (FileCollection)this.visualStudioProject.getSourceFiles(), this.visualStudioProject.getResourceFiles(), (FileCollection)this.visualStudioProject.getHeaderFiles(), this.buildGradleCommand(), warning, configurations, this.visualStudioProject.getProjectFile().getXmlActions());
    }

    @Incubating
    protected static class ProjectSpec {
        final Provider<VersionNumber> visualStudioVersion;
        final Provider<VersionNumber> sdkVersion;
        final FileCollection sourceFiles;
        final Set<File> resourceFiles;
        final FileCollection headerFiles;
        final String gradleCommand;
        final String warning;
        final List<VisualStudioProjectFile.ConfigurationSpec> configurations;
        final List<Action<? super XmlProvider>> xmlActions;

        private ProjectSpec(Provider<VersionNumber> visualStudioVersion, Provider<VersionNumber> sdkVersion, FileCollection sourceFiles, Set<File> resourceFiles, FileCollection headerFiles, String gradleCommand, @Nullable String warning, List<VisualStudioProjectFile.ConfigurationSpec> configurations, List<Action<? super XmlProvider>> xmlActions) {
            this.visualStudioVersion = visualStudioVersion;
            this.sdkVersion = sdkVersion;
            this.sourceFiles = sourceFiles;
            this.resourceFiles = resourceFiles;
            this.headerFiles = headerFiles;
            this.gradleCommand = gradleCommand;
            this.warning = warning;
            this.configurations = configurations;
            this.xmlActions = xmlActions;
        }

        @Input
        @Incubating
        public Provider<String> getVisualStudioVersion() {
            return this.visualStudioVersion.map(VersionNumber::toString);
        }

        @Input
        @Incubating
        public Provider<String> getSdkVersion() {
            return this.sdkVersion.map(VersionNumber::toString);
        }

        @Input
        @Incubating
        public Provider<Set<String>> getSourceFilePaths() {
            return this.sourceFiles.getElements().map(files -> CollectionUtils.collect((Set)files, file -> file.getAsFile().getAbsolutePath()));
        }

        @Input
        @Incubating
        public Set<String> getResourceFilePaths() {
            return CollectionUtils.collect(this.resourceFiles, File::getAbsolutePath);
        }

        @Input
        @Incubating
        public Provider<Set<String>> getHeaderFilesPaths() {
            return this.headerFiles.getElements().map(files -> CollectionUtils.collect((Set)files, file -> file.getAsFile().getAbsolutePath()));
        }

        @Input
        @Incubating
        public String getGradleCommand() {
            return this.gradleCommand;
        }

        @Input
        @Optional
        @Incubating
        public String getWarning() {
            return this.warning;
        }

        @Nested
        @Incubating
        public List<VisualStudioProjectFile.ConfigurationSpec> getConfigurations() {
            return this.configurations;
        }

        @Nested
        @Incubating
        public List<Action<? super XmlProvider>> getXmlActions() {
            return this.xmlActions;
        }
    }
}

