/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;

class SourceFileChangeProcessor {
    private final PreviousCompilation previousCompilation;

    public SourceFileChangeProcessor(PreviousCompilation previousCompilation) {
        this.previousCompilation = previousCompilation;
    }

    public void processChange(Set<String> classNames, RecompilationSpec spec) {
        spec.addClassesToCompile(classNames);
        DependentsSet actualDependents = this.previousCompilation.findDependentsOfSourceChanges(classNames);
        if (actualDependents.isDependencyToAll()) {
            spec.setFullRebuildCause(actualDependents.getDescription());
            return;
        }
        spec.addClassesToCompile(actualDependents.getAllDependentClasses());
        spec.addResourcesToGenerate(actualDependents.getDependentResources());
    }

    public void processOnlyAccessibleChangeOfClasses(Set<String> classNames, RecompilationSpec spec) {
        DependentsSet actualDependents = this.previousCompilation.findDependentsOfSourceChanges(classNames);
        if (actualDependents.isDependencyToAll()) {
            spec.setFullRebuildCause(actualDependents.getDescription());
            return;
        }
        spec.addClassesToCompile(actualDependents.getAccessibleDependentClasses());
        spec.addResourcesToGenerate(actualDependents.getDependentResources());
    }

    public Set<String> processAnnotationDependenciesOfIndependentClasses(Set<String> classNames, RecompilationSpec spec) {
        LinkedHashSet<String> newAdded = new LinkedHashSet<String>();
        for (String className : classNames) {
            DependentsSet annotationProcessingDependentsSet = this.previousCompilation.getAnnotationProcessingDependentsSet(className);
            for (String classToCompile : annotationProcessingDependentsSet.getAllDependentClasses()) {
                if (!spec.addClassToCompile(classToCompile)) continue;
                newAdded.add(classToCompile);
            }
            spec.addResourcesToGenerate(annotationProcessingDependentsSet.getDependentResources());
        }
        return newAdded;
    }
}

