/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.kotlin.dsl.provider.ClassLoaderClassPathCache;
import org.gradle.kotlin.dsl.provider.KotlinScriptClassPathProviderKt;
import org.gradle.kotlin.dsl.support.ProjectExtensionsKt;
import org.jetbrains.annotations.NotNull;

@ServiceScope(value={Scope.Build.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tj\u0002`\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0007J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0007H\u0002J\u0015\u0010&\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b'J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0015\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0014\u001a\u0004\b\u0016\u0010\u0012R\u001b\u0010\u0018\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0014\u001a\u0004\b\u0019\u0010\u0012R\u001b\u0010\u001b\u001a\u00020\u00108@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0014\u001a\u0004\b\u001c\u0010\u0012R!\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0014\u001a\u0004\b \u0010!R?\u0010)\u001a&\u0012\f\u0012\n +*\u0004\u0018\u00010\u000b0\u000b +*\u0012\u0012\f\u0012\n +*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010(0*8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u0014\u001a\u0004\b,\u0010-R\u001a\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/gradle/kotlin/dsl/provider/KotlinScriptClassPathProvider;", "", "moduleRegistry", "Lorg/gradle/api/internal/classpath/ModuleRegistry;", "classPathRegistry", "Lorg/gradle/api/internal/ClassPathRegistry;", "coreAndPluginsScope", "Lorg/gradle/api/internal/initialization/ClassLoaderScope;", "gradleApiJarsProvider", "Lkotlin/Function0;", "", "Ljava/io/File;", "Lorg/gradle/kotlin/dsl/provider/JarsProvider;", "<init>", "(Lorg/gradle/api/internal/classpath/ModuleRegistry;Lorg/gradle/api/internal/ClassPathRegistry;Lorg/gradle/api/internal/initialization/ClassLoaderScope;Lkotlin/jvm/functions/Function0;)V", "gradleKotlinDsl", "Lorg/gradle/internal/classpath/ClassPath;", "getGradleKotlinDsl", "()Lorg/gradle/internal/classpath/ClassPath;", "gradleKotlinDsl$delegate", "Lkotlin/Lazy;", "gradleApi", "getGradleApi", "gradleApi$delegate", "gradleApiExtensions", "getGradleApiExtensions", "gradleApiExtensions$delegate", "gradleKotlinDslJars", "getGradleKotlinDslJars$kotlin_dsl", "gradleKotlinDslJars$delegate", "gradleImplementationClassPath", "", "getGradleImplementationClassPath", "()Ljava/util/Set;", "gradleImplementationClassPath$delegate", "compilationClassPathOf", "scope", "computeCompilationClassPath", "exportClassPathFromHierarchyOf", "exportClassPathFromHierarchyOf$kotlin_dsl", "", "gradleJars", "", "kotlin.jvm.PlatformType", "getGradleJars", "()Ljava/util/List;", "gradleJars$delegate", "cachedScopeCompilationClassPath", "Ljava/util/concurrent/ConcurrentHashMap;", "cachedClassLoaderClassPath", "Lorg/gradle/kotlin/dsl/provider/ClassLoaderClassPathCache;", "kotlin-dsl"})
@SourceDebugExtension(value={"SMAP\nKotlinScriptClassPathProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinScriptClassPathProvider.kt\norg/gradle/kotlin/dsl/provider/KotlinScriptClassPathProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n774#2:216\n865#2:217\n866#2:219\n1#3:218\n*S KotlinDebug\n*F\n+ 1 KotlinScriptClassPathProvider.kt\norg/gradle/kotlin/dsl/provider/KotlinScriptClassPathProvider\n*L\n134#1:216\n134#1:217\n134#1:219\n*E\n"})
public final class KotlinScriptClassPathProvider {
    @NotNull
    private final ModuleRegistry moduleRegistry;
    @NotNull
    private final ClassPathRegistry classPathRegistry;
    @NotNull
    private final ClassLoaderScope coreAndPluginsScope;
    @NotNull
    private final Function0<Collection<File>> gradleApiJarsProvider;
    @NotNull
    private final Lazy gradleKotlinDsl$delegate;
    @NotNull
    private final Lazy gradleApi$delegate;
    @NotNull
    private final Lazy gradleApiExtensions$delegate;
    @NotNull
    private final Lazy gradleKotlinDslJars$delegate;
    @NotNull
    private final Lazy gradleImplementationClassPath$delegate;
    @NotNull
    private final Lazy gradleJars$delegate;
    @NotNull
    private final ConcurrentHashMap<ClassLoaderScope, ClassPath> cachedScopeCompilationClassPath;
    @NotNull
    private final ClassLoaderClassPathCache cachedClassLoaderClassPath;

    public KotlinScriptClassPathProvider(@NotNull ModuleRegistry moduleRegistry, @NotNull ClassPathRegistry classPathRegistry, @NotNull ClassLoaderScope coreAndPluginsScope, @NotNull Function0<? extends Collection<? extends File>> gradleApiJarsProvider) {
        Intrinsics.checkNotNullParameter((Object)moduleRegistry, (String)"moduleRegistry");
        Intrinsics.checkNotNullParameter((Object)classPathRegistry, (String)"classPathRegistry");
        Intrinsics.checkNotNullParameter((Object)coreAndPluginsScope, (String)"coreAndPluginsScope");
        Intrinsics.checkNotNullParameter(gradleApiJarsProvider, (String)"gradleApiJarsProvider");
        this.moduleRegistry = moduleRegistry;
        this.classPathRegistry = classPathRegistry;
        this.coreAndPluginsScope = coreAndPluginsScope;
        this.gradleApiJarsProvider = gradleApiJarsProvider;
        this.gradleKotlinDsl$delegate = LazyKt.lazy(() -> KotlinScriptClassPathProvider.gradleKotlinDsl_delegate$lambda$0(this));
        this.gradleApi$delegate = LazyKt.lazy(() -> KotlinScriptClassPathProvider.gradleApi_delegate$lambda$1(this));
        this.gradleApiExtensions$delegate = LazyKt.lazy(() -> KotlinScriptClassPathProvider.gradleApiExtensions_delegate$lambda$2(this));
        this.gradleKotlinDslJars$delegate = LazyKt.lazy(() -> KotlinScriptClassPathProvider.gradleKotlinDslJars_delegate$lambda$3(this));
        this.gradleImplementationClassPath$delegate = LazyKt.lazy(() -> KotlinScriptClassPathProvider.gradleImplementationClassPath_delegate$lambda$4(this));
        this.gradleJars$delegate = LazyKt.lazy(() -> KotlinScriptClassPathProvider.gradleJars_delegate$lambda$8(this));
        this.cachedScopeCompilationClassPath = new ConcurrentHashMap();
        this.cachedClassLoaderClassPath = new ClassLoaderClassPathCache();
    }

    @NotNull
    public final ClassPath getGradleKotlinDsl() {
        Lazy lazy = this.gradleKotlinDsl$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (ClassPath)object;
    }

    private final ClassPath getGradleApi() {
        Lazy lazy = this.gradleApi$delegate;
        return (ClassPath)lazy.getValue();
    }

    private final ClassPath getGradleApiExtensions() {
        Lazy lazy = this.gradleApiExtensions$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (ClassPath)object;
    }

    @NotNull
    public final ClassPath getGradleKotlinDslJars$kotlin_dsl() {
        Lazy lazy = this.gradleKotlinDslJars$delegate;
        return (ClassPath)lazy.getValue();
    }

    private final Set<File> getGradleImplementationClassPath() {
        Lazy lazy = this.gradleImplementationClassPath$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final ClassPath compilationClassPathOf(@NotNull ClassLoaderScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        ClassPath classPath = this.cachedScopeCompilationClassPath.computeIfAbsent(scope, new Function(this){
            final /* synthetic */ KotlinScriptClassPathProvider $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final ClassPath apply(ClassLoaderScope p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return KotlinScriptClassPathProvider.access$computeCompilationClassPath(this.$tmp0, p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)classPath, (String)"computeIfAbsent(...)");
        return classPath;
    }

    private final ClassPath computeCompilationClassPath(ClassLoaderScope scope) {
        ClassPath classPath = this.getGradleKotlinDsl().plus(this.exportClassPathFromHierarchyOf$kotlin_dsl(scope));
        Intrinsics.checkNotNullExpressionValue((Object)classPath, (String)"plus(...)");
        return classPath;
    }

    @NotNull
    public final ClassPath exportClassPathFromHierarchyOf$kotlin_dsl(@NotNull ClassLoaderScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        if (!scope.isLocked()) {
            boolean bl = false;
            String string = scope + " must be locked before it can be used to compute a classpath!";
            throw new IllegalArgumentException(string.toString());
        }
        ClassLoader classLoader = scope.getExportClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getExportClassLoader(...)");
        Set<File> exportedClassPath = this.cachedClassLoaderClassPath.of(classLoader);
        ClassPath classPath = DefaultClassPath.of((Collection)SetsKt.minus(exportedClassPath, (Iterable)this.getGradleImplementationClassPath()));
        Intrinsics.checkNotNullExpressionValue((Object)classPath, (String)"of(...)");
        return classPath;
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> gradleKotlinDslJars() {
        void $this$filterTo$iv$iv;
        List<File> list = this.getGradleJars();
        Intrinsics.checkNotNullExpressionValue(list, (String)"<get-gradleJars>(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File file = (File)element$iv$iv;
            boolean bl = false;
            String it = file.getName();
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            boolean bl3 = KotlinScriptClassPathProviderKt.access$isKotlinJar(it) || ProjectExtensionsKt.isGradleKotlinDslJarName(it);
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<File> getGradleJars() {
        Lazy lazy = this.gradleJars$delegate;
        return (List)lazy.getValue();
    }

    private static final ClassPath gradleKotlinDsl_delegate$lambda$0(KotlinScriptClassPathProvider this$0) {
        return this$0.getGradleApi().plus(this$0.getGradleApiExtensions()).plus(this$0.getGradleKotlinDslJars$kotlin_dsl());
    }

    private static final ClassPath gradleApi_delegate$lambda$1(KotlinScriptClassPathProvider this$0) {
        ClassPath classPath = DefaultClassPath.of((Collection)((Collection)this$0.gradleApiJarsProvider.invoke()));
        Intrinsics.checkNotNullExpressionValue((Object)classPath, (String)"of(...)");
        return classPath;
    }

    private static final ClassPath gradleApiExtensions_delegate$lambda$2(KotlinScriptClassPathProvider this$0) {
        return this$0.moduleRegistry.getModule("gradle-kotlin-dsl-extensions").getClasspath();
    }

    private static final ClassPath gradleKotlinDslJars_delegate$lambda$3(KotlinScriptClassPathProvider this$0) {
        ClassPath classPath = DefaultClassPath.of((Collection)this$0.gradleKotlinDslJars());
        Intrinsics.checkNotNullExpressionValue((Object)classPath, (String)"of(...)");
        return classPath;
    }

    private static final Set gradleImplementationClassPath_delegate$lambda$4(KotlinScriptClassPathProvider this$0) {
        ClassLoaderClassPathCache classLoaderClassPathCache = this$0.cachedClassLoaderClassPath;
        ClassLoader classLoader = this$0.coreAndPluginsScope.getExportClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getExportClassLoader(...)");
        return classLoaderClassPathCache.of(classLoader);
    }

    private static final List gradleJars_delegate$lambda$8(KotlinScriptClassPathProvider this$0) {
        return this$0.classPathRegistry.getClassPath(KotlinScriptClassPathProviderKt.access$getGradleApiNotation$p().name()).getAsFiles();
    }

    public static final /* synthetic */ ClassPath access$computeCompilationClassPath(KotlinScriptClassPathProvider $this, ClassLoaderScope scope) {
        return $this.computeCompilationClassPath(scope);
    }
}

