/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.InstallationSupplier;
import org.gradle.jvm.toolchain.internal.ToolchainConfiguration;

public class LocationListInstallationSupplier
implements InstallationSupplier {
    public static final String JAVA_INSTALLATIONS_PATHS_PROPERTY = "org.gradle.java.installations.paths";
    private final ToolchainConfiguration buildOptions;
    private final FileResolver fileResolver;

    @Inject
    public LocationListInstallationSupplier(ToolchainConfiguration buildOptions, FileResolver fileResolver) {
        this.buildOptions = buildOptions;
        this.fileResolver = fileResolver;
    }

    @Override
    public String getSourceName() {
        return "Gradle property 'org.gradle.java.installations.paths'";
    }

    @Override
    public Set<InstallationLocation> get() {
        Collection<String> property = this.buildOptions.getInstallationsFromPaths();
        return property.stream().filter(path -> !path.trim().isEmpty()).map(this::asInstallations).collect(Collectors.toSet());
    }

    private InstallationLocation asInstallations(String candidate) {
        return InstallationLocation.userDefined(this.fileResolver.resolve((Object)candidate), this.getSourceName());
    }
}

