/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.util.Objects;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Optional;
import org.gradle.process.JavaDebugOptions;
import org.gradle.process.internal.JvmDebugSpec;

public class DefaultJavaDebugOptions
implements JavaDebugOptions {
    private final Property<Boolean> enabled;
    private final Property<String> host;
    private final Property<Integer> port;
    private final Property<Boolean> server;
    private final Property<Boolean> suspend;

    @Inject
    public DefaultJavaDebugOptions(ObjectFactory objectFactory) {
        JvmDebugSpec.DefaultJvmDebugSpec defaultValues = new JvmDebugSpec.DefaultJvmDebugSpec();
        this.enabled = objectFactory.property(Boolean.class).convention((Object)defaultValues.isEnabled());
        this.host = objectFactory.property(String.class).convention((Object)defaultValues.getHost());
        this.port = objectFactory.property(Integer.class).convention((Object)defaultValues.getPort());
        this.server = objectFactory.property(Boolean.class).convention((Object)defaultValues.isServer());
        this.suspend = objectFactory.property(Boolean.class).convention((Object)defaultValues.isSuspend());
    }

    public int hashCode() {
        return Objects.hash(this.getEnabled().get(), this.getHost().getOrNull(), this.getPort().get(), this.getServer().get(), this.getSuspend().get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultJavaDebugOptions that = (DefaultJavaDebugOptions)o;
        return this.enabled.get() == that.enabled.get() && Objects.equals(this.host.getOrNull(), that.host.getOrNull()) && ((Integer)this.port.get()).equals(that.port.get()) && this.server.get() == that.server.get() && this.suspend.get() == that.suspend.get();
    }

    public Property<Boolean> getEnabled() {
        return this.enabled;
    }

    @Optional
    public Property<String> getHost() {
        return this.host;
    }

    public Property<Integer> getPort() {
        return this.port;
    }

    public Property<Boolean> getServer() {
        return this.server;
    }

    public Property<Boolean> getSuspend() {
        return this.suspend;
    }
}

