/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.problems;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.initialization.ClassLoaderScopeId;
import org.gradle.initialization.ClassLoaderScopeOrigin;
import org.gradle.initialization.ClassLoaderScopeRegistryListener;
import org.gradle.initialization.ClassLoaderScopeRegistryListenerManager;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.problems.ProblemLocationAnalyzer;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.InternalStackTraceClassifier;
import org.gradle.internal.problems.failure.StackFramePredicate;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.problems.Location;
import org.jspecify.annotations.Nullable;

@ServiceScope(value={Scope.BuildTree.class})
public class DefaultProblemLocationAnalyzer
implements ProblemLocationAnalyzer,
ClassLoaderScopeRegistryListener,
Closeable {
    private static final StackFramePredicate GRADLE_CODE = (frame, relevance) -> InternalStackTraceClassifier.isGradleCall((String)frame.getClassName());
    private final Lock lock = new ReentrantLock();
    private final Map<String, ClassLoaderScopeOrigin.Script> scripts = new HashMap<String, ClassLoaderScopeOrigin.Script>();
    private final ClassLoaderScopeRegistryListenerManager listenerManager;

    public DefaultProblemLocationAnalyzer(ClassLoaderScopeRegistryListenerManager listenerManager) {
        this.listenerManager = listenerManager;
        listenerManager.add(this);
    }

    @Override
    public void close() throws IOException {
        this.listenerManager.remove(this);
        this.lock.lock();
        try {
            this.scripts.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void childScopeCreated(ClassLoaderScopeId parentId, ClassLoaderScopeId childId, @Nullable ClassLoaderScopeOrigin origin) {
        if (origin instanceof ClassLoaderScopeOrigin.Script) {
            ClassLoaderScopeOrigin.Script scriptOrigin = (ClassLoaderScopeOrigin.Script)origin;
            this.lock.lock();
            try {
                this.scripts.put(scriptOrigin.getFileName(), scriptOrigin);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void classloaderCreated(ClassLoaderScopeId scopeId, ClassLoaderId classLoaderId, ClassLoader classLoader, ClassPath classPath, @Nullable HashCode implementationHash) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Location locationForUsage(Failure failure, boolean fromException) {
        int endPos;
        int startPos;
        List stack = failure.getStackTrace();
        if (fromException) {
            startPos = 0;
            endPos = stack.size();
        } else {
            startPos = DefaultProblemLocationAnalyzer.getStartPosWithLocation(failure);
            if (startPos == -1) {
                return null;
            }
            endPos = failure.indexOfStackFrame(startPos + 1, GRADLE_CODE);
            if (endPos == -1) {
                endPos = stack.size();
            }
        }
        this.lock.lock();
        try {
            Location location = this.locationFromStackRange(startPos, endPos, stack);
            return location;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static int getStartPosWithLocation(Failure failure) {
        int startPos = -1;
        List stackTrace = failure.getStackTrace();
        while ((startPos = failure.indexOfStackFrame(startPos + 1, StackFramePredicate.USER_CODE)) >= 0 && ((StackTraceElement)stackTrace.get(startPos)).getLineNumber() < 0) {
        }
        return startPos;
    }

    private @Nullable Location locationFromStackRange(int startPos, int endPos, List<StackTraceElement> stack) {
        for (int i = startPos; i < endPos; ++i) {
            Location location = this.tryGetLocation(stack.get(i));
            if (location == null) continue;
            return location;
        }
        return null;
    }

    private @Nullable Location tryGetLocation(StackTraceElement frame) {
        int lineNumber = frame.getLineNumber();
        if (lineNumber < 0) {
            return null;
        }
        ClassLoaderScopeOrigin.Script source = this.scripts.get(frame.getFileName());
        if (source == null) {
            return null;
        }
        return new Location(source.getLongDisplayName(), source.getShortDisplayName(), source.getFileName(), lineNumber);
    }
}

