/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution.statistics;

import com.google.common.base.Preconditions;

public class TaskExecutionStatistics {
    private final int executedTasksCount;
    private final int fromCacheTaskCount;
    private final int upToDateTaskCount;

    public TaskExecutionStatistics(int executedTasksCount, int fromCacheTaskCount, int upToDateTaskCount) {
        Preconditions.checkArgument((executedTasksCount >= 0 ? 1 : 0) != 0, (Object)"executedTasksCount must be non-negative");
        Preconditions.checkArgument((fromCacheTaskCount >= 0 ? 1 : 0) != 0, (Object)"fromCacheTaskCount must be non-negative");
        Preconditions.checkArgument((upToDateTaskCount >= 0 ? 1 : 0) != 0, (Object)"upToDateTaskCount must be non-negative");
        this.executedTasksCount = executedTasksCount;
        this.fromCacheTaskCount = fromCacheTaskCount;
        this.upToDateTaskCount = upToDateTaskCount;
    }

    public int getExecutedTasksCount() {
        return this.executedTasksCount;
    }

    public int getFromCacheTaskCount() {
        return this.fromCacheTaskCount;
    }

    public int getUpToDateTaskCount() {
        return this.upToDateTaskCount;
    }

    public int getTotalTaskCount() {
        return this.executedTasksCount + this.fromCacheTaskCount + this.upToDateTaskCount;
    }
}

