/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public enum PluginTargetType {
    PROJECT("in a build script (or to the Project object)"),
    SETTINGS("in a settings script (or to the Settings object)"),
    GRADLE("in an init script (or to the Gradle object)");

    private final String applyTargetDescription;

    private PluginTargetType(String applyTargetDescription) {
        this.applyTargetDescription = applyTargetDescription;
    }

    public String getApplyTargetDescription() {
        return this.applyTargetDescription;
    }

    public static @Nullable PluginTargetType from(Class<?> type) {
        if (Project.class.isAssignableFrom(type)) {
            return PROJECT;
        }
        if (Settings.class.isAssignableFrom(type)) {
            return SETTINGS;
        }
        if (Gradle.class.isAssignableFrom(type)) {
            return GRADLE;
        }
        return null;
    }
}

