/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import java.util.Objects;
import java.util.Optional;
import org.gradle.api.internal.changedetection.TaskExecutionMode;
import org.jspecify.annotations.Nullable;

public class DefaultTaskExecutionMode
implements TaskExecutionMode {
    private static final DefaultTaskExecutionMode UP_TO_DATE_WHEN_FALSE = new DefaultTaskExecutionMode("Task.upToDateWhen is false.", true, false);
    private static final DefaultTaskExecutionMode UNTRACKED_NO_REASON = new DefaultTaskExecutionMode("Task state is not tracked.", false, false);
    private static final DefaultTaskExecutionMode RERUN_TASKS_ENABLED = new DefaultTaskExecutionMode("Executed with '--rerun-tasks'.", true, false);
    private static final DefaultTaskExecutionMode NO_OUTPUTS = new DefaultTaskExecutionMode("Task has not declared any outputs despite executing actions.", false, false);
    private static final DefaultTaskExecutionMode INCREMENTAL = new DefaultTaskExecutionMode(null, true, true);
    private final Optional<String> rebuildReason;
    private final boolean taskHistoryMaintained;
    private final boolean allowedToUseCachedResults;

    DefaultTaskExecutionMode(@Nullable String rebuildReason, boolean taskHistoryMaintained, boolean allowedToUseCachedResults) {
        this.rebuildReason = Optional.ofNullable(rebuildReason);
        this.taskHistoryMaintained = taskHistoryMaintained;
        this.allowedToUseCachedResults = allowedToUseCachedResults;
    }

    @Override
    public Optional<String> getRebuildReason() {
        return this.rebuildReason;
    }

    @Override
    public boolean isTaskHistoryMaintained() {
        return this.taskHistoryMaintained;
    }

    @Override
    public boolean isAllowedToUseCachedResults() {
        return this.allowedToUseCachedResults;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTaskExecutionMode that = (DefaultTaskExecutionMode)o;
        return this.taskHistoryMaintained == that.taskHistoryMaintained && this.allowedToUseCachedResults == that.allowedToUseCachedResults && Objects.equals(this.rebuildReason, that.rebuildReason);
    }

    public int hashCode() {
        return Objects.hash(this.rebuildReason, this.taskHistoryMaintained, this.allowedToUseCachedResults);
    }

    public static TaskExecutionMode incremental() {
        return INCREMENTAL;
    }

    public static TaskExecutionMode noOutputs() {
        return NO_OUTPUTS;
    }

    public static TaskExecutionMode rerunTasksEnabled() {
        return RERUN_TASKS_ENABLED;
    }

    public static TaskExecutionMode upToDateWhenFalse() {
        return UP_TO_DATE_WHEN_FALSE;
    }

    public static TaskExecutionMode untracked() {
        return UNTRACKED_NO_REASON;
    }

    public static TaskExecutionMode untracked(String reason) {
        return new DefaultTaskExecutionMode("Task is untracked because: " + reason, false, false);
    }
}

