/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.ant;

import java.io.PrintStream;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildLogger;
import org.gradle.api.AntBuilder;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.logging.LogLevelMapping;

public class AntLoggingAdapter
implements BuildLogger {
    private final Logger logger = Logging.getLogger(AntLoggingAdapter.class);
    private AntBuilder.AntMessagePriority lifecycleLogLevel;

    public void setMessageOutputLevel(int level) {
    }

    public void setOutputPrintStream(PrintStream output) {
    }

    public void setEmacsMode(boolean emacsMode) {
    }

    public void setErrorPrintStream(PrintStream err) {
    }

    public void buildStarted(BuildEvent event) {
    }

    public void buildFinished(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
        StringBuffer message = new StringBuffer();
        if (event.getTask() != null) {
            String taskName = event.getTask().getTaskName();
            message.append("[ant:").append(taskName).append("] ");
        }
        String messageText = event.getMessage();
        message.append(messageText);
        LogLevel level = this.getLogLevelForMessagePriority(event.getPriority());
        if (event.getException() != null) {
            this.logger.log(level, message.toString(), event.getException());
        } else {
            this.logger.log(level, message.toString());
        }
    }

    public void setLifecycleLogLevel(String lifecycleLogLevel) {
        this.setLifecycleLogLevel(lifecycleLogLevel == null ? null : AntBuilder.AntMessagePriority.valueOf(lifecycleLogLevel));
    }

    public void setLifecycleLogLevel(AntBuilder.AntMessagePriority lifecycleLogLevel) {
        this.lifecycleLogLevel = lifecycleLogLevel;
    }

    public AntBuilder.AntMessagePriority getLifecycleLogLevel() {
        return this.lifecycleLogLevel;
    }

    private LogLevel getLogLevelForMessagePriority(int messagePriority) {
        LogLevel defaultLevel = (LogLevel)LogLevelMapping.ANT_IVY_2_SLF4J.get(messagePriority);
        if (this.lifecycleLogLevel != null) {
            if (defaultLevel.ordinal() < LogLevel.LIFECYCLE.ordinal() && AntBuilder.AntMessagePriority.from(messagePriority).ordinal() >= this.lifecycleLogLevel.ordinal()) {
                return LogLevel.LIFECYCLE;
            }
            if (defaultLevel.ordinal() >= LogLevel.LIFECYCLE.ordinal() && AntBuilder.AntMessagePriority.from(messagePriority).ordinal() < this.lifecycleLogLevel.ordinal()) {
                return LogLevel.INFO;
            }
        }
        return defaultLevel;
    }
}

