/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.model.BuildCommand;
import org.gradle.plugins.ide.eclipse.model.Link;
import org.gradle.plugins.ide.eclipse.model.NonRenamableProject;
import org.gradle.plugins.ide.eclipse.model.Project;
import org.gradle.plugins.ide.eclipse.model.ResourceFilter;
import org.gradle.plugins.ide.eclipse.model.internal.DefaultResourceFilter;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.util.internal.ConfigureUtil;

public abstract class EclipseProject {
    public static final ImmutableSet<String> VALID_LINKED_RESOURCE_ARGS = ImmutableSet.of((Object)"name", (Object)"type", (Object)"location", (Object)"locationUri");
    private String name;
    private String comment;
    private Set<String> referencedProjects = new LinkedHashSet<String>();
    private List<String> natures = new ArrayList<String>();
    private List<BuildCommand> buildCommands = new ArrayList<BuildCommand>();
    private Set<Link> linkedResources = new LinkedHashSet<Link>();
    private Set<ResourceFilter> resourceFilters = new LinkedHashSet<ResourceFilter>();
    private final XmlFileContentMerger file;

    @Inject
    public EclipseProject(XmlFileContentMerger file) {
        this.file = file;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Set<String> getReferencedProjects() {
        return this.referencedProjects;
    }

    public void setReferencedProjects(Set<String> referencedProjects) {
        this.referencedProjects = referencedProjects;
    }

    public void referencedProjects(String ... referencedProjects) {
        assert (referencedProjects != null);
        this.referencedProjects.addAll(Arrays.asList(referencedProjects));
    }

    public List<String> getNatures() {
        return this.natures;
    }

    public void setNatures(List<String> natures) {
        this.natures = natures;
    }

    public void natures(String ... natures) {
        assert (natures != null);
        this.natures.addAll(Arrays.asList(natures));
    }

    public List<BuildCommand> getBuildCommands() {
        return this.buildCommands;
    }

    public void setBuildCommands(List<BuildCommand> buildCommands) {
        this.buildCommands = buildCommands;
    }

    public void buildCommand(Map<String, String> args, String buildCommand) {
        assert (buildCommand != null);
        this.buildCommands.add(new BuildCommand(buildCommand, args));
    }

    public void buildCommand(String buildCommand) {
        assert (buildCommand != null);
        this.buildCommands.add(new BuildCommand(buildCommand));
    }

    public Set<Link> getLinkedResources() {
        return this.linkedResources;
    }

    public void setLinkedResources(Set<Link> linkedResources) {
        this.linkedResources = linkedResources;
    }

    public void linkedResource(Map<String, String> args) {
        Sets.SetView illegalArgs = Sets.difference(args.keySet(), VALID_LINKED_RESOURCE_ARGS);
        if (!illegalArgs.isEmpty()) {
            throw new InvalidUserDataException("You provided illegal argument for a link: " + illegalArgs + ". Valid link args are: " + VALID_LINKED_RESOURCE_ARGS);
        }
        this.linkedResources.add(new Link(args.get("name"), args.get("type"), args.get("location"), args.get("locationUri")));
    }

    public Set<ResourceFilter> getResourceFilters() {
        return this.resourceFilters;
    }

    public ResourceFilter resourceFilter(@DelegatesTo(value=ResourceFilter.class, strategy=1) Closure configureClosure) {
        return this.resourceFilter((Action<? super ResourceFilter>)new ClosureBackedAction(configureClosure));
    }

    public ResourceFilter resourceFilter(Action<? super ResourceFilter> configureAction) {
        DefaultResourceFilter f = new DefaultResourceFilter();
        configureAction.execute((Object)f);
        this.resourceFilters.add(f);
        return f;
    }

    public void file(@DelegatesTo(value=XmlFileContentMerger.class) Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.file);
    }

    public void file(Action<? super XmlFileContentMerger> action) {
        action.execute((Object)this.file);
    }

    public final XmlFileContentMerger getFile() {
        return this.file;
    }

    public void mergeXmlProject(Project xmlProject) {
        NonRenamableProject decoratedProject = new NonRenamableProject(xmlProject);
        this.file.getBeforeMerged().execute((Object)decoratedProject);
        xmlProject.configure(this);
        this.file.getWhenMerged().execute((Object)decoratedProject);
    }
}

