/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.vavr.collection;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.kotlin.io.vavr.Tuple;
import org.jetbrains.kotlin.io.vavr.collection.Iterator;
import org.jetbrains.kotlin.io.vavr.collection.List;
import org.jetbrains.kotlin.io.vavr.collection.Seq;
import org.jetbrains.kotlin.io.vavr.collection.Stream;
import org.jetbrains.kotlin.io.vavr.collection.Traversable;
import org.jetbrains.kotlin.io.vavr.collection.TreeModule;

public interface Tree<T>
extends Traversable<T>,
Serializable {
    public static final long serialVersionUID = 1L;

    @Override
    default public boolean isAsync() {
        return false;
    }

    @Override
    default public boolean isDistinct() {
        return false;
    }

    @Override
    default public boolean isLazy() {
        return false;
    }

    @Override
    default public boolean isSequential() {
        return true;
    }

    default public Seq<Node<T>> traverse(Order order) {
        Objects.requireNonNull(order, "order is null");
        if (this.isEmpty()) {
            return Stream.empty();
        }
        Node node = (Node)this;
        switch (order) {
            case PRE_ORDER: {
                return TreeModule.traversePreOrder(node);
            }
            case IN_ORDER: {
                return TreeModule.traverseInOrder(node);
            }
            case POST_ORDER: {
                return TreeModule.traversePostOrder(node);
            }
            case LEVEL_ORDER: {
                return TreeModule.traverseLevelOrder(node);
            }
        }
        throw new IllegalStateException("Unknown order: " + order.name());
    }

    default public Seq<T> values() {
        return this.traverse(Order.PRE_ORDER).map(Node::getValue);
    }

    @Override
    default public Seq<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return this.values().filter((Predicate)predicate);
    }

    @Override
    default public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    default public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty tree");
        }
        return (T)this.iterator().next();
    }

    @Override
    default public boolean isTraversableAgain() {
        return true;
    }

    @Override
    default public Iterator<T> iterator() {
        return this.values().iterator();
    }

    @Override
    default public String stringPrefix() {
        return "Tree";
    }

    @Override
    default public Seq<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty tree");
        }
        return this.values().tail();
    }

    @Override
    public String toString();

    public static enum Order {
        PRE_ORDER,
        IN_ORDER,
        POST_ORDER,
        LEVEL_ORDER;

    }

    public static final class Node<T>
    implements Tree<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final T value;
        private final List<Node<T>> children;
        private final int size;

        public Node(T value2, List<Node<T>> children) {
            Objects.requireNonNull(children, "children is null");
            this.value = value2;
            this.children = children;
            this.size = children.foldLeft(1, (acc, child) -> acc + child.size);
        }

        public List<Node<T>> getChildren() {
            return this.children;
        }

        public T getValue() {
            return this.value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int length() {
            return this.size;
        }

        public boolean isLeaf() {
            return this.size == 1;
        }

        @Override
        public T last() {
            return this.children.isEmpty() ? this.value : this.children.last().last();
        }

        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (o2 instanceof Node) {
                Node that = (Node)o2;
                return Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.getChildren(), that.getChildren());
            }
            return false;
        }

        public int hashCode() {
            return Tuple.hash(this.value, this.children);
        }

        @Override
        public String toString() {
            return this.mkString(this.stringPrefix() + "(", ", ", ")");
        }

        private Object writeReplace() {
            return new SerializationProxy(this);
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }

        private static final class SerializationProxy<T>
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private transient Node<T> node;

            SerializationProxy(Node<T> node) {
                this.node = node;
            }

            private void writeObject(ObjectOutputStream s2) throws IOException {
                s2.defaultWriteObject();
                s2.writeObject(((Node)this.node).value);
                s2.writeObject(((Node)this.node).children);
            }

            private void readObject(ObjectInputStream s2) throws ClassNotFoundException, IOException {
                s2.defaultReadObject();
                Object value2 = s2.readObject();
                List children = (List)s2.readObject();
                this.node = new Node<Object>(value2, children);
            }

            private Object readResolve() {
                return this.node;
            }
        }
    }
}

