/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationsPlatformSpecificSupportComponentKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirRetentionAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirClassReferenceExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u00020\nR\u00020\fj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0015H\u0002J(\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002J(\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002J2\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002J2\u0010!\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002J2\u0010\"\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002J2\u0010#\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirRepeatableAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "REPEATABLE_ANNOTATION_CONTAINER_NAME", "Lorg/jetbrains/kotlin/name/Name;", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "resolveContainerAnnotation", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "checkJavaRepeatableAnnotationDeclaration", "javaRepeatable", "annotationClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "checkKotlinRepeatableAnnotationDeclaration", "kotlinRepeatable", "checkRepeatableAnnotationContainer", "containerClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "annotationSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkContainerParameters", "checkContainerRetention", "checkContainerTarget", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirRepeatableAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirRepeatableAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirRepeatableAnnotationChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n36#2:255\n33#2:256\n382#3,7:257\n1761#4,3:264\n1761#4,3:267\n1#5:270\n*S KotlinDebug\n*F\n+ 1 FirRepeatableAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirRepeatableAnnotationChecker\n*L\n49#1:255\n49#1:256\n56#1:257,7\n58#1:264,3\n68#1:267,3\n*E\n"})
public final class FirRepeatableAnnotationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirRepeatableAnnotationChecker INSTANCE = new FirRepeatableAnnotationChecker();
    @NotNull
    private static final Name REPEATABLE_ANNOTATION_CONTAINER_NAME;

    private FirRepeatableAnnotationChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        annotations = declaration.getAnnotations();
        if (annotations.isEmpty()) {
            return;
        }
        annotationsMap = new HashMap<K, V>();
        session = context.getSession();
        var7_7 = annotations.iterator();
        while (var7_7.hasNext()) {
            block21: {
                $this$unexpandedClassId$iv = annotation = var7_7.next();
                $i$f$getUnexpandedClassId = false;
                $this$unexpandedConeClassLikeType$iv$iv = $this$unexpandedClassId$iv;
                $i$f$getUnexpandedConeClassLikeType = false;
                var15_17 = $this$unexpandedConeClassLikeType$iv$iv.getAnnotationTypeRef();
                v0 = var15_17 instanceof FirResolvedTypeRef != false ? (FirResolvedTypeRef)var15_17 : null;
                var16_19 = v0 != null ? v0.getConeType() : null;
                v1 = var16_19 instanceof ConeClassLikeType != false ? (ConeClassLikeType)var16_19 : null;
                if ((v1 != null && (v1 = v1.getLookupTag()) != null ? v1.getClassId() : null) == null) continue;
                unexpandedClassId = unexpandedClassId;
                if (FirAnnotationUtilsKt.toAnnotationClassId(annotation, session) == null || annotationClassId.isLocal() || FirSymbolProviderKt.getSymbolProvider(session).getClassLikeSymbolByClassId(annotationClassId) == null) continue;
                useSiteTarget = annotation.getUseSiteTarget();
                expandedType = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(annotation.getAnnotationTypeRef()), context.getSession(), null, 2, null);
                $this$getOrPut$iv = annotationsMap;
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(expandedType);
                if (value$iv == null) {
                    $i$a$-getOrPut-FirRepeatableAnnotationChecker$check$existingTargetsForAnnotation$1 = false;
                    answer$iv = new ArrayList<E>();
                    $this$getOrPut$iv.put(expandedType, answer$iv);
                    v2 /* !! */  = answer$iv;
                } else {
                    v2 /* !! */  = value$iv;
                }
                if ((existingTargetsForAnnotation = (List)v2 /* !! */ ).contains((Object)useSiteTarget)) ** GOTO lbl-1000
                $this$any$iv = existingTargetsForAnnotation;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v3 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (AnnotationUseSiteTarget)element$iv;
                        $i$a$-any-FirRepeatableAnnotationChecker$check$duplicateAnnotation$1 = false;
                        if (!(it == null != (useSiteTarget == null))) continue;
                        v3 = true;
                        break block21;
                    }
                    v3 = false;
                }
            }
            if (v3) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else {
                v4 = duplicateAnnotation = false;
            }
            if (duplicateAnnotation && FirAnnotationsPlatformSpecificSupportComponentKt.getAnnotationPlatformSupport(session).symbolContainsRepeatableAnnotation(annotationClass, session) && FirRetentionAnnotationHelpersKt.getAnnotationRetention(annotationClass, session) != AnnotationRetention.SOURCE) {
                if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).supportsFeature(LanguageFeature.RepeatableAnnotations)) {
                    explicitContainer = this.resolveContainerAnnotation(annotationClass, session);
                    if (explicitContainer != null) {
                        block22: {
                            $this$any$iv = annotations;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v5 = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    it = (FirAnnotation)element$iv;
                                    $i$a$-any-FirRepeatableAnnotationChecker$check$1 = false;
                                    if (!Intrinsics.areEqual((Object)FirAnnotationUtilsKt.toAnnotationClassId(it, session), (Object)explicitContainer)) continue;
                                    v5 = true;
                                    break block22;
                                }
                                v5 = false;
                            }
                        }
                        if (v5) {
                            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)annotation.getSource(), FirJvmErrors.INSTANCE.getREPEATED_ANNOTATION_WITH_CONTAINER(), (Object)unexpandedClassId, (Object)explicitContainer, null, 32, null);
                        }
                    }
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)annotation.getSource(), FirJvmErrors.INSTANCE.getNON_SOURCE_REPEATED_ANNOTATION(), null, 8, null);
                }
            }
            existingTargetsForAnnotation.add(useSiteTarget);
        }
        if (declaration instanceof FirRegularClass) {
            javaRepeatable = FirAnnotationUtilsKt.getAnnotationByClassId(annotations, JvmStandardClassIds.Annotations.Java.INSTANCE.getRepeatable(), session);
            if (javaRepeatable != null) {
                this.checkJavaRepeatableAnnotationDeclaration(javaRepeatable, (FirRegularClass)declaration, context, reporter);
            } else {
                kotlinRepeatable = FirAnnotationUtilsKt.getAnnotationByClassId(annotations, StandardClassIds.Annotations.INSTANCE.getRepeatable(), session);
                if (kotlinRepeatable != null) {
                    this.checkKotlinRepeatableAnnotationDeclaration(kotlinRepeatable, (FirRegularClass)declaration, context, reporter);
                }
            }
        }
    }

    private final ClassId resolveContainerAnnotation(FirClassLikeSymbol<?> $this$resolveContainerAnnotation, FirSession session2) {
        FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)$this$resolveContainerAnnotation, StandardClassIds.Annotations.INSTANCE.getRepeatable(), session2);
        if (firAnnotation == null && (firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)$this$resolveContainerAnnotation, JvmStandardClassIds.Annotations.Java.INSTANCE.getRepeatable(), session2)) == null) {
            return null;
        }
        FirAnnotation repeatableAnnotation = firAnnotation;
        return this.resolveContainerAnnotation(repeatableAnnotation);
    }

    private final ClassId resolveContainerAnnotation(FirAnnotation $this$resolveContainerAnnotation) {
        FirExpression firExpression = FirAnnotationUtilsKt.findArgumentByName$default($this$resolveContainerAnnotation, StandardClassIds.Annotations.ParameterNames.INSTANCE.getValue(), false, 2, null);
        if (firExpression == null) {
            return null;
        }
        FirExpression value2 = firExpression;
        FirExpression firExpression2 = value2 instanceof FirGetClassCall ? (FirGetClassCall)value2 : null;
        if (firExpression2 == null || (firExpression2 = firExpression2.getArgument()) == null) {
            return null;
        }
        FirExpression classCallArgument = firExpression2;
        if (classCallArgument instanceof FirResolvedQualifier) {
            return ((FirResolvedQualifier)classCallArgument).getClassId();
        }
        if (classCallArgument instanceof FirClassReferenceExpression) {
            ConeRigidType coneRigidType = ConeTypeUtilsKt.lowerBoundIfFlexible(FirTypeUtilsKt.getConeType(((FirClassReferenceExpression)classCallArgument).getClassTypeRef()));
            ConeClassLikeType coneClassLikeType = coneRigidType instanceof ConeClassLikeType ? (ConeClassLikeType)coneRigidType : null;
            if (coneClassLikeType == null) {
                return null;
            }
            ConeClassLikeType type = coneClassLikeType;
            return type.getLookupTag().getClassId();
        }
        return null;
    }

    private final void checkJavaRepeatableAnnotationDeclaration(FirAnnotation javaRepeatable, FirRegularClass annotationClass, CheckerContext context2, DiagnosticReporter reporter) {
        ClassId classId = this.resolveContainerAnnotation(javaRepeatable);
        if (classId == null) {
            return;
        }
        ClassId containerClassId = classId;
        FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByClassId(containerClassId);
        FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol containerClassSymbol = firRegularClassSymbol;
        this.checkRepeatableAnnotationContainer(annotationClass, containerClassSymbol, javaRepeatable.getSource(), context2, reporter);
    }

    private final void checkKotlinRepeatableAnnotationDeclaration(FirAnnotation kotlinRepeatable, FirRegularClass declaration, CheckerContext context2, DiagnosticReporter reporter) {
        FirTypeScope unsubsitutedScope = FirHelpersKt.unsubstitutedScope(declaration, context2);
        if (FirScopeKt.getSingleClassifier(unsubsitutedScope, REPEATABLE_ANNOTATION_CONTAINER_NAME) != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)kotlinRepeatable.getSource(), FirJvmErrors.INSTANCE.getREPEATABLE_ANNOTATION_HAS_NESTED_CLASS_NAMED_CONTAINER(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkRepeatableAnnotationContainer(FirRegularClass annotationClass, FirRegularClassSymbol containerClass, KtSourceElement annotationSource, CheckerContext context2, DiagnosticReporter reporter) {
        this.checkContainerParameters(containerClass, annotationClass, annotationSource, context2, reporter);
        this.checkContainerRetention(containerClass, annotationClass, annotationSource, context2, reporter);
        this.checkContainerTarget(containerClass, annotationClass, annotationSource, context2, reporter);
    }

    private final void checkContainerParameters(FirRegularClassSymbol containerClass, FirRegularClass annotationClass, KtSourceElement annotationSource, CheckerContext context2, DiagnosticReporter reporter) {
        Object v4;
        block6: {
            ConeKotlinType fullyExpandedType2;
            FirValueParameterSymbol value2;
            Object object;
            Object v1;
            Object object22;
            Name parameterName;
            List<FirValueParameterSymbol> valueParameterSymbols;
            FirSession session2;
            block5: {
                session2 = context2.getSession();
                FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny(containerClass, session2);
                if (firConstructorSymbol == null) {
                    return;
                }
                FirConstructorSymbol containerCtor = firConstructorSymbol;
                valueParameterSymbols = containerCtor.getValueParameterSymbols();
                parameterName = StandardClassIds.Annotations.ParameterNames.INSTANCE.getValue();
                Iterable iterable = valueParameterSymbols;
                for (Object object22 : iterable) {
                    FirValueParameterSymbol it = (FirValueParameterSymbol)object22;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)parameterName)) continue;
                    v1 = object22;
                    break block5;
                }
                v1 = null;
            }
            ConeKotlinType coneKotlinType = (object = (value2 = (FirValueParameterSymbol)v1)) != null && (object = ((FirCallableSymbol)object).getResolvedReturnTypeRef()) != null && (object = ((FirResolvedTypeRef)object).getConeType()) != null ? TypeExpansionUtilsKt.fullyExpandedType$default((ConeKotlinType)object, session2, null, 2, null) : (fullyExpandedType2 = null);
            if (fullyExpandedType2 == null || !ConeBuiltinTypeUtilsKt.isArrayType(fullyExpandedType2) || !Intrinsics.areEqual((Object)ConeTypeProjectionKt.getType((ConeTypeProjection)ArraysKt.single((Object[])fullyExpandedType2.getTypeArguments())), (Object)ScopeUtilsKt.defaultType(annotationClass))) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirJvmErrors.INSTANCE.getREPEATABLE_CONTAINER_MUST_HAVE_VALUE_ARRAY(), (Object)containerClass.getClassId(), (Object)FirDeclarationUtilKt.getClassId(annotationClass), (DiagnosticContext)context2, null, 32, null);
                return;
            }
            object22 = valueParameterSymbols;
            Iterator iterator2 = object22.iterator();
            while (iterator2.hasNext()) {
                Object t2 = iterator2.next();
                FirValueParameterSymbol it = (FirValueParameterSymbol)t2;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)parameterName) && !it.getHasDefaultValue())) continue;
                v4 = t2;
                break block6;
            }
            v4 = null;
        }
        FirValueParameterSymbol otherNonDefault = v4;
        if (otherNonDefault != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirJvmErrors.INSTANCE.getREPEATABLE_CONTAINER_HAS_NON_DEFAULT_PARAMETER(), (Object)containerClass.getClassId(), (Object)otherNonDefault.getName(), (DiagnosticContext)context2, null, 32, null);
            return;
        }
    }

    private final void checkContainerRetention(FirRegularClassSymbol containerClass, FirRegularClass annotationClass, KtSourceElement annotationSource, CheckerContext context2, DiagnosticReporter reporter) {
        AnnotationRetention annotationRetention = FirRetentionAnnotationHelpersKt.getAnnotationRetention(annotationClass.getSymbol(), context2.getSession());
        AnnotationRetention containerRetention = FirRetentionAnnotationHelpersKt.getAnnotationRetention(containerClass, context2.getSession());
        if (containerRetention.compareTo((Enum)annotationRetention) < 0) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirJvmErrors.INSTANCE.getREPEATABLE_CONTAINER_HAS_SHORTER_RETENTION(), (Object)containerClass.getClassId(), (Object)containerRetention.name(), (Object)FirDeclarationUtilKt.getClassId(annotationClass), (Object)annotationRetention.name(), (DiagnosticContext)context2, null, 128, null);
        }
    }

    private final void checkContainerTarget(FirRegularClassSymbol containerClass, FirRegularClass annotationClass, KtSourceElement annotationSource, CheckerContext context2, DiagnosticReporter reporter) {
        Set<KotlinTarget> annotationTargets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotationClass, context2.getSession());
        Set<KotlinTarget> containerTargets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(containerClass, context2.getSession());
        for (KotlinTarget target : containerTargets) {
            KotlinTarget kotlinTarget = target;
            boolean ok = annotationTargets.contains((Object)kotlinTarget) ? true : (kotlinTarget == KotlinTarget.ANNOTATION_CLASS ? annotationTargets.contains((Object)KotlinTarget.CLASS) || annotationTargets.contains((Object)KotlinTarget.TYPE) : (kotlinTarget == KotlinTarget.CLASS ? annotationTargets.contains((Object)KotlinTarget.TYPE) : (kotlinTarget == KotlinTarget.TYPE_PARAMETER ? annotationTargets.contains((Object)KotlinTarget.TYPE) : false)));
            if (ok) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirJvmErrors.INSTANCE.getREPEATABLE_CONTAINER_TARGET_SET_NOT_A_SUBSET(), (Object)containerClass.getClassId(), (Object)FirDeclarationUtilKt.getClassId(annotationClass), (DiagnosticContext)context2, null, 32, null);
            return;
        }
    }

    static {
        Name name2 = Name.identifier("Container");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        REPEATABLE_ANNOTATION_CONTAINER_NAME = name2;
    }
}

