/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.lang.ClassLoadingLocks;
import org.jetbrains.kotlin.com.intellij.util.lang.ClassPath;
import org.jetbrains.kotlin.com.intellij.util.lang.ClasspathCache;
import org.jetbrains.kotlin.com.intellij.util.lang.Resource;
import org.jetbrains.kotlin.com.intellij.util.lang.UrlUtilRt;

public class UrlClassLoader
extends ClassLoader
implements ClassPath.ClassDataConsumer {
    private static final boolean isClassPathIndexEnabledGlobalValue = Boolean.parseBoolean(System.getProperty("idea.classpath.index.enabled", "false"));
    private static final boolean mimicJarUrlConnection = Boolean.parseBoolean(System.getProperty("idea.mimic.jar.url.connection", "false"));
    private static final boolean isParallelCapable = UrlClassLoader.registerAsParallelCapable();
    private static final ClassLoader appClassLoader = UrlClassLoader.class.getClassLoader();
    private static final ThreadLocal<Boolean> skipFindingResource = new ThreadLocal();
    protected final ClassPath classPath;
    private final ClassLoadingLocks classLoadingLocks;
    private final boolean isBootstrapResourcesAllowed;
    private final boolean isSystemClassLoader;
    private final boolean enableCoroutineDump;
    @NotNull
    protected final ClassPath.ClassDataConsumer classDataConsumer;

    @NotNull
    public final List<URL> getUrls() {
        ArrayList<URL> result2 = new ArrayList<URL>();
        for (Path file : this.classPath.getFiles()) {
            try {
                result2.add(file.toUri().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        ArrayList<URL> arrayList = result2;
        if (arrayList == null) {
            UrlClassLoader.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Override
    protected Class<?> findClass(@NotNull String name2) throws ClassNotFoundException {
        Class<?> clazz;
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(16);
        }
        String fileNameWithoutExtension = name2.replace('.', '/');
        String fileName = fileNameWithoutExtension + ".class";
        long packageNameHash = ClasspathCache.getPackageNameHash(fileNameWithoutExtension, fileNameWithoutExtension.lastIndexOf(47));
        if (!(!this.isSystemClassLoader || packageNameHash != -9217824570049207139L && packageNameHash != -1976620678582843062L || fileNameWithoutExtension.endsWith("/CompoundRuntimeException") || fileNameWithoutExtension.endsWith("/JavaVersion"))) {
            return appClassLoader.loadClass(name2);
        }
        try {
            if (this.enableCoroutineDump && packageNameHash == -3930079881136890558L && name2.equals("kotlin.coroutines.jvm.internal.DebugProbesKt")) {
                String resourceName = "DebugProbesKt.bin";
                Resource resource = this.classPath.findResource(resourceName);
                if (resource == null) {
                    System.err.println("Cannot find " + resourceName);
                } else {
                    return this.classDataConsumer.consumeClassData(name2, resource.getByteBuffer());
                }
            }
            clazz = this.classPath.findClass(name2, fileName, packageNameHash, this.classDataConsumer);
        }
        catch (IOException e2) {
            throw new ClassNotFoundException(name2, e2);
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name2);
        }
        return clazz;
    }

    private void definePackageIfNeeded(String name2) {
        int lastDotIndex = name2.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return;
        }
        String packageName2 = name2.substring(0, lastDotIndex);
        if (this.isPackageDefined(packageName2)) {
            return;
        }
        try {
            this.definePackage(packageName2, null, null, null, null, null, null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected boolean isPackageDefined(String packageName2) {
        return this.getPackage(packageName2) != null;
    }

    @Override
    public Class<?> consumeClassData(@NotNull String name2, byte[] data) throws IOException {
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(18);
        }
        this.definePackageIfNeeded(name2);
        return super.defineClass(name2, data, 0, data.length, null);
    }

    @Override
    public Class<?> consumeClassData(@NotNull String name2, ByteBuffer data) {
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(19);
        }
        this.definePackageIfNeeded(name2);
        return super.defineClass(name2, data, null);
    }

    @Override
    @Nullable
    public URL findResource(@NotNull String name2) {
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(20);
        }
        if (skipFindingResource.get() != null) {
            return null;
        }
        Resource resource = this.doFindResource(name2);
        return resource != null ? resource.getURL() : null;
    }

    public byte @Nullable [] getResourceAsBytes(@NotNull String name2, boolean checkParents) throws IOException {
        Resource resource;
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(21);
        }
        return (resource = this.classPath.findResource(name2)) == null ? null : resource.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public InputStream getResourceAsStream(@NotNull String name2) {
        Resource resource;
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(22);
        }
        if ((resource = this.doFindResource(name2)) != null) {
            try {
                return resource.getInputStream();
            }
            catch (IOException e2) {
                this.logError("Cannot load resource " + name2, e2);
                return null;
            }
        }
        if (this.isBootstrapResourcesAllowed) {
            skipFindingResource.set(Boolean.TRUE);
            try {
                URL url = super.getResource(name2);
                if (url != null) {
                    try {
                        InputStream inputStream = url.openStream();
                        return inputStream;
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                skipFindingResource.set(null);
            }
        }
        return null;
    }

    @Nullable
    private Resource doFindResource(String name2) {
        String canonicalPath2 = UrlClassLoader.toCanonicalPath(name2);
        Resource resource = this.classPath.findResource(canonicalPath2);
        if (resource == null && canonicalPath2.startsWith("/") && this.classPath.findResource(canonicalPath2.substring(1)) != null) {
            this.logError("Calling `ClassLoader#getResource` with leading slash doesn't work; strip", new IllegalArgumentException(name2));
        }
        return resource;
    }

    @Override
    @NotNull
    public Enumeration<URL> findResources(@NotNull String name2) {
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(26);
        }
        Enumeration<URL> enumeration = this.classPath.getResources(name2);
        if (enumeration == null) {
            UrlClassLoader.$$$reportNull$$$0(27);
        }
        return enumeration;
    }

    @Override
    @NotNull
    protected final Object getClassLoadingLock(String className) {
        Object object = this.classLoadingLocks == null ? this : this.classLoadingLocks.getOrCreateLock(className);
        if (object == null) {
            UrlClassLoader.$$$reportNull$$$0(28);
        }
        return object;
    }

    protected static String toCanonicalPath(@NotNull String path) {
        char next;
        if (path == null) {
            UrlClassLoader.$$$reportNull$$$0(29);
        }
        if (path.isEmpty()) {
            return path;
        }
        if (path.charAt(0) == '.') {
            if (path.length() == 1) {
                return "";
            }
            char c2 = path.charAt(1);
            if (c2 == '/') {
                path = path.substring(2);
            }
        }
        int index = -1;
        do {
            char c3 = next = (index = path.indexOf(47, index + 1)) == path.length() - 1 ? (char)'\u0000' : path.charAt(index + 1);
        } while (next != '.' && next != '/' && index != -1);
        if (index == -1) {
            return path;
        }
        StringBuilder result2 = new StringBuilder(path.length());
        int start = UrlClassLoader.processRoot(path, result2);
        int dots = 0;
        boolean separator = true;
        for (int i2 = start; i2 < path.length(); ++i2) {
            char c4 = path.charAt(i2);
            if (c4 == '/') {
                if (!separator) {
                    UrlClassLoader.processDots(result2, dots, start);
                    dots = 0;
                }
                separator = true;
                continue;
            }
            if (c4 == '.') {
                if (separator || dots > 0) {
                    ++dots;
                } else {
                    result2.append('.');
                }
                separator = false;
                continue;
            }
            while (dots > 0) {
                result2.append('.');
                --dots;
            }
            result2.append(c4);
            separator = false;
        }
        if (dots > 0) {
            UrlClassLoader.processDots(result2, dots, start);
        }
        return result2.toString();
    }

    private static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        int l2;
        int l1;
        if (text == null) {
            UrlClassLoader.$$$reportNull$$$0(30);
        }
        if (suffix == null) {
            UrlClassLoader.$$$reportNull$$$0(31);
        }
        if ((l1 = text.length()) < (l2 = suffix.length())) {
            return false;
        }
        for (int i2 = l1 - 1; i2 >= l1 - l2; --i2) {
            if (text.charAt(i2) == suffix.charAt(i2 + l2 - l1)) continue;
            return false;
        }
        return true;
    }

    private static int lastIndexOf(@NotNull CharSequence s2, char c2, int start, int end) {
        if (s2 == null) {
            UrlClassLoader.$$$reportNull$$$0(32);
        }
        start = Math.max(start, 0);
        for (int i2 = Math.min(end, s2.length()) - 1; i2 >= start; --i2) {
            if (s2.charAt(i2) != c2) continue;
            return i2;
        }
        return -1;
    }

    private static void processDots(StringBuilder result2, int dots, int start) {
        if (dots == 2) {
            int pos = -1;
            if (!UrlClassLoader.endsWith(result2, "/../") && !"../".contentEquals(result2)) {
                pos = UrlClassLoader.lastIndexOf(result2, '/', start, result2.length() - 1);
                if (pos >= 0) {
                    ++pos;
                } else if (start > 0) {
                    pos = start;
                } else if (result2.length() > 0) {
                    pos = 0;
                }
            }
            if (pos >= 0) {
                result2.delete(pos, result2.length());
            } else {
                result2.append("../");
            }
        } else if (dots != 1) {
            for (int i2 = 0; i2 < dots; ++i2) {
                result2.append('.');
            }
            result2.append('/');
        }
    }

    private static int processRoot(String path, StringBuilder result2) {
        if (!path.isEmpty() && path.charAt(0) == '/') {
            result2.append('/');
            return 1;
        }
        if (path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) == '/') {
            result2.append(path, 0, 3);
            return 3;
        }
        return 0;
    }

    private void logError(String message2, Throwable t2) {
        try {
            Class<?> logger = this.loadClass("org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Object instance2 = lookup.findStatic(logger, "getInstance", MethodType.methodType(logger, Class.class)).invoke(this.getClass());
            lookup.findVirtual(logger, "error", MethodType.methodType(Void.TYPE, String.class, Throwable.class)).bindTo(instance2).invokeExact(message2, t2);
        }
        catch (Throwable tt) {
            t2.addSuppressed(tt);
            System.err.println(this.getClass().getName() + ": " + message2);
            t2.printStackTrace(System.err);
        }
    }

    @NotNull
    public static String urlToFilePath(@NotNull String url) {
        if (url == null) {
            UrlClassLoader.$$$reportNull$$$0(33);
        }
        int start = url.startsWith("file:") ? "file:".length() : 0;
        int end = url.indexOf("!/");
        if (url.charAt(start) == '/' && url.length() > start + 2 && url.charAt(start + 2) == ':') {
            ++start;
        }
        String string = UrlUtilRt.unescapePercentSequences(url, start, end < 0 ? url.length() : end).toString();
        if (string == null) {
            UrlClassLoader.$$$reportNull$$$0(34);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 14: 
            case 15: 
            case 27: 
            case 28: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 14: 
            case 15: 
            case 27: 
            case 28: 
            case 34: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jar";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 14: 
            case 15: 
            case 27: 
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 12: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameFilter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseUrls";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingStats";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultBuilderForJdk";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findResources";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassLoadingLock";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToFilePath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendToClassPathForInstrumentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 14: 
            case 15: 
            case 27: 
            case 28: 
            case 34: {
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerInClassLoaderValueMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBuilderForJdk";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addURL";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isByteBufferSupported";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "consumeClassData";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findResource";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsBytes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsStream";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findResources";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPath";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "urlToFilePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 14: 
            case 15: 
            case 27: 
            case 28: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

