/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.jar.Attributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.lang.ClassPath;
import org.jetbrains.kotlin.com.intellij.util.lang.Loader;
import org.jetbrains.kotlin.com.intellij.util.lang.Resource;
import org.jetbrains.kotlin.com.intellij.util.lang.ResourceFile;

final class JarLoader
implements Loader {
    private static final Map.Entry<Attribute, Attributes.Name>[] PACKAGE_FIELDS = new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Attribute, Attributes.Name>(Attribute.SPEC_TITLE, Attributes.Name.SPECIFICATION_TITLE), new AbstractMap.SimpleImmutableEntry<Attribute, Attributes.Name>(Attribute.SPEC_VERSION, Attributes.Name.SPECIFICATION_VERSION), new AbstractMap.SimpleImmutableEntry<Attribute, Attributes.Name>(Attribute.SPEC_VENDOR, Attributes.Name.SPECIFICATION_VENDOR), new AbstractMap.SimpleImmutableEntry<Attribute, Attributes.Name>(Attribute.CLASS_PATH, Attributes.Name.CLASS_PATH), new AbstractMap.SimpleImmutableEntry<Attribute, Attributes.Name>(Attribute.IMPL_TITLE, Attributes.Name.IMPLEMENTATION_TITLE), new AbstractMap.SimpleImmutableEntry<Attribute, Attributes.Name>(Attribute.IMPL_VERSION, Attributes.Name.IMPLEMENTATION_VERSION), new AbstractMap.SimpleImmutableEntry<Attribute, Attributes.Name>(Attribute.IMPL_VENDOR, Attributes.Name.IMPLEMENTATION_VENDOR)};
    final ClassPath configuration;
    final URL url;
    final ResourceFile zipFile;
    private final Path path;

    JarLoader(@NotNull Path path, @NotNull ClassPath configuration2, @NotNull ResourceFile zipFile) throws IOException {
        if (path == null) {
            JarLoader.$$$reportNull$$$0(0);
        }
        if (configuration2 == null) {
            JarLoader.$$$reportNull$$$0(1);
        }
        if (zipFile == null) {
            JarLoader.$$$reportNull$$$0(2);
        }
        this.path = path;
        this.configuration = configuration2;
        this.zipFile = zipFile;
        this.url = new URL("jar", "", -1, JarLoader.fileToUri(path) + "!/");
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public Class<?> findClass(String fileName, String className, ClassPath.ClassDataConsumer classConsumer) throws IOException {
        return this.zipFile.findClass(fileName, className, this, classConsumer);
    }

    @NotNull
    private static URI fileToUri(@NotNull Path file) {
        String path;
        if (file == null) {
            JarLoader.$$$reportNull$$$0(3);
        }
        if (!(path = file.toString().replace(File.separatorChar, '/')).startsWith("/")) {
            path = '/' + path;
        } else if (path.startsWith("//")) {
            path = "//" + path;
        }
        try {
            return new URI("file", null, path, null);
        }
        catch (URISyntaxException e2) {
            throw new IllegalArgumentException(path, e2);
        }
    }

    @NotNull
    static Map<Attribute, String> getAttributes(@NotNull Attributes attributes) {
        if (attributes == null) {
            JarLoader.$$$reportNull$$$0(4);
        }
        if (attributes.isEmpty()) {
            Map<Attribute, String> map = Collections.emptyMap();
            if (map == null) {
                JarLoader.$$$reportNull$$$0(5);
            }
            return map;
        }
        EnumMap<Attribute, String> map = null;
        for (Map.Entry<Attribute, Attributes.Name> p2 : PACKAGE_FIELDS) {
            String value2 = attributes.getValue(p2.getValue());
            if (value2 == null) continue;
            if (map == null) {
                map = new EnumMap<Attribute, String>(Attribute.class);
            }
            map.put(p2.getKey(), value2);
        }
        Map<Attribute, String> map2 = map == null ? Collections.emptyMap() : map;
        if (map2 == null) {
            JarLoader.$$$reportNull$$$0(6);
        }
        return map2;
    }

    @Override
    @Nullable
    public Resource getResource(@NotNull String name2) {
        if (name2 == null) {
            JarLoader.$$$reportNull$$$0(7);
        }
        try {
            return this.zipFile.getResource(name2, this);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return "JarLoader(path=" + this.path + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/lang/JarLoader";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameFilter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/lang/JarLoader";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fileToUri";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResource";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum Attribute {
        SPEC_TITLE,
        SPEC_VERSION,
        SPEC_VENDOR,
        CLASS_PATH,
        IMPL_TITLE,
        IMPL_VERSION,
        IMPL_VENDOR;

    }
}

