/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.lower.InlineClassDeclarationLoweringKt;
import org.jetbrains.kotlin.backend.common.lower.InlineClassLowering;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.ReferencedSymbolRemapper;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0013H\u0002J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InlineClassLowering;", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "isClassInlineLike", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "inlineClassDeclarationLowering", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "getInlineClassDeclarationLowering", "()Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "getOrCreateStaticMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "inlineClassUsageLowering", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "getInlineClassUsageLowering", "()Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "toInlineClassImplementationName", "Lorg/jetbrains/kotlin/name/Name;", "createStaticBodilessMethod", "ir.backend.common"})
public final class InlineClassLowering {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final DeclarationTransformer inlineClassDeclarationLowering;
    @NotNull
    private final BodyLoweringPass inlineClassUsageLowering;

    public InlineClassLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.inlineClassDeclarationLowering = new DeclarationTransformer(this){
            final /* synthetic */ InlineClassLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public List<IrDeclaration> transformFlat(IrDeclaration declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrDeclarationParent irDeclarationParent = declaration.getParent();
                IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
                if (irClass == null) {
                    return null;
                }
                IrClass irClass2 = irClass;
                if (!InlineClassLowering.access$isClassInlineLike(this.this$0, irClass2)) {
                    return null;
                }
                IrDeclaration irDeclaration = declaration;
                return irDeclaration instanceof IrConstructor ? this.transformConstructor((IrConstructor)declaration) : (irDeclaration instanceof IrSimpleFunction ? this.transformMethodFlat((IrSimpleFunction)declaration) : null);
            }

            private final List<IrDeclaration> transformConstructor(IrConstructor irConstructor) {
                if (irConstructor.isPrimary()) {
                    return this.transformPrimaryConstructor(irConstructor);
                }
                IrSimpleFunction result2 = InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, irConstructor);
                this.transformConstructorBody(irConstructor, result2);
                return CollectionsKt.listOf((Object)result2);
            }

            private final List<IrDeclaration> transformMethodFlat(IrSimpleFunction function2) {
                if (IrDeclarationsKt.isStaticMethodOfClass(function2) || !AdditionalIrUtilsKt.isReal(function2)) {
                    return null;
                }
                IrSimpleFunction staticMethod = InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, function2);
                this.transformMethodBodyFlat(function2, staticMethod);
                function2.setBody(this.delegateToStaticMethod(function2, staticMethod));
                if (function2.getOverriddenSymbols().isEmpty()) {
                    return CollectionsKt.listOf((Object)staticMethod);
                }
                Object[] objectArray = new IrSimpleFunction[]{function2, staticMethod};
                return CollectionsKt.listOf((Object[])objectArray);
            }

            /*
             * WARNING - void declaration
             */
            private final List<IrDeclaration> transformPrimaryConstructor(IrConstructor irConstructor) {
                IrBlockBody irBlockBody;
                IrSimpleFunction irSimpleFunction;
                IrClass klass = IrUtilsKt.getParentAsClass(irConstructor);
                IrSimpleType inlineClassType = IrUtilsKt.getDefaultType(klass);
                IrSimpleFunction it = irSimpleFunction = InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, irConstructor);
                boolean bl = false;
                it.setReturnType(inlineClassType);
                IrSimpleFunction initFunction = irSimpleFunction;
                Ref.ObjectRef delegatingCtorCall = new Ref.ObjectRef();
                Ref.ObjectRef setMemberField = new Ref.ObjectRef();
                IrSimpleFunction irSimpleFunction2 = initFunction;
                IrBody irBody = irConstructor.getBody();
                if (irBody != null) {
                    void body;
                    IrBody irBody2 = irBody;
                    InlineClassLowering inlineClassLowering = this.this$0;
                    IrBody irBody3 = irBody2;
                    IrSimpleFunction irSimpleFunction3 = irSimpleFunction2;
                    boolean bl2 = false;
                    irBlockBody = IrFactoryHelpersKt.createBlockBody(inlineClassLowering.getContext().getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> inlineClassDeclarationLowering.1.transformPrimaryConstructor$lambda$4$lambda$3(irConstructor, inlineClassLowering, initFunction, (IrBody)body, delegatingCtorCall, klass, setMemberField, arg_0)));
                    irSimpleFunction2 = irSimpleFunction3;
                } else {
                    irBlockBody = null;
                }
                irSimpleFunction2.setBody(irBlockBody);
                if (irConstructor.getBody() != null) {
                    irConstructor.setBody(IrFactoryHelpersKt.createBlockBody(this.this$0.getContext().getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> inlineClassDeclarationLowering.1.transformPrimaryConstructor$lambda$7(delegatingCtorCall, setMemberField, arg_0))));
                }
                Object[] objectArray = new IrFunction[]{irConstructor, initFunction};
                return CollectionsKt.listOf((Object[])objectArray);
            }

            /*
             * WARNING - void declaration
             */
            private final void transformConstructorBody(IrConstructor irConstructor, IrSimpleFunction staticMethod) {
                IrBlockBody irBlockBody;
                if (irConstructor.isPrimary()) {
                    return;
                }
                IrClass irClass = IrUtilsKt.getParentAsClass(irConstructor);
                IrSimpleFunction irSimpleFunction = staticMethod;
                IrBody irBody = irConstructor.getBody();
                if (irBody != null) {
                    void constructorBody;
                    IrBody irBody2 = irBody;
                    InlineClassLowering inlineClassLowering = this.this$0;
                    IrBody irBody3 = irBody2;
                    IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
                    boolean bl = false;
                    irBlockBody = IrFactoryHelpersKt.createBlockBody(inlineClassLowering.getContext().getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> inlineClassDeclarationLowering.1.transformConstructorBody$lambda$12$lambda$11(inlineClassLowering, staticMethod, (IrBody)constructorBody, irConstructor, irClass, arg_0)));
                    irSimpleFunction = irSimpleFunction2;
                } else {
                    irBlockBody = null;
                }
                irSimpleFunction.setBody(irBlockBody);
            }

            /*
             * WARNING - void declaration
             */
            private final void transformMethodBodyFlat(IrSimpleFunction function2, IrSimpleFunction staticMethod) {
                IrBlockBody irBlockBody;
                if (IrDeclarationsKt.isStaticMethodOfClass(function2) || !AdditionalIrUtilsKt.isReal(function2)) {
                    return;
                }
                IrSimpleFunction irSimpleFunction = staticMethod;
                IrBody irBody = function2.getBody();
                if (irBody != null) {
                    void functionBody;
                    IrBody irBody2 = irBody;
                    InlineClassLowering inlineClassLowering = this.this$0;
                    IrBody irBody3 = irBody2;
                    IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
                    boolean bl = false;
                    irBlockBody = IrFactoryHelpersKt.createBlockBody(inlineClassLowering.getContext().getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> inlineClassDeclarationLowering.1.transformMethodBodyFlat$lambda$14$lambda$13((IrBody)functionBody, function2, staticMethod, inlineClassLowering, arg_0)));
                    irSimpleFunction = irSimpleFunction2;
                } else {
                    irBlockBody = null;
                }
                irSimpleFunction.setBody(irBlockBody);
            }

            private final IrBlockBody delegateToStaticMethod(IrSimpleFunction function2, IrSimpleFunction staticMethod) {
                return IrFactoryHelpersKt.createBlockBody(this.this$0.getContext().getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> inlineClassDeclarationLowering.1.delegateToStaticMethod$lambda$18(this.this$0, function2, staticMethod, arg_0)));
            }

            private static final IrTypeOperatorCallImpl transformPrimaryConstructor$lambda$4$lambda$3$lambda$2$unboxedInlineClassValue(IrBlockBodyBuilder builder, IrSimpleFunction initFunction, IrClass klass) {
                return ExpressionHelpersKt.irReinterpretCast(builder, ExpressionHelpersKt.irGet(builder, (IrValueDeclaration)CollectionsKt.single(initFunction.getParameters())), IrUtilsKt.getDefaultType(klass));
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit transformPrimaryConstructor$lambda$4$lambda$3(IrConstructor $irConstructor, InlineClassLowering this$0, IrSimpleFunction $initFunction, IrBody $body, Ref.ObjectRef $delegatingCtorCall, IrClass $klass, Ref.ObjectRef $setMemberField, IrBlockBody $this$createBlockBody) {
                void this_$iv$iv$iv;
                void startOffset$iv$iv;
                void $this$irBlockBody$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                IrValueParameterSymbol origParameterSymbol = ((IrValueParameter)CollectionsKt.single($irConstructor.getParameters())).getSymbol();
                Collection collection = $this$createBlockBody.getStatements();
                IrGeneratorWithScope $this$irBlockBody$iv = LowerUtilsKt.createIrBuilder$default(this$0.getContext(), (IrSymbol)$initFunction.getSymbol(), 0, 0, 6, null);
                boolean $i$f$irBlockBody = false;
                IrGeneratorWithScope irGeneratorWithScope = $this$irBlockBody$iv;
                int n2 = ((IrElement)$initFunction).getStartOffset();
                int endOffset$iv$iv = ((IrElement)$initFunction).getEndOffset();
                boolean $i$f$irBlockBody2 = false;
                IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
                boolean $i$f$blockBody = false;
                void $this$transformPrimaryConstructor_u24lambda_u244_u24lambda_u243_u24lambda_u242 = this_$iv$iv$iv;
                boolean bl = false;
                void builder = $this$transformPrimaryConstructor_u24lambda_u244_u24lambda_u243_u24lambda_u242;
                Intrinsics.checkNotNull((Object)$body, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                IrElement $this$deepCopyWithSymbols_u24default$iv = (IrBlockBody)$body;
                boolean $i$f$deepCopyWithSymbols = false;
                IrElement $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
                boolean $i$f$deepCopyImpl = false;
                DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                IrVisitorsKt.acceptVoid($this$deepCopyImpl$iv$iv, symbolRemapper$iv$iv);
                DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                boolean bl2 = false;
                ReferencedSymbolRemapper p0 = deepCopySymbolRemapper;
                TypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
                IrElement irElement = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, typeRemapper$iv$iv), null);
                if (irElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                }
                Iterable $this$forEach$iv = ((IrBlockBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrBlockBody)irElement), $initFunction)).getStatements();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IrStatement statement = (IrStatement)element$iv;
                    boolean bl3 = false;
                    $this$transformPrimaryConstructor_u24lambda_u244_u24lambda_u243_u24lambda_u242.unaryPlus(IrElementsKt.transformStatement(statement, new IrElementTransformerVoid((Ref.ObjectRef<IrDelegatingConstructorCall>)$delegatingCtorCall, $irConstructor, (IrBlockBodyBuilder)builder, $klass, (Ref.ObjectRef<IrSetField>)$setMemberField, $initFunction, origParameterSymbol){
                        final /* synthetic */ Ref.ObjectRef<IrDelegatingConstructorCall> $delegatingCtorCall;
                        final /* synthetic */ IrConstructor $irConstructor;
                        final /* synthetic */ IrBlockBodyBuilder $builder;
                        final /* synthetic */ IrClass $klass;
                        final /* synthetic */ Ref.ObjectRef<IrSetField> $setMemberField;
                        final /* synthetic */ IrSimpleFunction $initFunction;
                        final /* synthetic */ IrValueParameterSymbol $origParameterSymbol;
                        {
                            this.$delegatingCtorCall = $delegatingCtorCall;
                            this.$irConstructor = $irConstructor;
                            this.$builder = $builder;
                            this.$klass = $klass;
                            this.$setMemberField = $setMemberField;
                            this.$initFunction = $initFunction;
                            this.$origParameterSymbol = $origParameterSymbol;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public IrExpression visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                            void this_$iv$iv;
                            void $this$deepCopyWithSymbols_u24default$iv;
                            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                            IrElement irElement = expression2;
                            IrDeclarationParent initialParent$iv = this.$irConstructor;
                            boolean $i$f$deepCopyWithSymbols = false;
                            void $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
                            boolean $i$f$deepCopyImpl = false;
                            Object symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                            IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyImpl$iv$iv, (IrVisitorVoid)symbolRemapper$iv$iv);
                            DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                            Ref.ObjectRef<IrDelegatingConstructorCall> objectRef = this.$delegatingCtorCall;
                            boolean bl = false;
                            ReferencedSymbolRemapper p0 = deepCopySymbolRemapper;
                            TypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
                            IrElement irElement2 = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols((SymbolRemapper)symbolRemapper$iv$iv, typeRemapper$iv$iv), null);
                            if (irElement2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall");
                            }
                            objectRef.element = PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrDelegatingConstructorCall)irElement2), initialParent$iv);
                            IrBuilderWithScope $this$irBlock_u24default$iv = this.$builder;
                            int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
                            int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
                            IrStatementOrigin origin$iv = null;
                            IrType resultType$iv = null;
                            boolean $i$f$irBlock = false;
                            symbolRemapper$iv$iv = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                            boolean $i$f$block = false;
                            void $this$visitDelegatingConstructorCall_u24lambda_u240 = this_$iv$iv;
                            boolean bl2 = false;
                            return (IrExpression)this_$iv$iv.doBuild();
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public IrExpression visitSetField(IrSetField expression2) {
                            Object typeRemapper$iv$iv;
                            IrBuilderWithScope $this$deepCopyWithSymbols_u24default$iv;
                            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                            boolean isMemberFieldSet = Intrinsics.areEqual((Object)((IrField)expression2.getSymbol().getOwner()).getParent(), (Object)this.$klass);
                            if (isMemberFieldSet) {
                                IrElement irElement = expression2;
                                IrDeclarationParent initialParent$iv = this.$irConstructor;
                                boolean $i$f$deepCopyWithSymbols = false;
                                IrBuilderWithScope $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
                                boolean $i$f$deepCopyImpl = false;
                                DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                                IrVisitorsKt.acceptVoid((IrElement)((Object)$this$deepCopyImpl$iv$iv), symbolRemapper$iv$iv);
                                DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                                Ref.ObjectRef<IrSetField> objectRef = this.$setMemberField;
                                boolean bl = false;
                                ReferencedSymbolRemapper p0 = deepCopySymbolRemapper;
                                typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
                                IrElement irElement2 = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, (TypeRemapper)typeRemapper$iv$iv), null);
                                if (irElement2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrSetField");
                                }
                                objectRef.element = PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrSetField)irElement2), initialParent$iv);
                            }
                            this.transformChildrenVoid(expression2);
                            if (isMemberFieldSet) {
                                void this_$iv$iv;
                                void $this$irBlock_u24default$iv;
                                $this$deepCopyWithSymbols_u24default$iv = this.$builder;
                                IrBlockBodyBuilder irBlockBodyBuilder = this.$builder;
                                int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
                                int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
                                IrStatementOrigin origin$iv = null;
                                IrType resultType$iv = null;
                                boolean $i$f$irBlock = false;
                                typeRemapper$iv$iv = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                                boolean $i$f$block = false;
                                void $this$visitSetField_u24lambda_u242 = this_$iv$iv;
                                boolean bl = false;
                                if (!org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isPure$default(expression2.getValue(), true, false, null, 6, null)) {
                                    void this_$iv$iv2;
                                    $this$visitSetField_u24lambda_u242.unaryPlus(expression2.getValue());
                                    IrBuilderWithScope $this$irBlock_u24default$iv2 = irBlockBodyBuilder;
                                    int startOffset$iv2 = $this$irBlock_u24default$iv2.getStartOffset();
                                    int endOffset$iv2 = $this$irBlock_u24default$iv2.getEndOffset();
                                    IrStatementOrigin origin$iv2 = null;
                                    IrType resultType$iv2 = null;
                                    boolean $i$f$irBlock2 = false;
                                    IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv2.getContext(), $this$irBlock_u24default$iv2.getScope(), startOffset$iv2, endOffset$iv2, origin$iv2, resultType$iv2, false, 64, null);
                                    boolean $i$f$block2 = false;
                                    void var22_27 = this_$iv$iv2;
                                    void var23_28 = $this$visitSetField_u24lambda_u242;
                                    boolean bl2 = false;
                                    var23_28.unaryPlus((IrStatement)this_$iv$iv2.doBuild());
                                }
                                return (IrExpression)this_$iv$iv.doBuild();
                            }
                            return expression2;
                        }

                        public IrExpression visitGetField(IrGetField expression2) {
                            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                            this.transformChildrenVoid(expression2);
                            if (Intrinsics.areEqual((Object)((IrField)expression2.getSymbol().getOwner()).getParent(), (Object)this.$klass)) {
                                return ExpressionHelpersKt.irGet(this.$builder, (IrValueDeclaration)CollectionsKt.single(this.$initFunction.getParameters()));
                            }
                            return expression2;
                        }

                        public IrExpression visitGetValue(IrGetValue expression2) {
                            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                            this.transformChildrenVoid(expression2);
                            if (Intrinsics.areEqual((Object)expression2.getSymbol().getOwner().getParent(), (Object)this.$klass)) {
                                return inlineClassDeclarationLowering.1.access$transformPrimaryConstructor$lambda$4$lambda$3$lambda$2$unboxedInlineClassValue(this.$builder, this.$initFunction, this.$klass);
                            }
                            if (Intrinsics.areEqual((Object)expression2.getSymbol(), (Object)this.$origParameterSymbol)) {
                                return ExpressionHelpersKt.irGet(this.$builder, (IrValueDeclaration)CollectionsKt.single(this.$initFunction.getParameters()));
                            }
                            return expression2;
                        }

                        public IrExpression visitSetValue(IrSetValue expression2) {
                            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                            this.transformChildrenVoid(expression2);
                            if (Intrinsics.areEqual((Object)expression2.getSymbol(), (Object)this.$origParameterSymbol)) {
                                return ExpressionHelpersKt.irSet$default((IrBuilder)this.$builder, (IrValueDeclaration)CollectionsKt.single(this.$initFunction.getParameters()), expression2.getValue(), null, 4, null);
                            }
                            return expression2;
                        }
                    }));
                }
                $this$transformPrimaryConstructor_u24lambda_u244_u24lambda_u243_u24lambda_u242.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$transformPrimaryConstructor_u24lambda_u244_u24lambda_u243_u24lambda_u242, inlineClassDeclarationLowering.1.transformPrimaryConstructor$lambda$4$lambda$3$lambda$2$unboxedInlineClassValue((IrBlockBodyBuilder)builder, $initFunction, $klass)));
                Iterable iterable = this_$iv$iv$iv.doBuild().getStatements();
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                return Unit.INSTANCE;
            }

            private static final Unit transformPrimaryConstructor$lambda$7(Ref.ObjectRef $delegatingCtorCall, Ref.ObjectRef $setMemberField, IrBlockBody $this$createBlockBody) {
                block1: {
                    IrDeclarationReference it;
                    Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                    IrDelegatingConstructorCall irDelegatingConstructorCall = (IrDelegatingConstructorCall)$delegatingCtorCall.element;
                    if (irDelegatingConstructorCall != null) {
                        it = irDelegatingConstructorCall;
                        boolean bl = false;
                        ((Collection)$this$createBlockBody.getStatements()).add(it);
                    }
                    IrSetField irSetField = (IrSetField)$setMemberField.element;
                    if (irSetField == null) break block1;
                    it = irSetField;
                    boolean bl = false;
                    ((Collection)$this$createBlockBody.getStatements()).add(it);
                }
                return Unit.INSTANCE;
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit transformConstructorBody$lambda$12$lambda$11(InlineClassLowering this$0, IrSimpleFunction $staticMethod, IrBody $constructorBody, IrConstructor $irConstructor, IrClass $irClass, IrBlockBody $this$createBlockBody) {
                IrVariable irVariable;
                void $this$associateByTo$iv$iv;
                void this_$iv$iv$iv;
                void startOffset$iv$iv;
                void $this$irBlockBody$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                Collection collection = $this$createBlockBody.getStatements();
                IrGeneratorWithScope $this$irBlockBody$iv = LowerUtilsKt.createIrBuilder$default(this$0.getContext(), (IrSymbol)$staticMethod.getSymbol(), 0, 0, 6, null);
                boolean $i$f$irBlockBody = false;
                IrGeneratorWithScope irGeneratorWithScope = $this$irBlockBody$iv;
                int n2 = ((IrElement)$staticMethod).getStartOffset();
                int endOffset$iv$iv = ((IrElement)$staticMethod).getEndOffset();
                boolean $i$f$irBlockBody2 = false;
                IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
                boolean $i$f$blockBody = false;
                void $this$transformConstructorBody_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410 = this_$iv$iv$iv;
                boolean bl = false;
                Ref.ObjectRef thisVar = new Ref.ObjectRef();
                Iterable $this$associateBy$iv = $staticMethod.getParameters();
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    IrValueParameter irValueParameter = (IrValueParameter)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl2 = false;
                    map.put($irConstructor.getParameters().get(it.getIndexInParameters()).getSymbol(), element$iv$iv);
                }
                Map parameterMapping = destination$iv$iv;
                Intrinsics.checkNotNull((Object)$constructorBody, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                Iterable $this$forEach$iv = ((IrBlockBody)$constructorBody).getStatements();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IrStatement statement = (IrStatement)element$iv;
                    boolean bl3 = false;
                    $this$transformConstructorBody_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.unaryPlus(IrElementsKt.transformStatement(statement, new IrElementTransformerVoid($irClass, (IrBlockBodyBuilder)$this$transformConstructorBody_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410, (Ref.ObjectRef<IrVariable>)thisVar, $staticMethod, parameterMapping, $irConstructor){
                        final /* synthetic */ IrClass $irClass;
                        final /* synthetic */ IrBlockBodyBuilder $this_irBlockBody;
                        final /* synthetic */ Ref.ObjectRef<IrVariable> $thisVar;
                        final /* synthetic */ IrSimpleFunction $staticMethod;
                        final /* synthetic */ Map<IrValueParameterSymbol, IrValueParameter> $parameterMapping;
                        final /* synthetic */ IrConstructor $irConstructor;
                        {
                            this.$irClass = $irClass;
                            this.$this_irBlockBody = $receiver;
                            this.$thisVar = $thisVar;
                            this.$staticMethod = $staticMethod;
                            this.$parameterMapping = $parameterMapping;
                            this.$irConstructor = $irConstructor;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public IrExpression visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                            IrVariable irVariable;
                            void this_$iv$iv$iv;
                            void $this$irBlock_u24default$iv;
                            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                            this.transformChildrenVoid(expression2);
                            expression2.setType(IrUtilsKt.getDefaultType(this.$irClass));
                            IrGeneratorWithScope irGeneratorWithScope = this.$this_irBlockBody;
                            Ref.ObjectRef<IrVariable> objectRef = this.$thisVar;
                            IrClass irClass = this.$irClass;
                            IrSimpleFunction irSimpleFunction = this.$staticMethod;
                            IrStatementOrigin origin$iv = null;
                            IrType resultType$iv = ((IrExpression)expression2).getType();
                            int startOffset$iv = ((IrExpression)expression2).getStartOffset();
                            int endOffset$iv = ((IrExpression)expression2).getEndOffset();
                            boolean $i$f$irBlock = false;
                            void $this$irBlock$iv$iv = $this$irBlock_u24default$iv;
                            boolean $i$f$irBlock2 = false;
                            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                            boolean $i$f$block = false;
                            void $this$visitDelegatingConstructorCall_u24lambda_u240 = this_$iv$iv$iv;
                            boolean bl = false;
                            objectRef.element = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)$this$visitDelegatingConstructorCall_u24lambda_u240, (IrExpression)expression2, null, false, null, (IrType)IrUtilsKt.getDefaultType(irClass), 14, null);
                            if (objectRef.element == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"thisVar");
                                irVariable = null;
                            } else {
                                irVariable = (IrVariable)objectRef.element;
                            }
                            irVariable.setParent(irSimpleFunction);
                            return (IrExpression)this_$iv$iv$iv.doBuild();
                        }

                        public IrExpression visitGetValue(IrGetValue expression2) {
                            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                            this.transformChildrenVoid(expression2);
                            IrValueParameter irValueParameter = this.$irClass.getThisReceiver();
                            if (Intrinsics.areEqual((Object)expression2.getSymbol(), (Object)(irValueParameter != null ? irValueParameter.getSymbol() : null))) {
                                IrVariable irVariable;
                                IrBuilder irBuilder = this.$this_irBlockBody;
                                if (this.$thisVar.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"thisVar");
                                    irVariable = null;
                                } else {
                                    irVariable = (IrVariable)this.$thisVar.element;
                                }
                                return ExpressionHelpersKt.irGet(irBuilder, irVariable);
                            }
                            IrValueParameter irValueParameter2 = this.$parameterMapping.get(expression2.getSymbol());
                            if (irValueParameter2 != null) {
                                IrValueParameter irValueParameter3 = irValueParameter2;
                                IrBlockBodyBuilder irBlockBodyBuilder = this.$this_irBlockBody;
                                IrValueParameter it = irValueParameter3;
                                boolean bl = false;
                                return ExpressionHelpersKt.irGet(irBlockBodyBuilder, it);
                            }
                            return expression2;
                        }

                        public IrExpression visitSetValue(IrSetValue expression2) {
                            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                            this.transformChildrenVoid(expression2);
                            IrValueParameter irValueParameter = this.$parameterMapping.get(expression2.getSymbol());
                            if (irValueParameter != null) {
                                IrValueParameter irValueParameter2 = irValueParameter;
                                IrBlockBodyBuilder irBlockBodyBuilder = this.$this_irBlockBody;
                                IrValueParameter it = irValueParameter2;
                                boolean bl = false;
                                return ExpressionHelpersKt.irSet$default((IrBuilder)irBlockBodyBuilder, it.getSymbol(), expression2.getValue(), null, 4, null);
                            }
                            return expression2;
                        }

                        public IrStatement visitDeclaration(IrDeclarationBase declaration) {
                            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                            IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
                            if (Intrinsics.areEqual((Object)declaration.getParent(), (Object)this.$irConstructor)) {
                                declaration.setParent(this.$staticMethod);
                            }
                            return declaration;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public IrExpression visitReturn(IrReturn expression2) {
                            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                            this.transformChildrenVoid(expression2);
                            if (Intrinsics.areEqual((Object)expression2.getReturnTargetSymbol(), (Object)this.$irConstructor.getSymbol())) {
                                IrVariable irVariable;
                                void $this$visitReturn_u24lambda_u243;
                                void this_$iv$iv;
                                void endOffset$iv;
                                void startOffset$iv;
                                void $this$irBlock_u24default$iv;
                                IrBuilderWithScope irBuilderWithScope = this.$this_irBlockBody;
                                int n2 = expression2.getStartOffset();
                                int n3 = expression2.getEndOffset();
                                Ref.ObjectRef<IrVariable> objectRef = this.$thisVar;
                                IrStatementOrigin origin$iv = null;
                                IrType resultType$iv = null;
                                boolean $i$f$irBlock = false;
                                IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), (int)startOffset$iv, (int)endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                                boolean $i$f$block = false;
                                void var11_11 = this_$iv$iv;
                                IrBuilderWithScope irBuilderWithScope2 = this.$this_irBlockBody;
                                boolean bl = false;
                                $this$visitReturn_u24lambda_u243.unaryPlus(expression2.getValue());
                                IrBuilder irBuilder = (IrBuilder)$this$visitReturn_u24lambda_u243;
                                if (objectRef.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"thisVar");
                                    irVariable = null;
                                } else {
                                    irVariable = (IrVariable)objectRef.element;
                                }
                                $this$visitReturn_u24lambda_u243.unaryPlus(ExpressionHelpersKt.irGet(irBuilder, irVariable));
                                return ExpressionHelpersKt.irReturn(irBuilderWithScope2, (IrExpression)this_$iv$iv.doBuild());
                            }
                            return expression2;
                        }
                    }));
                }
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$transformConstructorBody_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410;
                IrBuilder irBuilder = (IrBuilder)$this$transformConstructorBody_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410;
                if (thisVar.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"thisVar");
                    irVariable = null;
                } else {
                    irVariable = (IrVariable)thisVar.element;
                }
                $this$transformConstructorBody_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilder, irVariable)));
                Iterable iterable2 = this_$iv$iv$iv.doBuild().getStatements();
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
                return Unit.INSTANCE;
            }

            private static final Unit transformMethodBodyFlat$lambda$14$lambda$13(IrBody $functionBody, IrSimpleFunction $function, IrSimpleFunction $staticMethod, InlineClassLowering this$0, IrBlockBody $this$createBlockBody) {
                Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                List<IrStatement> list = $this$createBlockBody.getStatements();
                Intrinsics.checkNotNull((Object)$functionBody, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                list.addAll((Collection<IrStatement>)((IrBlockBody)$functionBody).getStatements());
                IrElementTransformerVoidKt.transformChildrenVoid($this$createBlockBody, new IrElementTransformerVoid($function, $staticMethod, this$0){
                    final /* synthetic */ IrSimpleFunction $function;
                    final /* synthetic */ IrSimpleFunction $staticMethod;
                    final /* synthetic */ InlineClassLowering this$0;
                    {
                        this.$function = $function;
                        this.$staticMethod = $staticMethod;
                        this.this$0 = $receiver;
                    }

                    public IrStatement visitDeclaration(IrDeclarationBase declaration) {
                        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                        IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
                        if (Intrinsics.areEqual((Object)declaration.getParent(), (Object)this.$function)) {
                            declaration.setParent(this.$staticMethod);
                        }
                        return declaration;
                    }

                    public IrExpression visitGetValue(IrGetValue expression2) {
                        IrValueParameter irValueParameter;
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
                        IrValueParameter irValueParameter2 = irValueDeclaration instanceof IrValueParameter ? (IrValueParameter)irValueDeclaration : null;
                        if (irValueParameter2 == null) {
                            return super.visitGetValue(expression2);
                        }
                        IrValueParameter valueDeclaration = irValueParameter2;
                        IrBuilder irBuilder = LowerUtilsKt.createIrBuilder$default(this.this$0.getContext(), (IrSymbol)this.$staticMethod.getSymbol(), 0, 0, 6, null);
                        IrValueParameter irValueParameter3 = valueDeclaration;
                        if (Intrinsics.areEqual((Object)irValueParameter3, (Object)IrUtilsKt.getParentAsClass(this.$function).getThisReceiver())) {
                            irValueParameter = this.$staticMethod.getParameters().get(0);
                        } else if (this.$function.getParameters().contains(irValueParameter3)) {
                            irValueParameter = this.$staticMethod.getParameters().get(valueDeclaration.getIndexInParameters());
                        } else {
                            return expression2;
                        }
                        return ExpressionHelpersKt.irGet(irBuilder, irValueParameter);
                    }

                    public IrExpression visitSetValue(IrSetValue expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
                        IrValueParameter irValueParameter = irValueDeclaration instanceof IrValueParameter ? (IrValueParameter)irValueDeclaration : null;
                        if (irValueParameter == null) {
                            return super.visitSetValue(expression2);
                        }
                        IrValueParameter valueDeclaration = irValueParameter;
                        this.transformChildrenVoid(expression2);
                        IrValueParameter irValueParameter2 = valueDeclaration;
                        if (!this.$function.getParameters().contains(irValueParameter2)) {
                            return expression2;
                        }
                        return ExpressionHelpersKt.irSet$default((IrBuilder)LowerUtilsKt.createIrBuilder$default(this.this$0.getContext(), (IrSymbol)this.$staticMethod.getSymbol(), 0, 0, 6, null), this.$staticMethod.getParameters().get(valueDeclaration.getIndexInParameters()).getSymbol(), expression2.getValue(), null, 4, null);
                    }
                });
                return Unit.INSTANCE;
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit delegateToStaticMethod$lambda$18(InlineClassLowering this$0, IrSimpleFunction $function, IrSimpleFunction $staticMethod, IrBlockBody $this$createBlockBody) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$delegateToStaticMethod_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416;
                IrFunctionAccessExpression irFunctionAccessExpression;
                void this_$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                Collection collection = $this$createBlockBody.getStatements();
                IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this$0.getContext(), (IrSymbol)$function.getSymbol(), 0, 0, 6, null);
                int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
                boolean $i$f$irBlockBody = false;
                IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
                boolean $i$f$blockBody = false;
                void $this$delegateToStaticMethod_u24lambda_u2418_u24lambda_u2417 = this_$iv$iv;
                boolean bl = false;
                IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)$this$delegateToStaticMethod_u24lambda_u2418_u24lambda_u2417, $staticMethod);
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$delegateToStaticMethod_u24lambda_u2418_u24lambda_u2417;
                void var16_16 = $this$delegateToStaticMethod_u24lambda_u2418_u24lambda_u2417;
                boolean bl2 = false;
                Iterable iterable = $function.getParameters();
                List list = $this$delegateToStaticMethod_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416.getArguments();
                boolean $i$f$map = false;
                void var21_22 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    collection2.add(ExpressionHelpersKt.irGet((IrBuilder)$this$delegateToStaticMethod_u24lambda_u2418_u24lambda_u2417, (IrValueDeclaration)it));
                }
                AddToStdlibKt.assignFrom(list, (List)destination$iv$iv);
                List typeParameters2 = CollectionsKt.plus((Collection)IrTypeSystemContextKt.extractTypeParameters(IrUtilsKt.getParentAsClass($function)), (Iterable)$function.getTypeParameters());
                Iterator<T> iterator2 = ((Iterable)typeParameters2).iterator();
                int n2 = 0;
                while (iterator2.hasNext()) {
                    int index = n2++;
                    IrTypeParameter typeParameter = (IrTypeParameter)iterator2.next();
                    $this$delegateToStaticMethod_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416.getTypeArguments().set(index, new IrSimpleTypeImpl((IrClassifierSymbol)typeParameter.getSymbol(), SimpleTypeNullability.NOT_SPECIFIED, CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, 16, null));
                }
                Unit unit = Unit.INSTANCE;
                var16_16.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, irFunctionAccessExpression));
                Iterable iterable2 = this_$iv$iv.doBuild().getStatements();
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
                return Unit.INSTANCE;
            }

            public static final /* synthetic */ IrTypeOperatorCallImpl access$transformPrimaryConstructor$lambda$4$lambda$3$lambda$2$unboxedInlineClassValue(IrBlockBodyBuilder builder, IrSimpleFunction initFunction, IrClass klass) {
                return inlineClassDeclarationLowering.1.transformPrimaryConstructor$lambda$4$lambda$3$lambda$2$unboxedInlineClassValue(builder, initFunction, klass);
            }
        };
        this.inlineClassUsageLowering = new BodyLoweringPass(this){
            final /* synthetic */ InlineClassLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public void lower(IrBody irBody, IrDeclaration container) {
                Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
                Intrinsics.checkNotNullParameter((Object)container, (String)"container");
                IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this.this$0){
                    final /* synthetic */ InlineClassLowering this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public IrExpression visitConstructorCall(IrConstructorCall expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                        IrConstructor function2 = (IrConstructor)expression2.getSymbol().getOwner();
                        if (!InlineClassLowering.access$isClassInlineLike(this.this$0, IrUtilsKt.getParentAsClass(function2))) {
                            return expression2;
                        }
                        return IrUtilsKt.irCall$default((IrFunctionAccessExpression)expression2, InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, function2), null, null, 12, null);
                    }

                    public IrExpression visitCall(IrCall expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                        IrSimpleFunction function2 = (IrSimpleFunction)expression2.getSymbol().getOwner();
                        if (!(function2.getParent() instanceof IrClass) || IrDeclarationsKt.isStaticMethodOfClass(function2) || !InlineClassLowering.access$isClassInlineLike(this.this$0, IrUtilsKt.getParentAsClass(function2)) || !AdditionalIrUtilsKt.isReal(function2)) {
                            return expression2;
                        }
                        return IrUtilsKt.irCall$default((IrFunctionAccessExpression)expression2, InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, function2), null, null, 12, null);
                    }

                    public IrExpression visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                        IrConstructor function2 = (IrConstructor)expression2.getSymbol().getOwner();
                        IrClass klass = IrUtilsKt.getParentAsClass(function2);
                        return !InlineClassLowering.access$isClassInlineLike(this.this$0, klass) ? (IrExpression)expression2 : (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)expression2, InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, function2), null, null, 12, null);
                    }
                });
            }
        };
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    private final boolean isClassInlineLike(IrClass irClass) {
        return this.context.getInlineClassesUtils().isClassInlineLike(irClass);
    }

    @NotNull
    public final DeclarationTransformer getInlineClassDeclarationLowering() {
        return this.inlineClassDeclarationLowering;
    }

    private final IrSimpleFunction getOrCreateStaticMethod(IrFunction function2) {
        IrSimpleFunction irSimpleFunction = InlineClassDeclarationLoweringKt.access$getStaticMethod(function2);
        if (irSimpleFunction == null) {
            IrSimpleFunction irSimpleFunction2;
            IrSimpleFunction it = irSimpleFunction2 = this.createStaticBodilessMethod(function2);
            boolean bl = false;
            InlineClassDeclarationLoweringKt.access$setStaticMethod(function2, it);
            irSimpleFunction = irSimpleFunction2;
        }
        return irSimpleFunction;
    }

    @NotNull
    public final BodyLoweringPass getInlineClassUsageLowering() {
        return this.inlineClassUsageLowering;
    }

    private final Name toInlineClassImplementationName(IrFunction $this$toInlineClassImplementationName) {
        Name name2;
        String newName = IrUtilsKt.getParentAsClass($this$toInlineClassImplementationName).getName().asString() + "__" + $this$toInlineClassImplementationName.getName().asString() + "-impl";
        if ($this$toInlineClassImplementationName.getName().isSpecial()) {
            Name name3 = Name.special('<' + newName + '>');
            name2 = name3;
            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"special(...)");
        } else {
            Name name4 = Name.identifier(newName);
            name2 = name4;
            Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
        }
        return name2;
    }

    private final IrSimpleFunction createStaticBodilessMethod(IrFunction function2) {
        return IrUtilsKt.createStaticFunctionWithReceivers$default(this.context.getIrFactory(), function2.getParent(), this.toInlineClassImplementationName(function2), function2, null, null, null, null, false, false, IrTypeSystemContextKt.extractTypeParameters(IrUtilsKt.getParentAsClass(function2)), (Function3)new Function3<IrFunction, IrFunction, Map<IrValueParameter, ? extends IrValueParameter>, Unit>((Object)this.context){

            public final void invoke(IrFunction p0, IrFunction p1, Map<IrValueParameter, ? extends IrValueParameter> p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((CommonBackendContext)this.receiver).remapMultiFieldValueClassStructure(p0, p1, p2);
            }
        }, 504, null);
    }

    public static final /* synthetic */ boolean access$isClassInlineLike(InlineClassLowering $this, IrClass irClass) {
        return $this.isClassInlineLike(irClass);
    }

    public static final /* synthetic */ IrSimpleFunction access$getOrCreateStaticMethod(InlineClassLowering $this, IrFunction function2) {
        return $this.getOrCreateStaticMethod(function2);
    }
}

