/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import java.util.List;
import org.gradle.api.Action;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.manage.schema.ModelMapSchema;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.type.ModelType;

public class ModelMapStrategy
implements ModelSchemaExtractionStrategy {
    private static final ModelType<ModelMap<?>> MODEL_MAP_MODEL_TYPE = new ModelType<ModelMap<?>>(){};

    @Override
    public <T> void extract(ModelSchemaExtractionContext<T> extractionContext) {
        ModelType<T> type = extractionContext.getType();
        if (MODEL_MAP_MODEL_TYPE.isAssignableFrom(type)) {
            if (!type.getRawClass().equals(ModelMap.class)) {
                extractionContext.add(String.format("subtyping %s is not supported.", ModelMap.class.getName()));
                return;
            }
            if (type.isHasWildcardTypeVariables()) {
                extractionContext.add(String.format("type parameter of %s cannot be a wildcard.", ModelMap.class.getName()));
                return;
            }
            List typeVariables = type.getTypeVariables();
            if (typeVariables.isEmpty()) {
                extractionContext.add(String.format("type parameter of %s has to be specified.", ModelMap.class.getName()));
                return;
            }
            ModelType elementType = (ModelType)typeVariables.get(0);
            extractionContext.found(this.getModelSchema(extractionContext, elementType));
        }
    }

    private <T, E> ModelSchema<T> getModelSchema(ModelSchemaExtractionContext<T> extractionContext, ModelType<E> elementType) {
        final ModelMapSchema<T, E> schema = new ModelMapSchema<T, E>(extractionContext.getType(), elementType);
        extractionContext.child(elementType, "element type", new Action<ModelSchema<E>>(){

            public void execute(ModelSchema<E> elementTypeSchema) {
                schema.setElementTypeSchema(elementTypeSchema);
            }
        });
        return schema;
    }
}

