/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Preconditions;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractProperty;
import org.gradle.api.internal.provider.ManagedFactories;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueSanitizer;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.evaluation.EvaluationScopeContext;
import org.jspecify.annotations.Nullable;

public class DefaultProperty<T>
extends AbstractProperty<T, ProviderInternal<? extends T>>
implements Property<T> {
    private final Class<T> type;
    private final ValueSanitizer<T> sanitizer;
    private static final ProviderInternal<?> NOT_DEFINED = Providers.notDefined();

    public DefaultProperty(PropertyHost propertyHost, Class<T> type) {
        super(propertyHost);
        this.type = type;
        this.sanitizer = ValueSanitizers.forType(type);
        this.init(this.getDefaultValue());
    }

    @Override
    protected ProviderInternal<? extends T> getDefaultValue() {
        return Providers.notDefined();
    }

    @Override
    public Object unpackState() {
        return this.getProvider();
    }

    @Override
    public Class<?> publicType() {
        return Property.class;
    }

    @Override
    public int getFactoryId() {
        return ManagedFactories.PropertyManagedFactory.FACTORY_ID;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public void setFromAnyValue(Object object) {
        if (object instanceof Provider) {
            this.set((Provider)Cast.uncheckedNonnullCast((Object)object));
        } else {
            this.set(Cast.uncheckedNonnullCast((Object)object));
        }
    }

    public void set(@Nullable T value) {
        if (value == null) {
            this.discardValue();
        } else {
            this.setSupplier(Providers.fixedValue(this.getValidationDisplayName(), value, this.type, this.sanitizer));
        }
    }

    public Property<T> value(@Nullable T value) {
        this.set(value);
        return this;
    }

    public Property<T> value(Provider<? extends T> provider) {
        this.set(provider);
        return this;
    }

    public ProviderInternal<? extends T> getProvider() {
        try (EvaluationScopeContext context = this.openScope();){
            ProviderInternal providerInternal = (ProviderInternal)this.getSupplier(context);
            return providerInternal;
        }
    }

    public DefaultProperty<T> provider(Provider<? extends T> provider) {
        this.set(provider);
        return this;
    }

    public void set(Provider<? extends T> provider) {
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (Object)"Cannot set the value of a property using a null provider.");
        ProviderInternal<T> p = Providers.internal(provider);
        this.setSupplier(p.asSupplier(this.getValidationDisplayName(), this.type, this.sanitizer));
    }

    public Property<T> convention(@Nullable T value) {
        if (value == null) {
            this.setConvention(Providers.notDefined());
        } else {
            this.setConvention(Providers.fixedValue(this.getValidationDisplayName(), value, this.type, this.sanitizer));
        }
        return this;
    }

    public Property<T> convention(Provider<? extends T> provider) {
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (Object)"Cannot set the convention of a property using a null provider.");
        this.setConvention(Providers.internal(provider).asSupplier(this.getValidationDisplayName(), this.type, this.sanitizer));
        return this;
    }

    public Property<T> unset() {
        super.unset();
        return this;
    }

    public Property<T> unsetConvention() {
        this.discardConvention();
        return this;
    }

    @Override
    protected ValueSupplier.ExecutionTimeValue<? extends T> calculateOwnExecutionTimeValue(EvaluationScopeContext context, ProviderInternal<? extends T> value) {
        return value.calculateExecutionTimeValue();
    }

    @Override
    protected ValueSupplier.Value<? extends T> calculateValueFrom(EvaluationScopeContext context, ProviderInternal<? extends T> value, ValueSupplier.ValueConsumer consumer) {
        return value.calculateValue(consumer);
    }

    @Override
    protected ProviderInternal<? extends T> finalValue(EvaluationScopeContext context, ProviderInternal<? extends T> value, ValueSupplier.ValueConsumer consumer) {
        return value.withFinalValue(consumer);
    }

    @Override
    protected ProviderInternal<? extends T> getDefaultConvention() {
        return (ProviderInternal)Cast.uncheckedCast(NOT_DEFINED);
    }

    @Override
    protected boolean isDefaultConvention() {
        return this.getConventionSupplier() == NOT_DEFINED;
    }

    @Override
    protected String describeContents() {
        return String.format("property(%s, %s)", this.type.getName(), this.describeValue());
    }

    public void replace(Transformer<? extends @Nullable Provider<? extends T>, ? super Provider<T>> transformation) {
        Provider newValue = (Provider)transformation.transform(this.shallowCopy());
        if (newValue != null) {
            this.set(newValue);
        } else {
            this.set((T)null);
        }
    }
}

