/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import com.google.common.base.Objects;
import java.io.File;
import org.gradle.api.file.FileType;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.execution.history.changes.Change;
import org.gradle.internal.execution.history.changes.ChangeTypeInternal;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;

public class DefaultFileChange
implements Change,
FileChange,
InputFileDetails {
    private final String path;
    private final ChangeTypeInternal change;
    private final String title;
    private final org.gradle.internal.file.FileType previousFileType;
    private final org.gradle.internal.file.FileType currentFileType;
    private final String normalizedPath;

    public static DefaultFileChange added(String path, String title, org.gradle.internal.file.FileType currentFileType, String normalizedPath) {
        return new DefaultFileChange(path, ChangeTypeInternal.ADDED, title, org.gradle.internal.file.FileType.Missing, currentFileType, normalizedPath);
    }

    public static DefaultFileChange removed(String path, String title, org.gradle.internal.file.FileType previousFileType, String normalizedPath) {
        return new DefaultFileChange(path, ChangeTypeInternal.REMOVED, title, previousFileType, org.gradle.internal.file.FileType.Missing, normalizedPath);
    }

    public static DefaultFileChange modified(String path, String title, org.gradle.internal.file.FileType previousFileType, org.gradle.internal.file.FileType currentFileType, String normalizedPath) {
        return new DefaultFileChange(path, ChangeTypeInternal.MODIFIED, title, previousFileType, currentFileType, normalizedPath);
    }

    private DefaultFileChange(String path, ChangeTypeInternal change, String title, org.gradle.internal.file.FileType previousFileType, org.gradle.internal.file.FileType currentFileType, String normalizedPath) {
        this.path = path;
        this.change = change;
        this.title = title;
        this.previousFileType = previousFileType;
        this.currentFileType = currentFileType;
        this.normalizedPath = normalizedPath;
    }

    @Override
    public String getMessage() {
        return this.title + " file " + this.path + " " + this.getDisplayedChangeType().describe() + ".";
    }

    private ChangeTypeInternal getDisplayedChangeType() {
        if (this.change != ChangeTypeInternal.MODIFIED) {
            return this.change;
        }
        if (this.previousFileType == org.gradle.internal.file.FileType.Missing) {
            return ChangeTypeInternal.ADDED;
        }
        if (this.currentFileType == org.gradle.internal.file.FileType.Missing) {
            return ChangeTypeInternal.REMOVED;
        }
        return ChangeTypeInternal.MODIFIED;
    }

    public String toString() {
        return this.getMessage();
    }

    public String getPath() {
        return this.path;
    }

    public File getFile() {
        return new File(this.path);
    }

    public ChangeType getChangeType() {
        return this.change.getPublicType();
    }

    public FileType getFileType() {
        org.gradle.internal.file.FileType typeToConvert = this.change == ChangeTypeInternal.REMOVED ? this.previousFileType : this.currentFileType;
        return DefaultFileChange.toPublicFileType(typeToConvert);
    }

    public static FileType toPublicFileType(org.gradle.internal.file.FileType fileType) {
        switch (fileType) {
            case RegularFile: {
                return FileType.FILE;
            }
            case Directory: {
                return FileType.DIRECTORY;
            }
            case Missing: {
                return FileType.MISSING;
            }
        }
        throw new AssertionError();
    }

    public String getNormalizedPath() {
        return this.normalizedPath;
    }

    public ChangeTypeInternal getType() {
        return this.change;
    }

    public boolean isAdded() {
        return this.change == ChangeTypeInternal.ADDED;
    }

    public boolean isModified() {
        return this.change == ChangeTypeInternal.MODIFIED;
    }

    public boolean isRemoved() {
        return this.change == ChangeTypeInternal.REMOVED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultFileChange that = (DefaultFileChange)o;
        return Objects.equal((Object)this.path, (Object)that.path) && this.change == that.change && Objects.equal((Object)this.title, (Object)that.title) && Objects.equal((Object)this.previousFileType, (Object)that.previousFileType) && Objects.equal((Object)this.currentFileType, (Object)that.currentFileType) && Objects.equal((Object)this.normalizedPath, (Object)that.normalizedPath);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.path, this.change, this.title, this.previousFileType, this.currentFileType, this.normalizedPath});
    }
}

