/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ArtifactsAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.CachedArtifacts;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.DefaultCachedArtifacts;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ModuleArtifactsCache;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.hash.HashCode;
import org.gradle.util.internal.BuildCommencedTimeProvider;

public abstract class AbstractArtifactsCache
implements ModuleArtifactsCache {
    protected final BuildCommencedTimeProvider timeProvider;

    public AbstractArtifactsCache(BuildCommencedTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    @Override
    public CachedArtifacts cacheArtifacts(ModuleComponentRepository<?> repository, ComponentIdentifier componentId, String context, HashCode descriptorHash, Collection<? extends ComponentArtifactMetadata> artifacts) {
        ArtifactsAtRepositoryKey key = new ArtifactsAtRepositoryKey(repository.getId(), componentId, context);
        ModuleArtifactsCacheEntry entry = new ModuleArtifactsCacheEntry((Set<? extends ComponentArtifactMetadata>)ImmutableSet.copyOf(artifacts), this.timeProvider.getCurrentTime(), descriptorHash);
        this.store(key, entry);
        return this.createCacheArtifacts(entry);
    }

    protected abstract void store(ArtifactsAtRepositoryKey var1, ModuleArtifactsCacheEntry var2);

    @Override
    public CachedArtifacts getCachedArtifacts(ModuleComponentRepository<?> repository, ComponentIdentifier componentId, String context) {
        ArtifactsAtRepositoryKey key = new ArtifactsAtRepositoryKey(repository.getId(), componentId, context);
        ModuleArtifactsCacheEntry entry = this.get(key);
        return entry == null ? null : this.createCacheArtifacts(entry);
    }

    protected abstract ModuleArtifactsCacheEntry get(ArtifactsAtRepositoryKey var1);

    private CachedArtifacts createCacheArtifacts(ModuleArtifactsCacheEntry entry) {
        long entryAge = this.timeProvider.getCurrentTime() - entry.createTimestamp;
        return new DefaultCachedArtifacts(entry.artifacts, entry.moduleDescriptorHash, entryAge);
    }

    protected static class ModuleArtifactsCacheEntry {
        protected final Set<ComponentArtifactMetadata> artifacts;
        protected final HashCode moduleDescriptorHash;
        protected final long createTimestamp;

        ModuleArtifactsCacheEntry(Set<? extends ComponentArtifactMetadata> artifacts, long createTimestamp, HashCode moduleDescriptorHash) {
            this.artifacts = new LinkedHashSet<ComponentArtifactMetadata>(artifacts);
            this.createTimestamp = createTimestamp;
            this.moduleDescriptorHash = moduleDescriptorHash;
        }
    }
}

