/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import org.gradle.api.Action;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependencyCapabilitiesHandler;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.dependencies.AbstractExternalModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DependencyVariant;
import org.gradle.api.internal.artifacts.dependencies.MinimalExternalModuleDependencyInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.ModuleFactoryHelper;
import org.gradle.internal.Actions;
import org.gradle.util.internal.GUtil;
import org.jspecify.annotations.Nullable;

public class DefaultMinimalDependencyVariant
extends DefaultExternalModuleDependency
implements MinimalExternalModuleDependencyInternal,
DependencyVariant {
    private Action<? super AttributeContainer> attributesMutator;
    private Action<? super ModuleDependencyCapabilitiesHandler> capabilitiesMutator;
    private String classifier;
    private String artifactType;

    public DefaultMinimalDependencyVariant(MinimalExternalModuleDependency delegate, @Nullable Action<? super AttributeContainer> attributesMutator, @Nullable Action<? super ModuleDependencyCapabilitiesHandler> capabilitiesMutator, @Nullable String classifier, @Nullable String artifactType) {
        super(delegate.getModule(), new DefaultMutableVersionConstraint(delegate.getVersionConstraint()), delegate.getTargetConfiguration());
        attributesMutator = (Action)GUtil.elvis(attributesMutator, (Object)Actions.doNothing());
        capabilitiesMutator = (Action)GUtil.elvis(capabilitiesMutator, (Object)Actions.doNothing());
        if (delegate instanceof DefaultMinimalDependencyVariant) {
            this.attributesMutator = Actions.composite((Action[])new Action[]{((DefaultMinimalDependencyVariant)delegate).attributesMutator, attributesMutator});
            this.capabilitiesMutator = Actions.composite((Action[])new Action[]{((DefaultMinimalDependencyVariant)delegate).capabilitiesMutator, capabilitiesMutator});
            this.classifier = (String)GUtil.elvis((Object)classifier, (Object)((DefaultMinimalDependencyVariant)delegate).getClassifier());
            this.artifactType = (String)GUtil.elvis((Object)classifier, (Object)((DefaultMinimalDependencyVariant)delegate).getArtifactType());
        } else {
            this.attributesMutator = attributesMutator;
            this.capabilitiesMutator = capabilitiesMutator;
            this.classifier = classifier;
            this.artifactType = artifactType;
        }
        MinimalExternalModuleDependencyInternal internal = (MinimalExternalModuleDependencyInternal)delegate;
        this.setAttributesFactory(internal.getAttributesFactory());
        this.setCapabilityNotationParser(internal.getCapabilityNotationParser());
        this.setObjectFactory(internal.getObjectFactory());
    }

    private DefaultMinimalDependencyVariant(ModuleIdentifier id, MutableVersionConstraint versionConstraint, @Nullable String configuration, Action<? super AttributeContainer> attributesMutator, Action<? super ModuleDependencyCapabilitiesHandler> capabilitiesMutator, @Nullable String classifier, @Nullable String artifactType) {
        super(id, versionConstraint, configuration);
        this.attributesMutator = attributesMutator;
        this.capabilitiesMutator = capabilitiesMutator;
        this.classifier = classifier;
        this.artifactType = artifactType;
    }

    @Override
    public void copyTo(AbstractExternalModuleDependency target) {
        super.copyTo(target);
        if (target instanceof DefaultMinimalDependencyVariant) {
            DefaultMinimalDependencyVariant depVariant = (DefaultMinimalDependencyVariant)target;
            depVariant.attributesMutator = this.attributesMutator;
            depVariant.capabilitiesMutator = this.capabilitiesMutator;
            depVariant.classifier = this.classifier;
            depVariant.artifactType = this.artifactType;
        } else {
            target.attributes(this.attributesMutator);
            target.capabilities(this.capabilitiesMutator);
            if (this.classifier != null || this.artifactType != null) {
                ModuleFactoryHelper.addExplicitArtifactsIfDefined((ExternalDependency)target, this.artifactType, this.classifier);
            }
        }
    }

    public MinimalExternalModuleDependency copy() {
        DefaultMinimalDependencyVariant dependency = new DefaultMinimalDependencyVariant(this.getModule(), new DefaultMutableVersionConstraint(this.getVersionConstraint()), this.getTargetConfiguration(), this.attributesMutator, this.capabilitiesMutator, this.classifier, this.artifactType);
        this.copyTo(dependency);
        return dependency;
    }

    public void because(String reason) {
        this.validateMutation();
    }

    protected void validateMutation() {
        throw new UnsupportedOperationException("Minimal dependencies are immutable.");
    }

    protected void validateMutation(Object currentValue, Object newValue) {
        this.validateMutation();
    }

    @Override
    public void mutateAttributes(AttributeContainer attributes) {
        this.attributesMutator.execute((Object)attributes);
    }

    @Override
    public void mutateCapabilities(ModuleDependencyCapabilitiesHandler capabilitiesHandler) {
        this.capabilitiesMutator.execute((Object)capabilitiesHandler);
    }

    @Override
    public @Nullable String getClassifier() {
        return this.classifier;
    }

    @Override
    public @Nullable String getArtifactType() {
        return this.artifactType;
    }

    @Override
    public String toString() {
        return "DefaultMinimalDependencyVariant{, attributesMutator=" + this.attributesMutator + ", capabilitiesMutator=" + this.capabilitiesMutator + ", classifier='" + this.classifier + '\'' + ", artifactType='" + this.artifactType + '\'' + "} " + super.toString();
    }
}

