/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fo.properties.PropertyMaker;

public final class OptionalCharacterProperty
extends Property {
    private static final PropertyCache<OptionalCharacterProperty> CACHE = new PropertyCache();
    private final Character character;

    private OptionalCharacterProperty(Character character) {
        this.character = character;
    }

    public static OptionalCharacterProperty getInstance(Character character) {
        return CACHE.fetch(new OptionalCharacterProperty(character));
    }

    @Override
    public Object getObject() {
        return this.character;
    }

    @Override
    public char getCharacter() {
        return this.character == null ? (char)'\u0000' : this.character.charValue();
    }

    @Override
    public String getString() {
        return this.character == null ? "" : this.character.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof OptionalCharacterProperty) {
            OptionalCharacterProperty ocp = (OptionalCharacterProperty)obj;
            if (this.character == null && ocp.character == null) {
                return true;
            }
            return this.character != null && this.character.equals(ocp.character);
        }
        return false;
    }

    public int hashCode() {
        return this.character == null ? 0 : this.character.hashCode();
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        @Override
        public Property make(PropertyList propertyList, String value, FObj fo) {
            if (value.isEmpty()) {
                return OptionalCharacterProperty.getInstance(null);
            }
            char c = value.charAt(0);
            return OptionalCharacterProperty.getInstance(Character.valueOf(c));
        }
    }
}

