/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.CompoundDatatype;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CompoundPropertyMaker;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.util.CompareUtil;

public class LengthPairProperty
extends Property
implements CompoundDatatype {
    private Property ipd;
    private Property bpd;

    public LengthPairProperty() {
    }

    public LengthPairProperty(Property ipd, Property bpd) {
        this();
        this.ipd = ipd;
        this.bpd = bpd;
    }

    public LengthPairProperty(Property len) {
        this(len, len);
    }

    @Override
    public void setComponent(int cmpId, Property cmpnValue, boolean bIsDefault) {
        if (cmpId == 512) {
            this.bpd = cmpnValue;
        } else if (cmpId == 1536) {
            this.ipd = cmpnValue;
        }
    }

    @Override
    public Property getComponent(int cmpId) {
        if (cmpId == 512) {
            return this.getBPD();
        }
        if (cmpId == 1536) {
            return this.getIPD();
        }
        return null;
    }

    public Property getIPD() {
        return this.ipd;
    }

    public Property getBPD() {
        return this.bpd;
    }

    @Override
    public String toString() {
        return "LengthPair[ipd:" + this.getIPD().getObject() + ", bpd:" + this.getBPD().getObject() + "]";
    }

    @Override
    public LengthPairProperty getLengthPair() {
        return this;
    }

    @Override
    public Object getObject() {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + CompareUtil.getHashCode(this.bpd);
        result = 31 * result + CompareUtil.getHashCode(this.ipd);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LengthPairProperty)) {
            return false;
        }
        LengthPairProperty other = (LengthPairProperty)obj;
        return CompareUtil.equal(this.bpd, other.bpd) && CompareUtil.equal(this.ipd, other.ipd);
    }

    public static class Maker
    extends CompoundPropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        @Override
        public Property makeNewProperty() {
            return new LengthPairProperty();
        }

        @Override
        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
            if (p instanceof LengthPairProperty) {
                return p;
            }
            return super.convertProperty(p, propertyList, fo);
        }
    }
}

