/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.model;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseAbstractDataType;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseDataSource;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseTupleTypeAttribute;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.Pair;

public class ClickhouseTupleType
extends ClickhouseAbstractDataType
implements DBSEntity {
    private final List<ClickhouseTupleTypeAttribute> attributes;
    private final String baseName;
    private final String fullName;

    public ClickhouseTupleType(@NotNull ClickhouseDataSource dataSource, @NotNull List<Pair<String, DBSDataType>> elements) {
        this(dataSource, "Tuple", elements);
    }

    protected ClickhouseTupleType(@NotNull ClickhouseDataSource dataSource, @NotNull String name, @NotNull List<Pair<String, DBSDataType>> elements) {
        super(dataSource);
        this.attributes = IntStream.range(0, elements.size()).mapToObj(index -> new ClickhouseTupleTypeAttribute(this, (DBSDataType)((Pair)elements.get(index)).getSecond(), (String)((Pair)elements.get(index)).getFirst(), index)).toList();
        this.baseName = name;
        this.fullName = name + elements.stream().map(Pair::getSecond).map(DBSTypedObject::getFullTypeName).collect(Collectors.joining(", ", "(", ")"));
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TYPE;
    }

    @NotNull
    public String getTypeName() {
        return this.baseName;
    }

    @NotNull
    public String getFullTypeName() {
        return this.fullName;
    }

    public int getTypeID() {
        return 2002;
    }

    @NotNull
    public DBPDataKind getDataKind() {
        return DBPDataKind.STRUCT;
    }

    @NotNull
    public List<ClickhouseTupleTypeAttribute> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public List<? extends DBSEntityAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) {
        return this.attributes;
    }

    @Nullable
    public DBSEntityAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) {
        return (DBSEntityAttribute)DBUtils.findObject(this.attributes, (String)attributeName);
    }

    @Nullable
    public Collection<? extends DBSEntityConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) {
        return null;
    }

    @Nullable
    public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) {
        return null;
    }

    @Nullable
    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) {
        return null;
    }
}

