/*
 * Decompiled with CFR 0.152.
 */
package org.cugos.wkg;

import java.nio.ByteBuffer;
import org.cugos.wkg.Envelope;
import org.cugos.wkg.GeoPackage;
import org.cugos.wkg.Geometry;
import org.cugos.wkg.WKB;
import org.cugos.wkg.WKBWriter;
import org.cugos.wkg.Writer;

public class GeoPackageWriter
implements Writer<byte[]> {
    private int version = 0;
    private GeoPackage.BinaryType binaryType = GeoPackage.BinaryType.Standard;
    private GeoPackage.EnvelopeType envelopType = GeoPackage.EnvelopeType.NoEnvelope;
    private WKB.Endian endian = WKB.Endian.Big;
    private WKBWriter wkbWriter;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public GeoPackageWriter() {
        this(WKB.Endian.Big, GeoPackage.EnvelopeType.Envelope);
    }

    public GeoPackageWriter(WKB.Endian endian, GeoPackage.EnvelopeType envelopeType) {
        this.endian = endian;
        this.envelopType = envelopeType;
        this.wkbWriter = new WKBWriter(WKB.Type.EWKB, endian);
    }

    public String writeToHex(Geometry geometry) {
        return GeoPackageWriter.toHex(this.write(geometry));
    }

    @Override
    public byte[] write(Geometry g) {
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateNumberOfBytes(g));
        buffer.put((byte)71);
        buffer.put((byte)80);
        buffer.put((byte)this.version);
        byte flag = 0;
        flag = (byte)(flag | (byte)this.envelopType.getValue() << 1 & GeoPackage.Flag.EnvelopeIndicator.getValue());
        flag = (byte)(flag | (byte)this.binaryType.getValue() & GeoPackage.Flag.BinaryType.getValue());
        flag = (byte)(flag | (byte)(g.isEmpty() ? GeoPackage.GeometryEmptyType.Empty.getValue() : GeoPackage.GeometryEmptyType.NotEmpty.getValue()) & GeoPackage.Flag.GeometryEmpty.getValue());
        flag = (byte)(flag | (byte)this.endian.getValue() & GeoPackage.Flag.Endianess.getValue());
        buffer.put(flag);
        buffer.putInt(g.getSrid() != null ? Integer.parseInt(g.getSrid()) : -1);
        if (this.envelopType != GeoPackage.EnvelopeType.NoEnvelope) {
            Envelope envelope = g.getEnvelope();
            buffer.putDouble(envelope.getMinX());
            buffer.putDouble(envelope.getMaxX());
            buffer.putDouble(envelope.getMinY());
            buffer.putDouble(envelope.getMaxY());
            if (this.envelopType == GeoPackage.EnvelopeType.EnvelopeZ || this.envelopType == GeoPackage.EnvelopeType.EnvelopeZM) {
                buffer.putDouble(envelope.getMinZ());
                buffer.putDouble(envelope.getMaxZ());
            }
            if (this.envelopType == GeoPackage.EnvelopeType.EnvelopeM || this.envelopType == GeoPackage.EnvelopeType.EnvelopeZM) {
                buffer.putDouble(envelope.getMinM());
                buffer.putDouble(envelope.getMaxM());
            }
        }
        this.wkbWriter.putGeometry(buffer, g);
        return buffer.array();
    }

    @Override
    public String getName() {
        return "GeoPackage";
    }

    protected int calculateNumberOfBytes(Geometry g) {
        return this.wkbWriter.calculateNumberOfBytes(g) + 2 + 1 + 1 + 4 + this.calculateNumberOfBytes(this.envelopType);
    }

    private int calculateNumberOfBytes(GeoPackage.EnvelopeType envelopeType) {
        if (envelopeType == GeoPackage.EnvelopeType.NoEnvelope) {
            return 0;
        }
        if (envelopeType == GeoPackage.EnvelopeType.Envelope) {
            return 32;
        }
        if (envelopeType == GeoPackage.EnvelopeType.EnvelopeZ) {
            return 48;
        }
        if (envelopeType == GeoPackage.EnvelopeType.EnvelopeM) {
            return 48;
        }
        if (envelopeType == GeoPackage.EnvelopeType.EnvelopeZM) {
            return 64;
        }
        return 0;
    }

    private static String toHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

